/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.stream.XMLStreamException;
import net.fabricmc.installer.Main;
import net.fabricmc.installer.util.Utils;

public class InstallerGui
extends JFrame {
    public static InstallerGui instance;
    private JTabbedPane contentPane;

    public InstallerGui() throws IOException {
        this.initComponents();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(3);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemClassLoader().getResource("icon.png")));
        Main.GAME_VERSION_META.load();
        Main.LOADER_META.load();
    }

    public static void selectInstallLocation(Supplier<String> initalDir, Consumer<String> selectedDir) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(initalDir.get()));
        chooser.setDialogTitle(Utils.BUNDLE.getString("prompt.select.location"));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(null) == 0) {
            selectedDir.accept(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public static void start() throws IOException, ClassNotFoundException, UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException, XMLStreamException {
        InstallerGui dialog;
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        instance = dialog = new InstallerGui();
        dialog.pack();
        dialog.setTitle(Utils.BUNDLE.getString("installer.title"));
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    private void initComponents() {
        this.contentPane = new JTabbedPane(1);
        Main.HANDLERS.forEach(handler -> this.contentPane.addTab(Utils.BUNDLE.getString("tab." + handler.name().toLowerCase(Locale.ROOT)), handler.makePanel(this)));
    }
}

