/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.Main;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.MetaHandler;
import net.fabricmc.installer.util.Utils;

public abstract class Handler
implements InstallerProgress {
    public JButton buttonInstall;
    public JComboBox<String> gameVersionComboBox;
    public JComboBox<String> loaderVersionComboBox;
    public JTextField installLocation;
    public JButton selectFolderButton;
    public JLabel statusLabel;
    public JCheckBox snapshotCheckBox;
    private JPanel pane;

    public abstract String name();

    public abstract void install();

    public abstract void installCli(ArgumentParser var1) throws Exception;

    public abstract String cliHelp();

    public abstract void setupPane1(JPanel var1, InstallerGui var2);

    public abstract void setupPane2(JPanel var1, InstallerGui var2);

    public JPanel makePanel(InstallerGui installerGui) {
        this.pane = new JPanel();
        this.pane.setLayout(new BoxLayout(this.pane, 3));
        this.setupPane1(this.pane, installerGui);
        this.addRow(this.pane, jPanel -> {
            jPanel.add(new JLabel(Utils.BUNDLE.getString("prompt.game.version")));
            this.gameVersionComboBox = new JComboBox();
            jPanel.add(this.gameVersionComboBox);
            this.snapshotCheckBox = new JCheckBox(Utils.BUNDLE.getString("option.show.snapshots"));
            jPanel.add(this.snapshotCheckBox);
            this.snapshotCheckBox.setSelected(false);
            this.snapshotCheckBox.addActionListener(e -> {
                if (Main.GAME_VERSION_META.isComplete()) {
                    this.updateGameVersions();
                }
            });
        });
        Main.GAME_VERSION_META.onComplete(versions -> this.updateGameVersions());
        this.addRow(this.pane, jPanel -> {
            jPanel.add(new JLabel(Utils.BUNDLE.getString("prompt.loader.version")));
            this.loaderVersionComboBox = new JComboBox();
            jPanel.add(this.loaderVersionComboBox);
        });
        this.addRow(this.pane, jPanel -> {
            jPanel.add(new JLabel(Utils.BUNDLE.getString("prompt.select.location")));
            this.installLocation = new JTextField();
            jPanel.add(this.installLocation);
            this.selectFolderButton = new JButton();
            jPanel.add(this.selectFolderButton);
            this.selectFolderButton.setText("...");
            this.selectFolderButton.addActionListener(e -> InstallerGui.selectInstallLocation(() -> this.installLocation.getText(), s -> this.installLocation.setText((String)s)));
        });
        this.setupPane2(this.pane, installerGui);
        this.addRow(this.pane, jPanel -> {
            this.statusLabel = new JLabel();
            jPanel.add(this.statusLabel);
            this.statusLabel.setText(Utils.BUNDLE.getString("prompt.loading.versions"));
        });
        this.addRow(this.pane, jPanel -> {
            this.buttonInstall = new JButton(Utils.BUNDLE.getString("prompt.install"));
            jPanel.add(this.buttonInstall);
            this.buttonInstall.addActionListener(e -> {
                this.buttonInstall.setEnabled(false);
                this.install();
            });
        });
        Main.LOADER_META.onComplete(versions -> {
            int stableIndex = -1;
            for (int i = 0; i < versions.size(); ++i) {
                MetaHandler.GameVersion version = (MetaHandler.GameVersion)versions.get(i);
                this.loaderVersionComboBox.addItem(version.getVersion());
                if (!version.isStable()) continue;
                stableIndex = i;
            }
            if (stableIndex == -1) {
                stableIndex = 0;
            }
            this.loaderVersionComboBox.setSelectedIndex(stableIndex);
            this.statusLabel.setText(Utils.BUNDLE.getString("prompt.ready.install"));
        });
        return this.pane;
    }

    private void updateGameVersions() {
        this.gameVersionComboBox.removeAllItems();
        for (MetaHandler.GameVersion version : Main.GAME_VERSION_META.getVersions()) {
            if (!this.snapshotCheckBox.isSelected() && !version.isStable()) continue;
            this.gameVersionComboBox.addItem(version.getVersion());
        }
        this.gameVersionComboBox.setSelectedIndex(0);
    }

    @Override
    public void updateProgress(String text) {
        this.statusLabel.setText(text);
        this.statusLabel.setForeground(UIManager.getColor("Label.foreground"));
    }

    private void appendException(StringBuilder errorMessage, String prefix, String name, Throwable e) {
        String prefixAppend = "  ";
        errorMessage.append(prefix).append(name).append(": ").append(e.getLocalizedMessage()).append('\n');
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            errorMessage.append(prefix).append("- ").append(stackTraceElement).append('\n');
        }
        if (e.getCause() != null) {
            this.appendException(errorMessage, prefix + prefixAppend, Utils.BUNDLE.getString("prompt.exception.caused.by"), e.getCause());
        }
        for (Serializable serializable : e.getSuppressed()) {
            this.appendException(errorMessage, prefix + prefixAppend, Utils.BUNDLE.getString("prompt.exception.suppressed"), (Throwable)serializable);
        }
    }

    protected String buildEditorPaneStyle() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color color = label.getBackground();
        return String.format("font-family:%s;font-weight:%s;font-size:%dpt;background-color: rgb(%d,%d,%d);", font.getFamily(), font.isBold() ? "bold" : "normal", font.getSize(), color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public void error(Throwable throwable) {
        StringBuilder errorMessage = new StringBuilder();
        this.appendException(errorMessage, "", Utils.BUNDLE.getString("prompt.exception"), throwable);
        System.err.println(errorMessage);
        JEditorPane textPane = new JEditorPane("text/html", "<html><body style=\"" + this.buildEditorPaneStyle() + "\">" + errorMessage.toString().replace("\n", "<br>") + "</body></html>");
        textPane.setEditable(false);
        this.statusLabel.setText(throwable.getLocalizedMessage());
        this.statusLabel.setForeground(Color.RED);
        JOptionPane.showMessageDialog(this.pane, textPane, Utils.BUNDLE.getString("prompt.exception.occurrence"), 0);
    }

    protected void addRow(Container parent, Consumer<JPanel> consumer) {
        JPanel panel = new JPanel(new FlowLayout());
        consumer.accept(panel);
        parent.add(panel);
    }

    protected String getGameVersion(ArgumentParser args) {
        return args.getOrDefault("mcversion", () -> {
            System.out.println("Using latest game version");
            try {
                Main.GAME_VERSION_META.load();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load latest versions", e);
            }
            return Main.GAME_VERSION_META.getLatestVersion(args.has("snapshot")).getVersion();
        });
    }

    protected String getLoaderVersion(ArgumentParser args) {
        return args.getOrDefault("loader", () -> {
            System.out.println("Using latest loader version");
            try {
                Main.LOADER_META.load();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load latest versions", e);
            }
            return Main.LOADER_META.getLatestVersion(false).getVersion();
        });
    }
}

