/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    public static void iterateContents(File zip, ZipTransformer visitor) {
        try (ZipFile origin = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> it = origin.entries();
            while (it.hasMoreElements() && visitor.keep(origin, it.nextElement())) {
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error iterating " + zip, e);
        }
    }

    public static void extract(File zip, File to) {
        ZipUtils.iterateContents(zip, (zipFile, entry) -> {
            String name = entry.getName();
            File extract = new File(to, name);
            if (name.indexOf("..") >= 0 && !extract.getCanonicalPath().startsWith(to.getCanonicalPath())) {
                throw new SecurityException("The file \"" + name + "\" (in " + zip + ") tried to leave the output directory: " + to);
            }
            if (entry.isDirectory()) {
                FileUtils.forceMkdir((File)extract);
            } else {
                FileUtils.forceMkdir((File)extract.getParentFile());
                FileUtils.copyInputStreamToFile((InputStream)zipFile.getInputStream(entry), (File)extract);
            }
            return true;
        });
    }

    public static void transformInPlace(File zip, ZipTransformer filter) {
        File tempZip = null;
        try {
            tempZip = File.createTempFile("optifabric", ".zip");
            ZipUtils.transform(zip, 5, filter, tempZip);
            FileUtils.moveFile((File)tempZip, (File)zip);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error modifying " + zip, e);
        }
        finally {
            FileUtils.deleteQuietly((File)tempZip);
        }
    }

    public static void transform(File zipOrigin, ZipTransformer filter, File zipDestination) {
        try {
            ZipUtils.transform(zipOrigin, 1, filter, zipDestination);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error transforming " + zipOrigin, e);
        }
    }

    private static void transform(File zipOrigin, int originFlags, ZipTransformer filter, File zipDestination) throws IOException {
        try (ZipFile origin = new ZipFile(zipOrigin, originFlags);
             ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipDestination)));){
            Enumeration<? extends ZipEntry> it = origin.entries();
            while (it.hasMoreElements()) {
                ZipEntry entry = it.nextElement();
                if (!filter.keep(origin, entry)) continue;
                out.putNextEntry(new ZipEntry(entry));
                IOUtils.copy((InputStream)origin.getInputStream(entry), (OutputStream)out);
            }
        }
    }

    public static interface ZipTransformer {
        public boolean keep(ZipFile var1, ZipEntry var2) throws IOException;
    }
}

