/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher.fixes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.modmuss50.optifabric.compat.fabricrenderingfluids.FluidRendererFix;
import me.modmuss50.optifabric.patcher.fixes.AmbientOcclusionCalculatorFix;
import me.modmuss50.optifabric.patcher.fixes.BlockModelRendererFix;
import me.modmuss50.optifabric.patcher.fixes.ChunkRendererFix;
import me.modmuss50.optifabric.patcher.fixes.ClassFixer;
import me.modmuss50.optifabric.patcher.fixes.KeyboardFix;
import me.modmuss50.optifabric.patcher.fixes.ModelOverrideListFix;
import me.modmuss50.optifabric.patcher.fixes.ParticleManagerFix;
import me.modmuss50.optifabric.patcher.fixes.SpriteAtlasTextureFix;
import me.modmuss50.optifabric.util.RemappingUtils;
import net.fabricmc.loader.api.FabricLoader;

public class OptifineFixer {
    public static final OptifineFixer INSTANCE = new OptifineFixer();
    private final Map<String, List<ClassFixer>> classFixes = new HashMap<String, List<ClassFixer>>();
    private final Set<String> skippedClass = new HashSet<String>();

    private OptifineFixer() {
        this.registerFix("class_846$class_851$class_4578", new ChunkRendererFix());
        this.registerFix("class_778", new BlockModelRendererFix());
        this.registerFix("class_778$class_780", new AmbientOcclusionCalculatorFix());
        this.registerFix("class_309", new KeyboardFix());
        this.registerFix("class_1059", new SpriteAtlasTextureFix());
        this.registerFix("class_702", new ParticleManagerFix());
        this.registerFix("class_806", new ModelOverrideListFix());
        if (FabricLoader.getInstance().isModLoaded("fabric-rendering-fluids-v1")) {
            this.registerFix("class_775", new FluidRendererFix());
        }
    }

    private void registerFix(String className, ClassFixer classFixer) {
        this.classFixes.computeIfAbsent(RemappingUtils.getClassName(className), s -> new ArrayList()).add(classFixer);
    }

    private void skipClass(String className) {
        this.skippedClass.add(RemappingUtils.getClassName(className));
    }

    public boolean shouldSkip(String className) {
        return this.skippedClass.contains(className);
    }

    public List<ClassFixer> getFixers(String className) {
        return this.classFixes.getOrDefault(className, Collections.emptyList());
    }
}

