/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.modmuss50.optifabric.mod.OptifineInstaller;
import me.modmuss50.optifabric.mod.OptifineVersion;
import me.modmuss50.optifabric.patcher.ClassCache;
import me.modmuss50.optifabric.patcher.LambdaRebuiler;
import me.modmuss50.optifabric.patcher.PatchSplitter;
import me.modmuss50.optifabric.patcher.RemapUtils;
import me.modmuss50.optifabric.util.ZipUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.fabricmc.loader.util.mappings.TinyRemapperMappingsHelper;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OptifineSetup {
    public static Pair<File, ClassCache> getRuntime() throws IOException {
        boolean extractClasses;
        File workingDir = new File(FabricLoader.getInstance().getGameDirectory(), ".optifine");
        if (!workingDir.exists()) {
            workingDir.mkdirs();
        }
        File optifineModJar = OptifineVersion.findOptifineJar();
        byte[] modHash = OptifineSetup.fileHash(optifineModJar);
        File versionDir = new File(workingDir, OptifineVersion.version);
        if (!versionDir.exists()) {
            versionDir.mkdirs();
        }
        File remappedJar = new File(versionDir, "Optifine-mapped.jar");
        File optifinePatches = new File(versionDir, "Optifine.classes.gz");
        ClassCache classCache = null;
        if (remappedJar.exists() && optifinePatches.exists() && !Arrays.equals((classCache = ClassCache.read(optifinePatches)).getHash(), modHash)) {
            System.out.println("Class cache is from a different optifine jar, deleting and re-generating");
            classCache = null;
            optifinePatches.delete();
        }
        if (remappedJar.exists() && classCache != null) {
            System.out.println("Found existing patched optifine jar, using that");
            return Pair.of((Object)remappedJar, (Object)classCache);
        }
        if (OptifineVersion.jarType == OptifineVersion.JarType.OPTIFINE_INSTALLER) {
            File optifineMod = new File(versionDir, "/Optifine-mod.jar");
            if (!optifineMod.exists()) {
                OptifineInstaller.extract(optifineModJar, optifineMod, OptifineSetup.getMinecraftJar().toFile());
            }
            optifineModJar = optifineMod;
        }
        System.out.println("Setting up optifine for the first time, this may take a few seconds.");
        File jarOfTheFree = new File(versionDir, "/Optifine-jarofthefree.jar");
        System.out.println("De-Volderfiying jar");
        ZipUtils.transform(optifineModJar, (zip, zipEntry) -> {
            String[] split;
            String name = zipEntry.getName();
            if (name.startsWith("com/mojang/blaze3d/platform/") && name.contains("$") && (split = name.replace(".class", "").split("\\$")).length >= 2 && split[1].length() > 2) {
                return false;
            }
            return !name.startsWith("srg/") && !name.startsWith("net/minecraft/");
        }, jarOfTheFree);
        System.out.println("Building lambada fix mappings");
        LambdaRebuiler rebuiler = new LambdaRebuiler(jarOfTheFree, OptifineSetup.getMinecraftJar().toFile());
        rebuiler.buildLambadaMap();
        System.out.println("Remapping optifine with fixed lambada names");
        File lambadaFixJar = new File(versionDir, "/Optifine-lambadafix.jar");
        RemapUtils.mapJar(lambadaFixJar.toPath(), jarOfTheFree.toPath(), rebuiler, OptifineSetup.getLibs());
        OptifineSetup.remapOptifine(lambadaFixJar.toPath(), remappedJar);
        classCache = PatchSplitter.generateClassCache(remappedJar, optifinePatches, modHash);
        lambadaFixJar.delete();
        jarOfTheFree.delete();
        if (OptifineVersion.jarType == OptifineVersion.JarType.OPTIFINE_INSTALLER) {
            optifineModJar.delete();
        }
        if (extractClasses = Boolean.parseBoolean(System.getProperty("optifabric.extract", "false"))) {
            System.out.println("Extracting optifine classes");
            File optifineClasses = new File(versionDir, "optifine-classes");
            if (optifineClasses.exists()) {
                FileUtils.deleteDirectory((File)optifineClasses);
            }
            ZipUtils.extract(remappedJar, optifineClasses);
        }
        return Pair.of((Object)remappedJar, (Object)classCache);
    }

    private static void remapOptifine(Path input, File remappedJar) throws IOException {
        String namespace = FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
        System.out.println("Remapping optifine to :" + namespace);
        List<Path> mcLibs = OptifineSetup.getLibs();
        mcLibs.add(OptifineSetup.getMinecraftJar());
        RemapUtils.mapJar(remappedJar.toPath(), input, OptifineSetup.createMappings("official", namespace), mcLibs);
    }

    private static IMappingProvider createMappings(String from, String to) {
        TinyTree normalMappings = FabricLauncherBase.getLauncher().getMappingConfiguration().getMappings();
        Map nameToClass = normalMappings.getClasses().stream().collect(Collectors.toMap(clazz -> clazz.getName("intermediary"), Function.identity()));
        HashMap<IMappingProvider.Member, String> extraFields = new HashMap<IMappingProvider.Member, String>();
        ClassDef rebuildTask = (ClassDef)nameToClass.get("net/minecraft/class_846$class_851$class_4578");
        ClassDef builtChunk = (ClassDef)nameToClass.get("net/minecraft/class_846$class_851");
        extraFields.put(new IMappingProvider.Member(rebuildTask.getName(from), "this$1", 'L' + builtChunk.getName(from) + ';'), "field_20839");
        ClassDef particleManager = (ClassDef)nameToClass.get("net/minecraft/class_702");
        particleManager.getFields().stream().filter(field -> "field_3835".equals(field.getName("intermediary"))).forEach(field -> extraFields.put(new IMappingProvider.Member(particleManager.getName(from), field.getName(from), "Ljava/util/Map;"), field.getName(to)));
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ClassDef option = (ClassDef)nameToClass.get("net/minecraft/class_316");
            ClassDef cyclingOption = (ClassDef)nameToClass.get("net/minecraft/class_4064");
            extraFields.put(new IMappingProvider.Member(option.getName(from), "CLOUDS", 'L' + cyclingOption.getName(from) + ';'), "CLOUDS_OF");
            ClassDef worldRenderer = (ClassDef)nameToClass.get("net/minecraft/class_761");
            extraFields.put(new IMappingProvider.Member(worldRenderer.getName(from), "renderDistance", "I"), "renderDistance_OF");
        }
        return out -> {
            TinyRemapperMappingsHelper.create((TinyTree)normalMappings, (String)from, (String)to).load(out);
            extraFields.forEach((arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)out).acceptField(arg_0, arg_1));
        };
    }

    private static List<Path> getLibs() {
        return FabricLauncherBase.getLauncher().getLoadTimeDependencies().stream().map(url -> {
            try {
                return UrlUtil.asPath((URL)url);
            }
            catch (UrlConversionException e) {
                throw new RuntimeException(e);
            }
        }).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
    }

    private static Path getMinecraftJar() throws FileNotFoundException {
        List contextJars = ((net.fabricmc.loader.FabricLoader)FabricLoader.getInstance()).getGameProvider().getGameContextJars();
        if (contextJars.isEmpty()) {
            throw new IllegalStateException("Start has no context?");
        }
        Path minecraftJar = (Path)contextJars.get(0);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Path officialNames = minecraftJar.resolveSibling(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
            if (Files.notExists(officialNames, new LinkOption[0])) {
                Path parent = minecraftJar.getParent().resolveSibling(String.format("minecraft-%s-client.jar", OptifineVersion.minecraftVersion));
                if (Files.notExists(parent, new LinkOption[0])) {
                    throw new AssertionError((Object)("Unable to find Minecraft dev jar! Tried " + officialNames + " and " + parent));
                }
                officialNames = parent;
            }
            minecraftJar = officialNames;
        }
        return minecraftJar;
    }

    private static byte[] fileHash(File input) throws IOException {
        try (FileInputStream is = new FileInputStream(input);){
            byte[] byArray = DigestUtils.md5((InputStream)is);
            return byArray;
        }
    }
}

