/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import com.chocohead.mm.api.ClassTinkerers;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.modmuss50.optifabric.mod.OptifabricError;
import me.modmuss50.optifabric.mod.OptifineInjector;
import me.modmuss50.optifabric.mod.OptifineSetup;
import me.modmuss50.optifabric.mod.OptifineVersion;
import me.modmuss50.optifabric.patcher.ClassCache;
import me.modmuss50.optifabric.util.RemappingUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.util.version.SemanticVersionImpl;
import net.fabricmc.loader.util.version.SemanticVersionPredicateParser;
import net.fabricmc.loader.util.version.VersionParsingException;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.Mixins;

public class OptifabricSetup
implements Runnable {
    public static File optifineRuntimeJar = null;

    @Override
    public void run() {
        OptifineInjector injector;
        try {
            Pair<File, ClassCache> runtime = OptifineSetup.getRuntime();
            optifineRuntimeJar = (File)runtime.getLeft();
            ClassTinkerers.addURL((URL)((File)runtime.getLeft()).toURI().toURL());
            injector = new OptifineInjector((ClassCache)runtime.getRight());
            injector.setup();
        }
        catch (Throwable e) {
            if (!OptifabricError.hasError()) {
                OptifineVersion.jarType = OptifineVersion.JarType.INTERNAL_ERROR;
                OptifabricError.setError("Failed to load optifine, check the log for more info \n\n " + e.getMessage());
            }
            throw new RuntimeException("Failed to setup optifine", e);
        }
        if (OptifabricSetup.isPresent("fabric-renderer-indigo")) {
            Mixins.addConfiguration((String)"optifabric.compat.indigo.mixins.json");
        }
        if (OptifabricSetup.isPresent("fabric-item-api-v1", ">=1.1.0")) {
            Mixins.addConfiguration((String)"optifabric.compat.fabric-item-api.mixins.json");
        }
        Mixins.addConfiguration((String)"optifabric.optifine.mixins.json");
        if (OptifabricSetup.isPresent("cloth-client-events-v0")) {
            Mixins.addConfiguration((String)"optifabric.compat.cloth.mixins.json");
        }
        if (OptifabricSetup.isPresent("clothesline")) {
            Mixins.addConfiguration((String)"optifabric.compat.clothesline.mixins.json");
        }
        if (OptifabricSetup.isPresent("trumpet-skeleton")) {
            Mixins.addConfiguration((String)"optifabric.compat.trumpet-skeleton.mixins.json");
        }
        if (OptifabricSetup.isPresent("multiconnect", ">1.3.14")) {
            Mixins.addConfiguration((String)"optifabric.compat.multiconnect.mixins.json");
        }
        if (OptifabricSetup.isPresent("now-playing", ">=1.1.0")) {
            Mixins.addConfiguration((String)"optifabric.compat.now-playing.mixins.json");
        }
        if (OptifabricSetup.isPresent("origins", (ModMetadata mod) -> OptifabricSetup.compareVersions(Pattern.matches("^1\\.16(\\.\\d)?-", mod.getVersion().getFriendlyString()) ? ">=1.16-0.2.0" : ">=0.4.1", mod))) {
            if (OptifabricSetup.isPresent("origins", (ModMetadata mod) -> !Pattern.matches("^1\\.16(\\.\\d)?-", mod.getVersion().getFriendlyString()) || OptifabricSetup.compareVersions(">=1.16.2-0.3.7", mod))) {
                Mixins.addConfiguration((String)"optifabric.compat.origins.mixins.json");
            }
            injector.predictFuture(RemappingUtils.getClassName("class_979")).ifPresent(node -> {
                String desc = RemappingUtils.mapMethodDescriptor("(Lnet/minecraft/class_1799;Lnet/minecraft/class_1309;)Z");
                for (MethodNode method : node.methods) {
                    if (!"shouldRender".equals(method.name) || !desc.equals(method.desc)) continue;
                    Mixins.addConfiguration((String)"optifabric.compat.origins.extra-mixins.json");
                    break;
                }
            });
        }
        if (OptifabricSetup.isPresent("staffofbuilding")) {
            Mixins.addConfiguration((String)"optifabric.compat.staffofbuilding.mixins.json");
        }
        if (OptifabricSetup.isPresent("sandwichable")) {
            Mixins.addConfiguration((String)"optifabric.compat.sandwichable.mixins.json");
        }
        if (OptifabricSetup.isPresent("astromine", "<1.6")) {
            Mixins.addConfiguration((String)"optifabric.compat.astromine.mixins.json");
        }
        if (OptifabricSetup.isPresent("carpet")) {
            Mixins.addConfiguration((String)"optifabric.compat.carpet.mixins.json");
            injector.predictFuture(RemappingUtils.getClassName("class_702")).ifPresent(node -> {
                String desc = RemappingUtils.mapMethodDescriptor("(Lnet/minecraft/class_4587;Lnet/minecraft/class_4597$class_4598;Lnet/minecraft/class_765;Lnet/minecraft/class_4184;FLnet/minecraft/class_4604;)V");
                for (MethodNode method : node.methods) {
                    if (!"renderParticles".equals(method.name) || !desc.equals(method.desc)) continue;
                    Mixins.addConfiguration((String)"optifabric.compat.carpet.extra-mixins.json");
                    break;
                }
            });
        }
        if (OptifabricSetup.isPresent("hctm-base")) {
            Mixins.addConfiguration((String)"optifabric.compat.hctm.mixins.json");
        }
        if (OptifabricSetup.isPresent("mubble", "<1.3")) {
            Mixins.addConfiguration((String)"optifabric.compat.mubble.mixins.json");
        }
        if (OptifabricSetup.isPresent("dawn", ">=1.3 <=1.4")) {
            Mixins.addConfiguration((String)"optifabric.compat.dawn.older-mixins.json");
        } else if (OptifabricSetup.isPresent("dawn", ">1.4 <1.5")) {
            Mixins.addConfiguration((String)"optifabric.compat.dawn.old-mixins.json");
        } else if (OptifabricSetup.isPresent("dawn", ">=1.5")) {
            Mixins.addConfiguration((String)"optifabric.compat.dawn.mixins.json");
        }
        if (OptifabricSetup.isPresent("phormat")) {
            Mixins.addConfiguration((String)"optifabric.compat.phormat.mixins.json");
        }
        if (OptifabricSetup.isPresent("chat_heads", "<0.2")) {
            Mixins.addConfiguration((String)"optifabric.compat.chat-heads.mixins.json");
        }
        if (OptifabricSetup.isPresent("mmorpg")) {
            Mixins.addConfiguration((String)"optifabric.compat.age-of-exile.mixins.json");
        }
        if (OptifabricSetup.isPresent("charm", ">=2.0 <2.1")) {
            Mixins.addConfiguration((String)"optifabric.compat.charm-old.mixins.json");
        } else if (OptifabricSetup.isPresent("charm", ">=2.1")) {
            Mixins.addConfiguration((String)"optifabric.compat.charm.mixins.json");
        }
        if (OptifabricSetup.isPresent("voxelmap")) {
            Mixins.addConfiguration((String)"optifabric.compat.voxelmap.mixins.json");
        }
    }

    private static boolean isPresent(String modID) {
        return FabricLoader.getInstance().isModLoaded(modID);
    }

    private static boolean isPresent(String modID, String versionRange) {
        return OptifabricSetup.isPresent(modID, (ModMetadata modMetadata) -> OptifabricSetup.compareVersions(versionRange, modMetadata));
    }

    private static boolean isPresent(String modID, Predicate<ModMetadata> extraChecks) {
        if (!OptifabricSetup.isPresent(modID)) {
            return false;
        }
        Optional modContainer = FabricLoader.getInstance().getModContainer(modID);
        ModMetadata modMetadata = modContainer.map(ModContainer::getMetadata).orElseThrow(() -> new RuntimeException("Failed to get mod container for " + modID + ", something has broke badly."));
        return extraChecks.test(modMetadata);
    }

    private static boolean compareVersions(String versionRange, ModMetadata mod) {
        try {
            Predicate predicate = SemanticVersionPredicateParser.create((String)versionRange);
            SemanticVersionImpl version = new SemanticVersionImpl(mod.getVersion().getFriendlyString(), false);
            return predicate.test(version);
        }
        catch (VersionParsingException e) {
            System.err.println("Error comparing the version for ".concat((String)MoreObjects.firstNonNull((Object)mod.getName(), (Object)mod.getId())));
            e.printStackTrace();
            return false;
        }
    }
}

