/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.model.anim;

import info.ata4.minecraft.dragon.util.math.MathX;
import java.util.Arrays;

public class CircularBuffer {
    private double[] buffer;
    private int index = 0;

    public CircularBuffer(int size) {
        this.buffer = new double[size];
    }

    public void fill(double value) {
        Arrays.fill(this.buffer, value);
    }

    public void update(double value) {
        ++this.index;
        this.index %= this.buffer.length;
        this.buffer[this.index] = value;
    }

    public double get(float x, int offset) {
        int i = this.index - offset;
        int len = this.buffer.length - 1;
        return MathX.lerp(this.buffer[i - 1 & len], this.buffer[i & len], (double)x);
    }

    public double get(float x, int offset1, int offset2) {
        return this.get(x, offset2) - this.get(x, offset1);
    }
}

