/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.model;

import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.client.model.ModelPart;
import info.ata4.minecraft.dragon.client.model.ModelPartProxy;
import info.ata4.minecraft.dragon.client.model.anim.DragonAnimator;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.util.math.MathX;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class DragonModel
extends ModelBase {
    public static final int NECK_SIZE = 10;
    public static final int TAIL_SIZE = 10;
    public static final int VERTS_NECK = 7;
    public static final int VERTS_TAIL = 12;
    public static final int HEAD_OFS = -16;
    public final ResourceLocation bodyTexture;
    public final ResourceLocation glowTexture;
    public final ResourceLocation saddleTexture;
    public final ResourceLocation eggTexture;
    public ModelPart head;
    public ModelPart neck;
    public ModelPart neckScale;
    public ModelPart tail;
    public ModelPart tailHornLeft;
    public ModelPart tailHornRight;
    public ModelPart tailScaleLeft;
    public ModelPart tailScaleMiddle;
    public ModelPart tailScaleRight;
    public ModelPart jaw;
    public ModelPart body;
    public ModelPart back;
    public ModelPart forethigh;
    public ModelPart forecrus;
    public ModelPart forefoot;
    public ModelPart foretoe;
    public ModelPart hindthigh;
    public ModelPart hindcrus;
    public ModelPart hindfoot;
    public ModelPart hindtoe;
    public ModelPart wingArm;
    public ModelPart wingForearm;
    public ModelPart[] wingFinger = new ModelPart[4];
    public ModelPartProxy[] neckProxy = new ModelPartProxy[7];
    public ModelPartProxy[] tailProxy = new ModelPartProxy[12];
    public ModelPartProxy[] thighProxy = new ModelPartProxy[4];
    public int renderPass = -1;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float pitch;
    public float size;
    private DragonBreed breed;

    public DragonModel(DragonBreed breed) {
        this.field_78090_t = 256;
        this.field_78089_u = 256;
        this.bodyTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/" + breed.getSkin() + "/body.png");
        this.glowTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/" + breed.getSkin() + "/glow.png");
        this.saddleTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/" + breed.getSkin() + "/saddle.png");
        this.eggTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/" + breed.getSkin() + "/egg.png");
        this.breed = breed;
        this.func_78085_a("body.body", 0, 0);
        this.func_78085_a("body.scale", 0, 32);
        this.func_78085_a("head.nostril", 48, 0);
        this.func_78085_a("head.upperhead", 0, 0);
        this.func_78085_a("head.upperjaw", 56, 88);
        this.func_78085_a("head.lowerjaw", 0, 88);
        this.func_78085_a("head.horn", 28, 32);
        this.func_78085_a("forethigh.main", 112, 0);
        this.func_78085_a("forecrus.main", 148, 0);
        this.func_78085_a("forefoot.main", 210, 0);
        this.func_78085_a("foretoe.main", 176, 0);
        this.func_78085_a("hindthigh.main", 112, 29);
        this.func_78085_a("hindcrus.main", 152, 29);
        this.func_78085_a("hindfoot.main", 180, 29);
        this.func_78085_a("hindtoe.main", 215, 29);
        this.func_78085_a("neck.box", 112, 88);
        this.func_78085_a("neck.scale", 0, 0);
        this.func_78085_a("tail.box", 152, 88);
        this.func_78085_a("tail.scale", 0, 0);
        this.func_78085_a("tail.horn", 0, 117);
        this.func_78085_a("wingarm.bone", 0, 152);
        this.func_78085_a("wingarm.skin", 116, 232);
        this.func_78085_a("wingfinger.bone", 0, 172);
        this.func_78085_a("wingfinger.shortskin", -32, 224);
        this.func_78085_a("wingfinger.skin", -49, 176);
        this.func_78085_a("wingforearm.bone", 0, 164);
        this.buildBody();
        this.buildNeck();
        this.buildHead();
        this.buildTail();
        this.buildWing();
        this.buildLegs();
    }

    public ResourceLocation getEggTexture() {
        return this.eggTexture;
    }

    private void buildHead() {
        this.head = new ModelPart(this, "head");
        this.head.func_78786_a("upperjaw", -6.0f, -1.0f, -24.0f, 12, 5, 16);
        this.head.func_78786_a("upperhead", -8.0f, -8.0f, -10.0f, 16, 16, 16);
        this.head.func_78786_a("nostril", -5.0f, -3.0f, -22.0f, 2, 2, 4);
        this.head.field_78809_i = true;
        this.head.func_78786_a("nostril", 3.0f, -3.0f, -22.0f, 2, 2, 4);
        this.buildHorn(false);
        this.buildHorn(true);
        this.jaw = this.head.addChildBox("lowerjaw", -6.0f, 0.0f, -16.0f, 12, 4, 16);
        this.jaw.func_78793_a(0.0f, 4.0f, -8.0f);
    }

    private void buildHorn(boolean mirror) {
        int hornThick = 3;
        int hornLength = 12;
        float hornOfs = -((float)hornThick / 2.0f);
        float hornPosX = -5.0f;
        float hornPosY = -8.0f;
        float hornPosZ = 0.0f;
        float hornRotX = MathX.toRadians(30.0f);
        float hornRotY = MathX.toRadians(-30.0f);
        float hornRotZ = 0.0f;
        if (mirror) {
            hornPosX *= -1.0f;
            hornRotY *= -1.0f;
        }
        this.head.field_78809_i = mirror;
        ModelPart horn = this.head.addChildBox("horn", hornOfs, hornOfs, hornOfs, hornThick, hornThick, hornLength);
        horn.func_78793_a(hornPosX, hornPosY, hornPosZ);
        horn.setAngles(hornRotX, hornRotY, hornRotZ);
    }

    private void buildNeck() {
        this.neck = new ModelPart(this, "neck");
        this.neck.func_78786_a("box", -5.0f, -5.0f, -5.0f, 10, 10, 10);
        this.neckScale = this.neck.addChildBox("scale", -1.0f, -7.0f, -3.0f, 2, 4, 6);
        for (int i = 0; i < this.neckProxy.length; ++i) {
            this.neckProxy[i] = new ModelPartProxy(this.neck);
        }
    }

    private void buildTail() {
        this.tail = new ModelPart(this, "tail");
        this.tail.func_78786_a("box", -5.0f, -5.0f, -5.0f, 10, 10, 10);
        float scaleRotZ = MathX.toRadians(45.0f);
        this.tailScaleLeft = this.tail.addChildBox("scale", -1.0f, -8.0f, -3.0f, 2, 4, 6).setAngles(0.0f, 0.0f, scaleRotZ);
        this.tailScaleMiddle = this.tail.addChildBox("scale", -1.0f, -8.0f, -3.0f, 2, 4, 6).setAngles(0.0f, 0.0f, 0.0f);
        this.tailScaleRight = this.tail.addChildBox("scale", -1.0f, -8.0f, -3.0f, 2, 4, 6).setAngles(0.0f, 0.0f, -scaleRotZ);
        boolean fire = this.breed.getName().equals("fire");
        this.tailScaleMiddle.field_78806_j = !fire;
        this.tailScaleLeft.field_78806_j = fire;
        this.tailScaleRight.field_78806_j = fire;
        this.buildTailHorn(false);
        this.buildTailHorn(true);
        for (int i = 0; i < this.tailProxy.length; ++i) {
            this.tailProxy[i] = new ModelPartProxy(this.tail);
        }
    }

    private void buildTailHorn(boolean mirror) {
        int hornThick = 3;
        int hornLength = 32;
        float hornOfs = -((float)hornThick / 2.0f);
        float hornPosX = 0.0f;
        float hornPosY = hornOfs;
        float hornPosZ = 5.0f;
        float hornRotX = MathX.toRadians(-15.0f);
        float hornRotY = MathX.toRadians(-145.0f);
        float hornRotZ = 0.0f;
        if (mirror) {
            hornPosX *= -1.0f;
            hornRotY *= -1.0f;
        }
        this.tail.field_78809_i = mirror;
        ModelPart horn = this.tail.addChildBox("horn", hornOfs, hornOfs, hornOfs, hornThick, hornThick, hornLength);
        horn.func_78793_a(hornPosX, hornPosY, hornPosZ);
        horn.setAngles(hornRotX, hornRotY, hornRotZ);
        horn.field_78807_k = true;
        horn.field_78806_j = this.breed.getName().equals("water");
        if (mirror) {
            this.tailHornLeft = horn;
        } else {
            this.tailHornRight = horn;
        }
    }

    private void buildBody() {
        this.body = new ModelPart(this, "body");
        this.body.func_78793_a(0.0f, 4.0f, 8.0f);
        this.body.func_78786_a("body", -12.0f, 0.0f, -16.0f, 24, 24, 64);
        this.body.func_78786_a("scale", -1.0f, -6.0f, 10.0f, 2, 6, 12);
        this.body.func_78786_a("scale", -1.0f, -6.0f, 30.0f, 2, 6, 12);
        this.back = this.body.addChildBox("scale", -1.0f, -6.0f, -10.0f, 2, 6, 12);
    }

    private void buildWing() {
        this.wingArm = new ModelPart(this, "wingarm");
        this.wingArm.func_78793_a(-10.0f, 5.0f, 4.0f);
        this.wingArm.setRenderScale(1.1f);
        this.wingArm.func_78786_a("bone", -28.0f, -3.0f, -3.0f, 28, 6, 6);
        this.wingArm.func_78786_a("skin", -28.0f, 0.0f, 2.0f, 28, 0, 24);
        this.wingForearm = new ModelPart(this, "wingforearm");
        this.wingForearm.func_78793_a(-28.0f, 0.0f, 0.0f);
        this.wingForearm.func_78786_a("bone", -48.0f, -2.0f, -2.0f, 48, 4, 4);
        this.wingArm.func_78792_a(this.wingForearm);
        this.wingFinger[0] = this.buildWingFinger(false);
        this.wingFinger[1] = this.buildWingFinger(false);
        this.wingFinger[2] = this.buildWingFinger(false);
        this.wingFinger[3] = this.buildWingFinger(true);
    }

    private ModelPart buildWingFinger(boolean small) {
        ModelPart finger = new ModelPart(this, "wingfinger");
        finger.func_78793_a(-47.0f, 0.0f, 0.0f);
        finger.func_78786_a("bone", -70.0f, -1.0f, -1.0f, 70, 2, 2);
        if (small) {
            finger.func_78786_a("shortskin", -70.0f, 0.0f, 1.0f, 70, 0, 32);
        } else {
            finger.func_78786_a("skin", -70.0f, 0.0f, 1.0f, 70, 0, 48);
        }
        this.wingForearm.func_78792_a(finger);
        return finger;
    }

    private void buildLegs() {
        this.buildLeg(false);
        this.buildLeg(true);
        for (int i = 0; i < 4; ++i) {
            this.thighProxy[i] = i % 2 == 0 ? new ModelPartProxy(this.forethigh) : new ModelPartProxy(this.hindthigh);
        }
    }

    private void buildLeg(boolean hind) {
        boolean skeleton = this.breed.getName().equals("ghost");
        float baseLength = 26.0f;
        String baseName = hind ? "hind" : "fore";
        float thighPosX = -11.0f;
        float thighPosY = 18.0f;
        float thighPosZ = 4.0f;
        int thighThick = 9 - (skeleton ? 2 : 0);
        int thighLength = (int)(baseLength * (hind ? 0.9f : 0.77f));
        if (hind) {
            ++thighThick;
            thighPosY -= 5.0f;
        }
        float thighOfs = -((float)thighThick / 2.0f);
        ModelPart thigh = new ModelPart(this, baseName + "thigh");
        thigh.func_78793_a(thighPosX, thighPosY, thighPosZ);
        thigh.func_78786_a("main", thighOfs, thighOfs, thighOfs, thighThick, thighLength, thighThick);
        float crusPosX = 0.0f;
        float crusPosY = (float)thighLength + thighOfs;
        float crusPosZ = 0.0f;
        int crusThick = thighThick - 2;
        int crusLength = (int)(baseLength * (hind ? 0.7f : 0.8f));
        if (hind) {
            --crusThick;
            crusLength -= 2;
        }
        float crusOfs = -((float)crusThick / 2.0f);
        ModelPart crus = new ModelPart(this, baseName + "crus");
        crus.func_78793_a(crusPosX, crusPosY, crusPosZ);
        crus.func_78786_a("main", crusOfs, crusOfs, crusOfs, crusThick, crusLength, crusThick);
        thigh.func_78792_a(crus);
        float footPosX = 0.0f;
        float footPosY = (float)crusLength + crusOfs / 2.0f;
        float footPosZ = 0.0f;
        int footWidth = crusThick + 2 + (skeleton ? 2 : 0);
        int footHeight = 4;
        int footLength = (int)(baseLength * (hind ? 0.67f : 0.34f));
        float footOfsX = -((float)footWidth / 2.0f);
        float footOfsY = -((float)footHeight / 2.0f);
        float footOfsZ = (float)footLength * -0.75f;
        ModelPart foot = new ModelPart(this, baseName + "foot");
        foot.func_78793_a(footPosX, footPosY, footPosZ);
        foot.func_78786_a("main", footOfsX, footOfsY, footOfsZ, footWidth, footHeight, footLength);
        crus.func_78792_a(foot);
        int toeWidth = footWidth;
        int toeHeight = footHeight;
        int toeLength = (int)(baseLength * (hind ? 0.27f : 0.33f));
        float toePosX = 0.0f;
        float toePosY = 0.0f;
        float toePosZ = footOfsZ - footOfsY / 2.0f;
        float toeOfsX = -((float)toeWidth / 2.0f);
        float toeOfsY = -((float)toeHeight / 2.0f);
        float toeOfsZ = -toeLength;
        ModelPart toe = new ModelPart(this, baseName + "toe");
        toe.func_78793_a(toePosX, toePosY, toePosZ);
        toe.func_78786_a("main", toeOfsX, toeOfsY, toeOfsZ, toeWidth, toeHeight, toeLength);
        foot.func_78792_a(toe);
        if (hind) {
            this.hindthigh = thigh;
            this.hindcrus = crus;
            this.hindfoot = foot;
            this.hindtoe = toe;
        } else {
            this.forethigh = thigh;
            this.forecrus = crus;
            this.forefoot = foot;
            this.foretoe = toe;
        }
    }

    public void func_78086_a(EntityLivingBase entity, float moveTime, float moveSpeed, float partialTicks) {
        this.setLivingAnimations((EntityTameableDragon)entity, moveTime, moveSpeed, partialTicks);
    }

    public void setLivingAnimations(EntityTameableDragon dragon, float moveTime, float moveSpeed, float partialTicks) {
        DragonAnimator animator = dragon.getAnimator();
        animator.setPartialTicks(partialTicks);
    }

    public void func_78088_a(Entity entity, float moveTime, float moveSpeed, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        this.render((EntityTameableDragon)entity, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
    }

    public void render(EntityTameableDragon dragon, float moveTime, float moveSpeed, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        DragonAnimator animator = dragon.getAnimator();
        animator.setMovement(moveTime, moveSpeed * dragon.getScale());
        animator.setLook(lookYaw, lookPitch);
        animator.setTicksExisted(ticksExisted);
        animator.animate(this);
        this.size = dragon.getScale();
        this.renderModel(dragon, scale);
    }

    public void renderModel(EntityTameableDragon dragon, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
        GL11.glRotatef((float)(-this.pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.renderPass == 0) {
            this.renderBody(scale);
        } else {
            this.renderHead(scale);
            this.renderNeck(scale);
            this.renderBody(scale);
            this.renderLegs(scale);
            this.renderTail(scale);
            this.renderWings(scale);
        }
        GL11.glPopMatrix();
    }

    protected void renderBody(float scale) {
        this.body.func_78785_a(scale);
    }

    protected void renderHead(float scale) {
        float headScale = 1.4f / (this.size + 0.4f);
        this.head.setRenderScale(headScale);
        this.head.func_78785_a(scale);
    }

    protected void renderNeck(float scale) {
        for (ModelPartProxy proxy : this.neckProxy) {
            proxy.render(scale);
        }
    }

    protected void renderTail(float scale) {
        for (ModelPartProxy proxy : this.tailProxy) {
            proxy.render(scale);
        }
    }

    protected void renderWings(float scale) {
        GL11.glPushMatrix();
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1028);
        for (int i = 0; i < 2; ++i) {
            this.wingArm.func_78785_a(scale);
            if (i != 0) continue;
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            GL11.glCullFace((int)1029);
        }
        GL11.glDisable((int)2884);
        GL11.glPopMatrix();
    }

    protected void renderLegs(float scale) {
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1029);
        for (int i = 0; i < this.thighProxy.length; ++i) {
            this.thighProxy[i].render(scale);
            if (i != 1) continue;
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            GL11.glCullFace((int)1028);
        }
        GL11.glCullFace((int)1029);
        GL11.glDisable((int)2884);
    }
}

