/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.client.gui.GuiTextPrinter;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBreedHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStageHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonReproductionHelper;
import info.ata4.minecraft.dragon.util.reflection.PrivateFields;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.lwjgl.input.Keyboard;

public class GuiDragonDebug
extends Gui {
    private static final int WHITE = 0xFFFFFF;
    private static final int GREY = 0xAAAAAA;
    private static final int YELLOW = 0xFFFF00;
    private static final int RED = 0xFF8888;
    public static Object probe;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final FontRenderer fr;
    private final GuiTextPrinter text;
    private ScaledResolution res;
    private DecimalFormat dfShort = new DecimalFormat("0.00");
    private DecimalFormat dfLong = new DecimalFormat("0.0000");
    private EntityTameableDragon dragonClient;
    private EntityTameableDragon dragonServer;

    public GuiDragonDebug() {
        this.fr = this.mc.field_71466_p;
        this.text = new GuiTextPrinter(this.fr);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        this.getClientDragon();
        this.getServerDragon();
        if (this.dragonClient != null) {
            GuiIngameForge ingameGUI = (GuiIngameForge)this.mc.field_71456_v;
            this.res = ingameGUI.getResolution();
            this.renderTitle();
            try {
                if (Keyboard.isKeyDown((int)29)) {
                    this.renderNavigation();
                    this.renderAttributes();
                    this.renderBreedPoints();
                } else {
                    this.renderEntityInfo();
                    this.renderAITasks();
                    this.renderWatchedObjects();
                }
                this.renderProbe();
            }
            catch (Exception ex) {
                this.renderException(ex);
            }
            if (this.dragonClient.field_70128_L) {
                this.dragonClient = null;
                this.dragonServer = null;
            }
        }
    }

    private void getClientDragon() {
        if (this.mc.field_71439_g.field_70154_o instanceof EntityTameableDragon) {
            this.dragonClient = (EntityTameableDragon)this.mc.field_71439_g.field_70154_o;
            return;
        }
        if (this.mc.field_71476_x == null) {
            return;
        }
        if (this.mc.field_71476_x.field_72308_g == null) {
            return;
        }
        if (!(this.mc.field_71476_x.field_72308_g instanceof EntityTameableDragon)) {
            return;
        }
        this.dragonClient = (EntityTameableDragon)this.mc.field_71476_x.field_72308_g;
    }

    private void getServerDragon() {
        if (!this.mc.func_71356_B()) {
            return;
        }
        if (this.dragonClient == null) {
            this.dragonServer = null;
            return;
        }
        if (this.dragonServer != null && this.dragonServer.func_145782_y() == this.dragonClient.func_145782_y()) {
            return;
        }
        MinecraftServer mcs = MinecraftServer.func_71276_C();
        for (WorldServer ws : mcs.field_71305_c) {
            Entity ent = ws.func_73045_a(this.dragonClient.func_145782_y());
            if (ent == null || !(ent instanceof EntityTameableDragon)) continue;
            this.dragonServer = (EntityTameableDragon)ent;
            return;
        }
    }

    private EntityTameableDragon getSelectedDragon() {
        return Keyboard.isKeyDown((int)42) ? this.dragonClient : this.dragonServer;
    }

    private void renderTitle() {
        String title = String.format("%s %s Debug", "Dragon Mounts", DragonMounts.instance.getMetadata().version);
        this.text.setOrigin(16, 8);
        this.text.setColor(0xAAAAAA);
        this.text.println(title);
        this.text.setColor(0xFFFFFF);
    }

    private void renderEntityInfo() {
        EntityLivingBase player;
        EntityTameableDragon dragon = this.getSelectedDragon();
        if (dragon == null) {
            return;
        }
        this.text.setOrigin(16, 32);
        this.text.setColor(0xFFFF00);
        this.text.println("Entity");
        this.text.setColor(0xFFFFFF);
        this.text.println("Side: " + (dragon.isServer() ? "server" : "client"));
        this.text.println("ID: " + dragon.func_145782_y());
        this.text.println("UUID: " + StringUtils.abbreviate((String)dragon.func_110124_au().toString(), (int)22));
        this.text.println("Name: " + dragon.func_70005_c_());
        String px = this.dfShort.format(dragon.field_70165_t);
        String py = this.dfShort.format(dragon.field_70163_u);
        String pz = this.dfShort.format(dragon.field_70161_v);
        this.text.printf("x: %s y: %s z: %s\n", px, py, pz);
        String pitch = this.dfShort.format(dragon.field_70125_A);
        String yaw = this.dfShort.format(dragon.field_70177_z);
        String yawHead = this.dfShort.format(dragon.field_70759_as);
        this.text.printf("p: %s y: %s yh: %s\n", pitch, yaw, yawHead);
        String health = this.dfShort.format(dragon.func_110143_aJ());
        String healthMax = this.dfShort.format(dragon.func_110138_aP());
        String healthRel = this.dfShort.format(dragon.getHealthRelative() * 100.0);
        this.text.printf("Health: %s/%s (%s%%)\n", health, healthMax, healthRel);
        this.text.print("Breed: ");
        DragonBreed breed = dragon.getBreed();
        this.text.setColor(breed.getColor());
        this.text.println(breed.getName());
        this.text.setColor(0xFFFFFF);
        DragonLifeStageHelper lifeStage = dragon.getLifeStageHelper();
        String lifeStageName = lifeStage.getLifeStage().name().toLowerCase();
        int age = dragon.func_70874_b();
        this.text.printf("Life stage: %s (%d)\n", lifeStageName, age);
        String scale = this.dfShort.format(lifeStage.getScale());
        String width = this.dfShort.format(dragon.field_70130_N);
        String height = this.dfShort.format(dragon.field_70131_O);
        this.text.printf("Size: %s (w:%s h:%s)\n", scale, width, height);
        String tamedString = dragon.func_70909_n() ? ((player = dragon.func_70902_q()) != null ? "yes (" + player.func_70005_c_() + ")" : "yes (" + StringUtils.abbreviate((String)dragon.func_152113_b(), (int)22) + ")") : "no";
        this.text.println("Tamed: " + tamedString);
        DragonReproductionHelper reproduction = dragon.getReproductionHelper();
        String breederName = reproduction.getBreederName();
        if (breederName.isEmpty()) {
            breederName = "none";
        }
        this.text.println("Breeder: " + breederName);
        this.text.println("Reproduced: " + reproduction.getReproCount());
        this.text.println("Saddled: " + dragon.isSaddled());
    }

    private void renderAttributes() {
        EntityTameableDragon dragon = this.getSelectedDragon();
        if (dragon == null) {
            return;
        }
        this.text.setOrigin(this.text.getX() + 180, 8);
        this.text.setColor(0xFFFF00);
        this.text.println("Attributes");
        this.text.setColor(0xFFFFFF);
        Collection attribs = dragon.func_110140_aT().func_111146_a();
        for (IAttributeInstance attrib : attribs) {
            String attribName = StatCollector.func_74838_a((String)("attribute.name." + attrib.func_111123_a().func_111108_a()));
            String attribValue = this.dfShort.format(attrib.func_111126_e());
            String attribBase = this.dfShort.format(attrib.func_111125_b());
            this.text.println(attribName + " = " + attribValue + " (" + attribBase + ")");
        }
        this.text.println();
    }

    private void renderBreedPoints() {
        if (this.dragonServer == null) {
            return;
        }
        this.text.setColor(0xFFFF00);
        this.text.println("Breed points");
        this.text.setColor(0xFFFFFF);
        DragonBreedHelper breedHelper = this.dragonServer.getBreedHelper();
        Map<DragonBreed, AtomicInteger> breedPoints = breedHelper.getBreedPoints();
        for (Map.Entry<DragonBreed, AtomicInteger> breedPoint : breedPoints.entrySet()) {
            DragonBreed breed = breedPoint.getKey();
            int points = breedPoint.getValue().get();
            this.text.setColor(breed.getColor());
            this.text.printf("%s: %d\n", breed.getName(), points);
        }
    }

    private void renderNavigation() {
        this.text.setOrigin(16, 32);
        this.text.setColor(0xFFFF00);
        this.text.println("Navigation (Ground)");
        this.text.setColor(0xFFFFFF);
        PathNavigate nav = this.dragonServer.func_70661_as();
        this.text.println("Search range: " + nav.func_111269_d());
        this.text.println("Avoid water: " + nav.func_75486_a());
        this.text.println("Break doors: " + nav.func_75507_c());
        this.text.println("No path: " + nav.func_75500_f());
        PathEntity path = nav.func_75505_d();
        if (path != null) {
            this.text.println("Length: " + path.func_75874_d());
            this.text.println("Index: " + path.func_75873_e());
            PathPoint finalPoint = path.func_75870_c();
            this.text.println("Final point: " + finalPoint);
        }
        this.text.println();
        this.text.setColor(0xFFFF00);
        this.text.println("Navigation (Air)");
        this.text.setColor(0xFFFFFF);
        this.text.println("Waypoint: " + this.dragonServer.getWaypoint());
        this.text.println("Can fly: " + this.dragonClient.isCanFly());
        this.text.println("Flying: " + this.dragonClient.isFlying());
        this.text.println("Altitude: " + this.dfLong.format(this.dragonClient.getAltitude()));
    }

    private void renderAITasks() {
        if (this.dragonServer == null) {
            return;
        }
        this.text.setOrigin(this.text.getX() + 180, 8);
        this.text.setColor(0xFFFF00);
        this.text.println("AI tasks");
        this.text.setColor(0xFFFFFF);
        this.renderAITasks(this.dragonServer.field_70714_bg, "Ground");
        this.renderAITasks(this.dragonServer.airTasks, "Air");
        this.renderAITasks(this.dragonServer.field_70715_bh, "Target");
    }

    private void renderAITasks(EntityAITasks tasks, String label) {
        this.text.setColor(0xAAAAAA);
        this.text.println(label + ":");
        this.text.setColor(0xFFFFFF);
        ArrayList currentTasks = (ArrayList)ReflectionHelper.getPrivateValue(EntityAITasks.class, (Object)tasks, (String[])PrivateFields.ENTITYAITASKS_EXECUTINGTASKENTRIES);
        currentTasks = new ArrayList(currentTasks);
        if (currentTasks.isEmpty()) {
            this.text.println("---");
            return;
        }
        for (EntityAITasks.EntityAITaskEntry entry : currentTasks) {
            String actionName = entry.field_75733_a.getClass().getSimpleName();
            int priority = entry.field_75731_b;
            this.text.printf("%d - %s\n", priority, actionName);
        }
    }

    private void renderWatchedObjects() {
        Map watchedObjects;
        EntityTameableDragon dragon = this.getSelectedDragon();
        if (dragon == null) {
            return;
        }
        this.text.setOrigin(this.text.getX() + 140, 8);
        this.text.setColor(0xFFFF00);
        this.text.println("Watched objects");
        this.text.setColor(0xFFFFFF);
        try {
            watchedObjects = (Map)ReflectionHelper.getPrivateValue(DataWatcher.class, (Object)dragon.func_70096_w(), (String[])PrivateFields.DATAWATCHER_WATCHEDOBJECTS);
        }
        catch (Exception ex) {
            return;
        }
        for (Map.Entry pairs : watchedObjects.entrySet()) {
            Object object = ((DataWatcher.WatchableObject)pairs.getValue()).func_75669_b();
            Integer index = (Integer)pairs.getKey();
            this.text.printf("%d = %s:%s\n", index, object.getClass().getSimpleName(), object);
        }
    }

    private void renderProbe() {
        if (probe == null) {
            return;
        }
        this.text.setOrigin(16, this.res.func_78328_b() - this.text.getLineSpace() * 2);
        this.text.println(probe.getClass().getSimpleName() + ":" + String.valueOf(probe));
    }

    private void renderException(Exception ex) {
        this.text.setOrigin(16, 32);
        this.text.setColor(0xFF8888);
        this.text.println("GUI exception:");
        this.text.printf(ExceptionUtils.getStackTrace((Throwable)ex), new Object[0]);
        this.text.setColor(0xFFFFFF);
    }
}

