/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.item.chisel;

import com.cricketcraft.chisel.Chisel;
import com.cricketcraft.chisel.api.IChiselItem;
import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.cricketcraft.chisel.api.carving.IChiselMode;
import com.cricketcraft.chisel.carving.Carving;
import com.cricketcraft.chisel.utils.General;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.oredict.OreDictionary;

public final class ChiselController {
    public static final ChiselController INSTANCE = new ChiselController();
    private long lastTickClick = 0L;

    private ChiselController() {
    }

    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        ItemStack held = event.entityPlayer.func_71045_bC();
        int slot = event.entityPlayer.field_71071_by.field_70461_c;
        if (held == null || !(held.func_77973_b() instanceof IChiselItem)) {
            return;
        }
        IChiselItem chisel = (IChiselItem)held.func_77973_b();
        switch (event.action) {
            case LEFT_CLICK_BLOCK: {
                int x = event.x;
                int y = event.y;
                int z = event.z;
                Block block = event.world.func_147439_a(x, y, z);
                int metadata = event.world.func_72805_g(x, y, z);
                ICarvingGroup group = Carving.chisel.getGroup(block, metadata);
                if (group == null) {
                    return;
                }
                List<ICarvingVariation> list = group.getVariations();
                block4: for (ItemStack stack : OreDictionary.getOres((String)group.getOreName())) {
                    ICarvingVariation v = General.getVariation(stack);
                    for (ICarvingVariation check : list) {
                        if (check.getBlock() != v.getBlock() || check.getBlockMeta() != v.getBlockMeta()) continue;
                        continue block4;
                    }
                    list.add(General.getVariation(stack));
                }
                ICarvingVariation[] variations = list.toArray(new ICarvingVariation[0]);
                if (!chisel.canChiselBlock(event.world, event.entityPlayer, x, y, z, block, metadata)) break;
                ItemStack target = General.getChiselTarget(held);
                IChiselMode mode = General.getChiselMode(held);
                ForgeDirection sideHit = ForgeDirection.VALID_DIRECTIONS[event.face];
                if (target != null) {
                    for (ICarvingVariation v : variations) {
                        if (v.getBlock() != Block.func_149634_a((Item)target.func_77973_b()) || v.getBlockMeta() != target.func_77960_j()) continue;
                        mode.chiselAll(event.entityPlayer, event.world, x, y, z, sideHit, v);
                    }
                    break;
                }
                int idx = 0;
                for (int i = 0; i < variations.length; ++i) {
                    ICarvingVariation v = variations[i];
                    if (v.getBlock() != block || v.getBlockMeta() != metadata) continue;
                    idx = (i + 1) % variations.length;
                    break;
                }
                ICarvingVariation newVar = variations[idx];
                mode.chiselAll(event.entityPlayer, event.world, x, y, z, sideHit, newVar);
                event.entityPlayer.field_71071_by.field_70461_c = slot;
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                if (event.world.func_82737_E() == this.lastTickClick) break;
                this.lastTickClick = event.world.func_82737_E();
                if (event.world.field_72995_K || !chisel.canOpenGui(event.world, event.entityPlayer, held)) break;
                event.entityPlayer.openGui((Object)Chisel.instance, 0, event.world, 0, 0, 0);
            }
        }
    }
}

