/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.ScaledResolution;
import openmods.structured.ElementField;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;
import openperipheral.addons.glasses.SurfaceServer;
import openperipheral.addons.glasses.drawable.GradientBox;
import openperipheral.addons.glasses.drawable.ItemIcon;
import openperipheral.addons.glasses.drawable.LiquidIcon;
import openperipheral.addons.glasses.drawable.SolidBox;
import openperipheral.addons.glasses.drawable.Text;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.CallbackProperty;
import openperipheral.api.adapter.IPropertyCallback;
import openperipheral.api.adapter.Property;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import org.lwjgl.opengl.GL11;

@Asynchronous
@AdapterSourceName(value="glasses_drawable")
public abstract class Drawable
implements IPropertyCallback,
IStructureContainer<IStructureElement> {
    private boolean deleted;
    private int containerId;
    private SurfaceServer owner;
    private final Map<Field, ElementField> fields = Maps.newHashMap();
    private final Alignment alignment = new Alignment();
    @CallbackProperty
    public short x;
    @CallbackProperty
    public short y;
    @CallbackProperty
    public short z;
    @CallbackProperty
    public boolean visible = true;
    @CallbackProperty
    public float rotation = 0.0f;
    @Property(type=ArgType.OBJECT, getterDesc="Get userdata", setterDesc="Set userdata (no restrictions, not sent to clients)")
    public Object userdata;

    protected Drawable() {
    }

    protected Drawable(short x, short y) {
        this.x = x;
        this.y = y;
    }

    public double getX(ScaledResolution resolution) {
        return this.alignment.getScreenAnchorX(resolution, this) + this.alignment.getObjectAnchorX(this) + (float)this.x;
    }

    public double getY(ScaledResolution resolution) {
        return this.alignment.getScreenAnchorY(resolution, this) + this.alignment.getObjectAnchorY(this) + (float)this.y;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(ScaledResolution resolution, float partialTicks) {
        float globalX = this.alignment.getScreenAnchorX(resolution, this) + (float)this.x;
        float globalY = this.alignment.getScreenAnchorY(resolution, this) + (float)this.y;
        float localX = this.alignment.getObjectAnchorX(this);
        float localY = this.alignment.getObjectAnchorY(this);
        GL11.glPushMatrix();
        if (this.rotation != 0.0f) {
            GL11.glTranslatef((float)globalX, (float)globalY, (float)this.z);
            GL11.glRotated((double)this.rotation, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslatef((float)localX, (float)localY, (float)0.0f);
        } else {
            GL11.glTranslatef((float)(globalX + localX), (float)(globalY + localY), (float)this.z);
        }
        this.drawContents(partialTicks);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void drawContents(float var1);

    protected abstract Type getTypeEnum();

    public abstract int getWidth();

    public abstract int getHeight();

    protected abstract boolean isVisible();

    public final boolean shouldRender() {
        return this.visible && this.isVisible();
    }

    public int getType() {
        return this.getTypeEnum().ordinal();
    }

    public static Drawable createFromTypeId(int containerId, int typeId) {
        Type type = Type.TYPES[typeId];
        Drawable container = type.create();
        container.containerId = containerId;
        return container;
    }

    @ScriptCallable(returnTypes={ReturnType.STRING}, name="getType", description="Get object type")
    public String getTypeName() {
        return this.getTypeEnum().name().toLowerCase();
    }

    @ScriptCallable
    public void delete() {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"Object is already deleted");
        Preconditions.checkState((this.owner != null ? 1 : 0) != 0, (Object)"Invalid side");
        this.owner.removeContainer(this.containerId);
        this.deleted = true;
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, name="getId")
    public int getId() {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"Object is already deleted");
        return this.containerId + 1;
    }

    public VerticalAlignment getScreenVerticalAnchor() {
        return this.alignment.screenVerticalAnchor;
    }

    @ScriptCallable
    public void setScreenAnchor(@Arg(name="horizontal") HorizontalAlignment horizontal, @Arg(name="vertical") VerticalAlignment vertical) {
        this.alignment.screenVerticalAnchor = vertical;
        this.alignment.screenHorizontalAnchor = horizontal;
        this.owner.markElementModified(this.alignment);
    }

    @ScriptCallable
    public void setObjectAnchor(@Arg(name="horizontal") HorizontalAlignment horizontal, @Arg(name="vertical") VerticalAlignment vertical) {
        this.alignment.objectVerticalAnchor = vertical;
        this.alignment.objectHorizontalAnchor = horizontal;
        this.owner.markElementModified(this.alignment);
    }

    @ScriptCallable
    public void setAlignment(@Arg(name="horizontal") HorizontalAlignment horizontal, @Arg(name="vertical") VerticalAlignment vertical) {
        this.alignment.objectVerticalAnchor = this.alignment.screenVerticalAnchor = vertical;
        this.alignment.objectHorizontalAnchor = this.alignment.screenHorizontalAnchor = horizontal;
        this.owner.markElementModified(this.alignment);
    }

    public void setField(Field field, Object value) {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"Object is already deleted");
        Preconditions.checkState((this.owner != null ? 1 : 0) != 0, (Object)"Invalid side");
        ElementField fieldWrapper = this.fields.get(field);
        Preconditions.checkState((fieldWrapper != null ? 1 : 0) != 0, (Object)"LOGIC FAIL. BLAME MOD DEVS");
        this.owner.markElementModified((IStructureElement)fieldWrapper);
        fieldWrapper.set(value);
    }

    public Object getField(Field field) {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"Object is already deleted");
        ElementField fieldWrapper = this.fields.get(field);
        Preconditions.checkState((fieldWrapper != null ? 1 : 0) != 0, (Object)"LOGIC FAIL. BLAME MOD DEVS");
        return fieldWrapper.get();
    }

    public List<IStructureElement> createElements() {
        ArrayList result = Lists.newArrayList();
        for (Field field : this.getClass().getFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(CallbackProperty.class)) continue;
            ElementField fieldWrapper = new ElementField((Object)this, field);
            result.add(fieldWrapper);
            this.fields.put(field, fieldWrapper);
        }
        result.add(this.alignment);
        return result;
    }

    public void setDeleted() {
        this.deleted = true;
    }

    public void setOwner(SurfaceServer owner) {
        this.owner = owner;
    }

    public void onElementAdded(IStructureElement element) {
    }

    public void onElementUpdated(IStructureElement element) {
        this.onUpdate();
    }

    protected abstract void onUpdate();

    public void onAdded(SurfaceServer owner, int containerId) {
        this.containerId = containerId;
        this.owner = owner;
    }

    private static class Alignment
    implements IStructureElement {
        private static final int MASK = 3;
        private int id;
        public VerticalAlignment screenVerticalAnchor = VerticalAlignment.TOP;
        public HorizontalAlignment screenHorizontalAnchor = HorizontalAlignment.LEFT;
        public VerticalAlignment objectVerticalAnchor = VerticalAlignment.TOP;
        public HorizontalAlignment objectHorizontalAnchor = HorizontalAlignment.LEFT;

        private Alignment() {
        }

        public void readFromStream(DataInput input) throws IOException {
            byte value = input.readByte();
            this.screenVerticalAnchor = VerticalAlignment.VALUES[value >> 0 & 3];
            this.screenHorizontalAnchor = HorizontalAlignment.VALUES[value >> 2 & 3];
            this.objectVerticalAnchor = VerticalAlignment.VALUES[value >> 4 & 3];
            this.objectHorizontalAnchor = HorizontalAlignment.VALUES[value >> 6 & 3];
        }

        public void writeToStream(DataOutput output) throws IOException {
            byte value = (byte)(this.screenVerticalAnchor.ordinal() << 0 | this.screenHorizontalAnchor.ordinal() << 2 | this.objectVerticalAnchor.ordinal() << 4 | this.objectHorizontalAnchor.ordinal() << 6);
            output.writeByte(value);
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public float getScreenAnchorX(ScaledResolution resolution, Drawable drawable) {
            switch (this.screenHorizontalAnchor) {
                case MIDDLE: {
                    return (float)resolution.func_78326_a() / 2.0f;
                }
                case RIGHT: {
                    return resolution.func_78326_a();
                }
            }
            return 0.0f;
        }

        public float getObjectAnchorX(Drawable drawable) {
            switch (this.objectHorizontalAnchor) {
                case MIDDLE: {
                    return (float)(-drawable.getWidth()) / 2.0f;
                }
                case RIGHT: {
                    return -drawable.getWidth();
                }
            }
            return 0.0f;
        }

        public float getScreenAnchorY(ScaledResolution resolution, Drawable drawable) {
            switch (this.screenVerticalAnchor) {
                case BOTTOM: {
                    return resolution.func_78328_b();
                }
                case MIDDLE: {
                    return (float)resolution.func_78328_b() / 2.0f;
                }
            }
            return 0.0f;
        }

        public float getObjectAnchorY(Drawable drawable) {
            switch (this.objectVerticalAnchor) {
                case BOTTOM: {
                    return -drawable.getHeight();
                }
                case MIDDLE: {
                    return (float)(-drawable.getHeight()) / 2.0f;
                }
            }
            return 0.0f;
        }
    }

    public static enum HorizontalAlignment {
        LEFT,
        MIDDLE,
        RIGHT;

        public static final HorizontalAlignment[] VALUES;

        static {
            VALUES = HorizontalAlignment.values();
        }
    }

    public static enum VerticalAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

        public static final VerticalAlignment[] VALUES;

        static {
            VALUES = VerticalAlignment.values();
        }
    }

    static enum Type {
        GRADIENT{

            @Override
            public Drawable create() {
                return new GradientBox();
            }
        }
        ,
        BOX{

            @Override
            public Drawable create() {
                return new SolidBox();
            }
        }
        ,
        TEXT{

            @Override
            public Drawable create() {
                return new Text();
            }
        }
        ,
        LIQUID{

            @Override
            public Drawable create() {
                return new LiquidIcon();
            }
        }
        ,
        ITEM{

            @Override
            public Drawable create() {
                return new ItemIcon();
            }
        };

        public static final Type[] TYPES;

        public abstract Drawable create();

        static {
            TYPES = Type.values();
        }
    }
}

