/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.ICustomHarvestDrops;
import openmods.api.IPlaceAwareTile;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.network.event.NetworkEventManager;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.ItemUtils;
import openperipheral.addons.glasses.GlassesEvent;
import openperipheral.addons.glasses.IDrawableContainer;
import openperipheral.addons.glasses.SurfaceServer;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalManagerServer;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.Doc;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.adapter.method.ScriptObject;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.architecture.IAttachable;
import openperipheral.api.peripheral.PeripheralTypeId;

@Doc(value={"This peripheral is used to control terminal glasses and wireless keyboard.", "There is one global surface and one private surface for every glasses user.", "All calls names .add*() will return object that can be later used to modify it.", "To make changes visible to players, call .sync().", "This peripheral signals few events. Full list available here: http://goo.gl/8Hf2yA", "Simple demo: http://goo.gl/n5HPN8"})
@PeripheralTypeId(value="openperipheral_bridge")
public class TileEntityGlassesBridge
extends OpenTileEntity
implements IAttachable,
IPlaceAwareTile,
ICustomHarvestDrops {
    public static final String TAG_GUID = "guid";
    private static final String EVENT_CHAT_MESSAGE = "glasses_chat_command";
    private static final String EVENT_PLAYER_ATTACH = "glasses_attach";
    private static final String EVENT_PLAYER_DETACH = "glasses_detach";
    private final Map<UUID, PlayerInfo> knownPlayersByUUID = Maps.newHashMap();
    private final Map<String, PlayerInfo> knownPlayersByName = Maps.newHashMap();
    private List<Object> lastSyncPackets;
    private Set<IArchitectureAccess> computers = Sets.newIdentityHashSet();
    private long guid;
    @IncludeInterface(value=IDrawableContainer.class)
    private SurfaceServer globalSurface = new SurfaceServer();

    private void rebuildPlayerNamesMap() {
        this.knownPlayersByName.clear();
        for (PlayerInfo info : this.knownPlayersByUUID.values()) {
            EntityPlayerMP player = (EntityPlayerMP)info.player.get();
            if (!this.isPlayerValid(player)) continue;
            String name = player.func_146103_bH().getName();
            this.knownPlayersByName.put(name, info);
        }
    }

    public void registerTerminal(EntityPlayerMP player) {
        if (!this.knownPlayersByUUID.containsKey(player.func_146103_bH().getId())) {
            PlayerInfo playerInfo = new PlayerInfo(player);
            GameProfile gameProfile = player.func_146103_bH();
            this.knownPlayersByUUID.put(gameProfile.getId(), playerInfo);
            this.rebuildPlayerNamesMap();
            this.queueEvent(EVENT_PLAYER_ATTACH, (EntityPlayer)player, new Object[0]);
            this.sentFullDataToPlayer((EntityPlayer)player);
        }
    }

    private static TerminalEvent.TerminalDataEvent createFullDataEvent(SurfaceServer surface, long terminalId, boolean isPrivate) {
        TerminalEvent.TerminalDataEvent result = new TerminalEvent.TerminalDataEvent(terminalId, isPrivate);
        surface.appendFullCommands((List)result.commands);
        return result;
    }

    private static TerminalEvent.TerminalDataEvent createUpdateDataEvent(SurfaceServer surface, long terminalId, boolean isPrivate) {
        TerminalEvent.TerminalDataEvent result = new TerminalEvent.TerminalDataEvent(terminalId, isPrivate);
        surface.appendUpdateCommands((List)result.commands);
        return result;
    }

    private void sentFullDataToPlayer(EntityPlayer player) {
        if (this.lastSyncPackets != null) {
            NetworkEventManager.INSTANCE.dispatcher().senders.player.sendMessages(this.lastSyncPackets, (Object)player);
        }
    }

    private void queueEvent(String event, EntityPlayer user, Object ... extra) {
        GameProfile gameProfile = user.func_146103_bH();
        Object[] template = new Object[3 + extra.length];
        template[1] = gameProfile.getName();
        UUID id = gameProfile.getId();
        template[2] = id != null ? id.toString() : null;
        for (int i = 0; i < extra.length; ++i) {
            Object v;
            template[i + 3] = v = extra[i];
        }
        for (IArchitectureAccess computer : this.computers) {
            Object[] args = Arrays.copyOf(template, template.length);
            args[0] = computer.peripheralName();
            computer.signal(event, args);
        }
    }

    public void onChatCommand(String command, EntityPlayer player) {
        this.queueEvent(EVENT_CHAT_MESSAGE, player, command);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K || this.globalSurface == null) {
            return;
        }
        TerminalManagerServer.instance.registerBridge(this.guid, this);
        boolean playersRemoved = false;
        Iterator<PlayerInfo> it = this.knownPlayersByUUID.values().iterator();
        while (it.hasNext()) {
            PlayerInfo info = it.next();
            EntityPlayerMP player = (EntityPlayerMP)info.player.get();
            if (this.isPlayerValid(player)) continue;
            this.queueEvent(EVENT_PLAYER_DETACH, (EntityPlayer)player, new Object[0]);
            this.sendCleanPackets(player);
            it.remove();
            playersRemoved = true;
        }
        if (playersRemoved) {
            this.rebuildPlayerNamesMap();
        }
    }

    private void sendCleanPackets(EntityPlayerMP player) {
        new TerminalEvent.TerminalClearEvent(this.guid, false).sendToPlayer((EntityPlayer)player);
        new TerminalEvent.TerminalClearEvent(this.guid, true).sendToPlayer((EntityPlayer)player);
    }

    private boolean isPlayerValid(EntityPlayerMP player) {
        if (player == null) {
            return false;
        }
        if (player.field_70128_L && !TileEntityGlassesBridge.isPlayerLogged(player)) {
            return false;
        }
        Long guid = TerminalUtils.tryGetTerminalGuid((EntityPlayer)player);
        return guid != null && guid == this.guid;
    }

    private static boolean isPlayerLogged(EntityPlayerMP player) {
        GameProfile gameProfile = player.func_146103_bH();
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP p : players) {
            if (!p.func_146103_bH().equals((Object)gameProfile)) continue;
            return true;
        }
        return false;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74772_a(TAG_GUID, this.guid);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        Long guid = TerminalUtils.extractGuid(tag);
        if (guid != null) {
            this.guid = guid;
        }
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        NBTTagCompound tag = stack.func_77978_p();
        this.guid = tag != null && tag.func_74764_b(TAG_GUID) ? tag.func_74763_f(TAG_GUID) : TerminalUtils.generateGuid();
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops) {
        ItemStack result = new ItemStack(this.func_145838_q());
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)result);
        tag.func_74772_a(TAG_GUID, this.guid);
        drops.add(result);
    }

    public boolean suppressNormalHarvestDrops() {
        return true;
    }

    public void addComputer(IArchitectureAccess computer) {
        if (!this.computers.contains(computer)) {
            this.computers.add(computer);
        }
    }

    public void removeComputer(IArchitectureAccess computer) {
        this.computers.remove(computer);
    }

    public void handleUserEvent(GlassesEvent.GlassesClientEvent evt) {
        this.queueEvent(evt.getEventName(), evt.sender, evt.getEventArgs());
    }

    public SurfaceServer getSurface(String username) {
        if ("GLOBAL".equals(username)) {
            return this.globalSurface;
        }
        PlayerInfo info = this.knownPlayersByName.get(username);
        return info != null ? info.surface : null;
    }

    public SurfaceServer getSurface(UUID uuid) {
        if (TerminalUtils.GLOBAL_SURFACE_UUID.equals(uuid)) {
            return this.globalSurface;
        }
        PlayerInfo info = this.knownPlayersByUUID.get(uuid);
        return info != null ? info.surface : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptCallable(description="Send updates to client. Without it changes won't be visible", name="sync")
    public void syncContents() {
        SurfaceServer surfaceServer = this.globalSurface;
        synchronized (surfaceServer) {
            boolean globalChanged = this.globalSurface.hasUpdates();
            TerminalEvent.TerminalDataEvent globalDelta = globalChanged ? TileEntityGlassesBridge.createUpdateDataEvent(this.globalSurface, this.guid, false) : null;
            for (PlayerInfo info : this.knownPlayersByUUID.values()) {
                EntityPlayerMP player = (EntityPlayerMP)info.player.get();
                if (!this.isPlayerValid(player)) continue;
                if (globalDelta != null) {
                    globalDelta.sendToPlayer((EntityPlayer)player);
                }
                this.sendPrivateUpdateToPlayer(player, info);
            }
            if (globalChanged) {
                TerminalEvent.TerminalDataEvent globalFullData = TileEntityGlassesBridge.createFullDataEvent(this.globalSurface, this.guid, false);
                this.lastSyncPackets = globalFullData.serialize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPrivateUpdateToPlayer(EntityPlayerMP player, PlayerInfo info) {
        SurfaceServer privateSurface = info.surface;
        if (privateSurface != null) {
            SurfaceServer surfaceServer = privateSurface;
            synchronized (surfaceServer) {
                if (privateSurface.hasUpdates()) {
                    TerminalEvent.TerminalDataEvent privateData = TileEntityGlassesBridge.createUpdateDataEvent(privateSurface, this.guid, true);
                    privateData.sendToPlayer((EntityPlayer)player);
                }
            }
        }
    }

    private void sendPrivateFullToPlayer(EntityPlayer player) {
        UUID playerUuid = player.func_146103_bH().getId();
        PlayerInfo info = this.knownPlayersByUUID.get(playerUuid);
        if (info != null) {
            TerminalEvent.TerminalDataEvent privateData = TileEntityGlassesBridge.createFullDataEvent(info.surface, this.guid, true);
            privateData.sendToPlayer(player);
        }
    }

    public void handleResetRequest(TerminalEvent.TerminalResetEvent evt) {
        if (evt.isPrivate) {
            this.sendPrivateFullToPlayer(evt.sender);
        } else {
            this.sentFullDataToPlayer(evt.sender);
        }
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get the names of all the users linked up to this bridge")
    public List<GameProfile> getUsers() {
        ArrayList result = Lists.newArrayList();
        for (PlayerInfo info : this.knownPlayersByUUID.values()) {
            result.add(info.profile);
        }
        return result;
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.STRING}, name="getGuid", description="Get the Guid of this bridge")
    public String getGuidString() {
        return TerminalUtils.formatTerminalId(this.guid);
    }

    public long getGuid() {
        return this.guid;
    }

    @IncludeOverride
    public void clear() {
        this.globalSurface.clear();
        for (PlayerInfo info : this.knownPlayersByUUID.values()) {
            info.surface.clear();
        }
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get the surface of a user to draw privately on their screen")
    public IDrawableContainer getSurfaceByName(@Arg(name="username", description="The username of the user to get the draw surface for") String username) {
        SurfaceServer playerSurface = this.getSurface(username);
        Preconditions.checkNotNull((Object)playerSurface, (Object)"Invalid player");
        return playerSurface;
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get the surface of a user to draw privately on their screen")
    public IDrawableContainer getSurfaceByUUID(@Arg(name="uuid", description="The uuid of the user to get the draw surface for") UUID uuid) {
        SurfaceServer playerSurface = this.getSurface(uuid);
        Preconditions.checkNotNull((Object)playerSurface, (Object)"Invalid player");
        return playerSurface;
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Returns object used for controlling player capture mode")
    public CaptureControl getCaptureControl(@Arg(name="uuid") UUID uuid) {
        PlayerInfo info = this.knownPlayersByUUID.get(uuid);
        return info != null ? new CaptureControl(info.player) : null;
    }

    @ScriptObject
    @Asynchronous
    @AdapterSourceName(value="glasses-capture")
    public class CaptureControl {
        private final WeakReference<EntityPlayerMP> player;

        public CaptureControl(WeakReference<EntityPlayerMP> player) {
            this.player = player;
        }

        protected EntityPlayer getPlayer() {
            EntityPlayer player = (EntityPlayer)this.player.get();
            if (player == null) {
                throw new IllegalStateException("Object is no longer valid");
            }
            return player;
        }

        @ScriptCallable(description="Stops capture for player")
        public void stopCapturing() {
            EntityPlayer player = this.getPlayer();
            new GlassesEvent.GlassesStopCaptureEvent(TileEntityGlassesBridge.this.guid).sendToPlayer(player);
        }

        @ScriptCallable(description="Set background on capture mode screen")
        public void setBackground(@Arg(name="background") int background, @Optionals @Arg(name="alpha") Integer alpha) {
            EntityPlayer player = this.getPlayer();
            int a = alpha != null ? alpha << 24 : 0x2A000000;
            new GlassesEvent.GlassesChangeBackground(TileEntityGlassesBridge.this.guid, background & 0xFFFFFF | a).sendToPlayer(player);
        }

        @ScriptCallable(description="When enabled, holding key down for long time will generate multiple events")
        public void setKeyRepeat(@Arg(name="isEnabled") boolean keyRepeat) {
            EntityPlayer player = this.getPlayer();
            new GlassesEvent.GlassesSetKeyRepeat(TileEntityGlassesBridge.this.guid, keyRepeat).sendToPlayer(player);
        }
    }

    private static class PlayerInfo {
        public final GameProfile profile;
        public final WeakReference<EntityPlayerMP> player;
        public SurfaceServer surface;

        public PlayerInfo(EntityPlayerMP player) {
            this.player = new WeakReference<EntityPlayerMP>(player);
            this.profile = player.func_146103_bH();
            this.surface = new SurfaceServer();
        }
    }
}

