/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.utils;

import com.cricketcraft.chisel.api.IAdvancedChisel;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.cricketcraft.chisel.api.carving.IChiselMode;
import com.cricketcraft.chisel.carving.Carving;
import com.cricketcraft.chisel.carving.CarvingVariation;
import com.cricketcraft.chisel.item.chisel.ChiselMode;
import java.util.Random;
import joptsimple.internal.Strings;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class General {
    public static Random rand = new Random();
    public static final String[] sGNames = new String[]{"White", "Orange", "Magenta", "Light Blue", "Yellow", "Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    public static final String[] featureColors = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "darkgray", "lightgray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final String MODE_KEY = "chiselMode";

    public static void propelTowards(Entity what, Entity whereTo, double force) {
        double dx = whereTo.field_70165_t - what.field_70165_t;
        double dy = whereTo.field_70163_u - what.field_70163_u;
        double dz = whereTo.field_70161_v - what.field_70161_v;
        double total = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (total == 0.0) {
            what.field_70159_w = 0.0;
            what.field_70181_x = 0.0;
            what.field_70179_y = 0.0;
        } else {
            what.field_70159_w = dx / total * force;
            what.field_70181_x = dy / total * force;
            what.field_70179_y = dz / total * force;
        }
    }

    public static boolean isInRange(double distance, double x1, double y1, double z1, double x2, double y2, double z2) {
        double x = x1 - x2;
        double y = y1 - y2;
        double z = z1 - z2;
        return x * x + y * y + z * z < distance * distance;
    }

    public static Item getItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() == null) {
            return null;
        }
        return stack.func_77973_b();
    }

    public static String getName(Item item) {
        String res = item.func_77658_a();
        return General.cleanTags(res);
    }

    public static String getName(Block block) {
        String res = block.func_149739_a();
        return General.cleanTags(res);
    }

    public static String cleanTags(String tag) {
        return tag.replaceAll("[Cc]hisel\\p{Punct}", "").replaceFirst("^tile\\.", "").replaceFirst("^item\\.", "");
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World par1World, EntityPlayer par2EntityPlayer, boolean par3) {
        float var4 = 1.0f;
        float var5 = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * var4;
        float var6 = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * var4;
        double var7 = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)var4;
        double var9 = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)var4 + 1.62 - (double)par2EntityPlayer.field_70129_M;
        double var11 = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)var4;
        Vec3 var13 = Vec3.func_72443_a((double)var7, (double)var9, (double)var11);
        float var14 = MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = 5.0;
        if (par2EntityPlayer instanceof EntityPlayerMP) {
            var21 = ((EntityPlayerMP)par2EntityPlayer).field_71134_c.getBlockReachDistance();
        }
        Vec3 var23 = var13.func_72441_c((double)var18 * var21, (double)var17 * var21, (double)var20 * var21);
        return par1World.func_72901_a(var13, var23, par3);
    }

    public static ItemStack getChiselTarget(ItemStack chisel) {
        return chisel.func_77942_o() ? ItemStack.func_77949_a((NBTTagCompound)chisel.field_77990_d.func_74775_l("chiselTarget")) : null;
    }

    public static void setChiselTarget(ItemStack chisel, ItemStack target) {
        General.initTag(chisel);
        NBTTagCompound targetTag = new NBTTagCompound();
        if (target != null) {
            target.func_77955_b(targetTag);
        }
        chisel.func_77978_p().func_74782_a("chiselTarget", (NBTBase)targetTag);
    }

    private static void initTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public static IChiselMode getChiselMode(ItemStack chisel) {
        if (chisel.field_77990_d == null || Strings.isNullOrEmpty((String)chisel.field_77990_d.func_74779_i(MODE_KEY))) {
            General.initTag(chisel);
            chisel.field_77990_d.func_74778_a(MODE_KEY, ChiselMode.SINGLE.name());
        }
        String name = chisel.field_77990_d.func_74779_i(MODE_KEY);
        if (chisel.func_77973_b() instanceof IAdvancedChisel) {
            return ((IAdvancedChisel)chisel.func_77973_b()).getMode(chisel, name);
        }
        return Enum.valueOf(ChiselMode.class, chisel.field_77990_d.func_74779_i(MODE_KEY));
    }

    public static void setChiselMode(ItemStack chisel, IChiselMode mode) {
        General.initTag(chisel);
        chisel.field_77990_d.func_74778_a(MODE_KEY, mode.name());
    }

    public static ICarvingVariation getVariation(ItemStack stack) {
        ICarvingVariation v = Carving.chisel.getVariation(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j());
        return v == null ? new CarvingVariation(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j(), 99) : v;
    }
}

