/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.carving;

import com.cricketcraft.chisel.api.carving.ICarvingGroup;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class GroupList
implements Set<ICarvingGroup> {
    private HashMap<String, ICarvingGroup> groups = Maps.newHashMap();
    private HashMap<VariationWrapper, ICarvingGroup> lookup = Maps.newHashMap();

    @Override
    public int size() {
        return this.groups.size();
    }

    @Override
    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof ICarvingGroup) {
            return this.groups.containsKey(((ICarvingGroup)o).getName());
        }
        return false;
    }

    @Override
    public Iterator<ICarvingGroup> iterator() {
        return this.groups.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.groups.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.groups.values().toArray(arr);
    }

    @Override
    public boolean add(ICarvingGroup group) {
        String key = group.getName();
        if (this.groups.containsKey(key)) {
            return false;
        }
        for (ICarvingVariation v : group.getVariations()) {
            ICarvingGroup g = this.lookup.get(v);
            if (g != null) continue;
            this.lookup.put(new VariationWrapper(v), group);
        }
        this.groups.put(key, group);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof ICarvingGroup) {
            ArrayList toRemove = Lists.newArrayList();
            for (VariationWrapper v : this.lookup.keySet()) {
                if (!this.lookup.get(v).getName().equals(((ICarvingGroup)o).getName())) continue;
                toRemove.add(v);
            }
            for (VariationWrapper v : toRemove) {
                this.lookup.remove(v);
            }
            return this.groups.remove(((ICarvingGroup)o).getName()) != null;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof ICarvingGroup)) {
                return false;
            }
            if (this.groups.containsKey(((ICarvingGroup)o).getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ICarvingGroup> c) {
        boolean ret = false;
        for (ICarvingGroup iCarvingGroup : c) {
            ret |= this.add(iCarvingGroup);
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            ret |= this.remove(o);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.groups.clear();
    }

    public ICarvingGroup getGroup(Block block, int metadata) {
        return this.lookup.get(new VariationWrapper(new VariationKey(block, metadata)));
    }

    public void addVariation(String name, ICarvingVariation variation) {
        ICarvingGroup g = this.groups.get(name);
        if (g == null) {
            throw new NullPointerException("No group exists for name " + name);
        }
        g.addVariation(variation);
        this.lookup.put(new VariationWrapper(variation), g);
    }

    public ICarvingGroup getGroupByName(String groupName) {
        return this.groups.get(groupName);
    }

    public ICarvingGroup getGroupByOre(String oreName) {
        for (ICarvingGroup group : this.groups.values()) {
            if (!oreName.equals(group.getOreName())) continue;
            return group;
        }
        return null;
    }

    public Collection<? extends String> getNames() {
        return this.groups.keySet();
    }

    public ICarvingVariation removeVariation(Block block, int metadata, String group) {
        ICarvingGroup g = null;
        if (group != null) {
            g = this.groups.get(group);
            if (g == null) {
                throw new IllegalArgumentException("No such group " + group);
            }
            this.groups.remove(g.getName());
        }
        ArrayList toRemove = Lists.newArrayList();
        for (VariationWrapper v : this.lookup.keySet()) {
            if (g != null && !this.lookup.get(v).getName().equals(g.getName()) || !v.equals(new VariationWrapper(new VariationKey(block, metadata)))) continue;
            this.lookup.get(v).removeVariation(v.v);
            toRemove.add(v);
        }
        for (VariationWrapper v : toRemove) {
            this.lookup.remove(v);
        }
        return toRemove.isEmpty() ? null : ((VariationWrapper)toRemove.get(0)).v;
    }

    public String toString() {
        return this.groups.toString();
    }

    private class VariationKey
    implements ICarvingVariation {
        Pair<Block, Integer> data;

        private VariationKey(Block block, int blockMeta) {
            this.data = Pair.of((Object)block, (Object)blockMeta);
        }

        @Override
        public Block getBlock() {
            return (Block)this.data.getLeft();
        }

        @Override
        public int getBlockMeta() {
            return (Integer)this.data.getRight();
        }

        @Override
        public int getItemMeta() {
            return (Integer)this.data.getRight();
        }

        @Override
        public int getOrder() {
            return 0;
        }

        public String toString() {
            return this.data.toString();
        }
    }

    private class VariationWrapper {
        private ICarvingVariation v;

        private VariationWrapper(ICarvingVariation v) {
            this.v = v;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ICarvingVariation) {
                ICarvingVariation v2 = (ICarvingVariation)obj;
                return this.v.getBlock() == v2.getBlock() && (this.v.getBlockMeta() == v2.getBlockMeta() || this.v.getItemMeta() == v2.getItemMeta());
            }
            if (obj instanceof VariationWrapper) {
                return this.equals(((VariationWrapper)obj).v);
            }
            return false;
        }

        public int hashCode() {
            return this.v.getBlock().hashCode();
        }
    }
}

