/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IPattern;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.tools.TinkerTools;

public final class IMCHandler {
    private IMCHandler() {
    }

    public static void processIMC(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            NBTTagCompound tag;
            String type = message.key;
            if (type == null || type.isEmpty()) continue;
            if (type.equals("addMaterial")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                int id = tag.func_74762_e("Id");
                ToolMaterial mat = IMCHandler.scanMaterial(tag);
                if (mat == null) continue;
                TConstructRegistry.addtoolMaterial(id, mat);
                TConstructRegistry.addDefaultToolPartMaterial(id);
                TConstruct.logger.debug("IMC: Added material " + mat.materialName);
                if (tag.func_74764_b("Bow_DrawSpeed") && tag.func_74764_b("Bow_ProjectileSpeed")) {
                    int drawspeed = tag.func_74762_e("Bow_DrawSpeed");
                    float flightspeed = tag.func_74760_g("Bow_ProjectileSpeed");
                    TConstructRegistry.addBowMaterial(id, drawspeed, flightspeed);
                    TConstruct.logger.debug("IMC: Added Bow stats for material " + mat.materialName);
                }
                if (!tag.func_74764_b("Projectile_Mass") || !tag.func_74764_b("Projectile_Fragility")) continue;
                float mass = tag.func_74760_g("Projectile_Mass");
                float breakchance = tag.func_74760_g("Projectile_Fragility");
                TConstructRegistry.addArrowMaterial(id, mass, breakchance);
                TConstruct.logger.debug("IMC: Added Projectile stats for material " + mat.materialName);
                continue;
            }
            if (type.equals("addPartBuilderMaterial")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (!IMCHandler.checkRequiredTags("PartBuilder", tag, "MaterialId", "Item", "Value")) continue;
                int matID = tag.func_74762_e("MaterialId");
                int value = tag.func_74762_e("Value");
                if (TConstructRegistry.getMaterial(matID) == null) {
                    FMLLog.bigWarning((String)("PartBuilder IMC: Unknown Material ID " + matID), (Object[])new Object[0]);
                    continue;
                }
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Item"));
                ItemStack shard = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Shard"));
                ItemStack rod = new ItemStack(TinkerTools.toolRod, 1, matID);
                if (shard == null) {
                    TConstructRegistry.addDefaultShardMaterial(matID);
                    shard = new ItemStack(TinkerTools.toolShard, 1, matID);
                }
                PatternBuilder.instance.registerFullMaterial(item, value, TConstructRegistry.getMaterial((int)matID).materialName, shard, rod, matID);
                LinkedList<Item> addItems = new LinkedList<Item>();
                LinkedList<Integer> addMetas = new LinkedList<Integer>();
                LinkedList<ItemStack> addOUtputs = new LinkedList<ItemStack>();
                for (Map.Entry<List, ItemStack> mappingEntry : TConstructRegistry.patternPartMapping.entrySet()) {
                    List mapping = mappingEntry.getKey();
                    if ((Integer)mapping.get(2) != 1 || !(mappingEntry.getValue().func_77973_b() instanceof DynamicToolPart)) continue;
                    Item woodPattern = (Item)mapping.get(0);
                    Integer meta = (Integer)mapping.get(1);
                    ItemStack output = mappingEntry.getValue().func_77946_l();
                    output.func_77964_b(matID);
                    addItems.add(woodPattern);
                    addMetas.add(meta);
                    addOUtputs.add(output);
                }
                for (int i = 0; i < addItems.size(); ++i) {
                    TConstructRegistry.addPartMapping((Item)addItems.get(i), (Integer)addMetas.get(i), matID, (ItemStack)addOUtputs.get(i));
                }
                TConstruct.logger.debug("PartBuilder IMC: Added Part builder mapping for " + TConstructRegistry.getMaterial((int)matID).materialName);
                continue;
            }
            if (type.equals("addPartCastingMaterial")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (!IMCHandler.checkRequiredTags("Casting", tag, "MaterialId", "FluidName")) continue;
                if (!tag.func_74764_b("MaterialId")) {
                    FMLLog.bigWarning((String)"Casting IMC: Not material ID for the result present", (Object[])new Object[0]);
                    continue;
                }
                int matID = tag.func_74762_e("MaterialId");
                FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                if (liquid == null) {
                    FMLLog.bigWarning((String)"Casting IMC: No fluid found", (Object[])new Object[0]);
                    continue;
                }
                if (TConstructRegistry.getMaterial(matID) == null) {
                    FMLLog.bigWarning((String)("Casting IMC: Unknown Material ID " + matID), (Object[])new Object[0]);
                    continue;
                }
                LinkedList<CastingRecipe> newRecipies = new LinkedList<CastingRecipe>();
                for (CastingRecipe recipe : TConstructRegistry.getTableCasting().getCastingRecipes()) {
                    if (recipe.castingMetal.getFluid() != TinkerSmeltery.moltenIronFluid || recipe.cast == null || !(recipe.cast.func_77973_b() instanceof IPattern) || !(recipe.getResult().func_77973_b() instanceof DynamicToolPart)) continue;
                    newRecipies.add(recipe);
                }
                FluidType ft = FluidType.getFluidType(liquid.getFluid());
                if (ft == null) {
                    ft = new FluidType(TinkerSmeltery.glueBlock, 0, 500, liquid.getFluid(), true);
                    FluidType.registerFluidType(liquid.getFluid().getName(), ft);
                }
                for (CastingRecipe recipe : newRecipies) {
                    ItemStack output = recipe.getResult().func_77946_l();
                    output.func_77964_b(matID);
                    FluidStack liquid2 = new FluidStack(liquid, recipe.castingMetal.amount);
                    TConstructRegistry.getTableCasting().addCastingRecipe(output, liquid2, recipe.cast, recipe.consumeCast, recipe.coolTime);
                    Smeltery.addMelting(ft, output, 0, liquid2.amount);
                }
                TConstruct.logger.debug("Casting IMC: Added fluid " + tag.func_74779_i("FluidName") + " to part casting");
                continue;
            }
            if (type.equals("addMaterialItem")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (!IMCHandler.checkRequiredTags("Material Item", tag, "MaterialId", "Value", "Item")) continue;
                int id = tag.func_74762_e("MaterialId");
                int value = tag.func_74762_e("Value");
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Item"));
                if (stack == null) {
                    FMLLog.bigWarning((String)"Material Item IMC: Item for Material %d is null", (Object[])new Object[]{id});
                    continue;
                }
                if (TConstructRegistry.getMaterial(id) == null) {
                    FMLLog.bigWarning((String)"Material Item IMC: Material with ID %d does not exist", (Object[])new Object[]{id});
                    continue;
                }
                ToolMaterial mat = TConstructRegistry.getMaterial(id);
                if (PatternBuilder.instance.materialSets.containsKey(mat.materialName)) {
                    PatternBuilder.instance.registerMaterial(stack, value, mat.materialName);
                    continue;
                }
                TConstructRegistry.addDefaultShardMaterial(id);
                ItemStack shard = new ItemStack(TinkerTools.toolShard, 1, id);
                ItemStack rod = new ItemStack(TinkerTools.toolRod, 1, id);
                PatternBuilder.instance.registerFullMaterial(stack, value, TConstructRegistry.getMaterial((int)id).materialName, shard, rod, id);
                continue;
            }
            if (type.equals("addSmelteryMelting")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (!IMCHandler.checkRequiredTags("Smeltery", tag, "FluidName", "Temperature", "Item", "Block")) continue;
                FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                if (liquid == null) {
                    FMLLog.bigWarning((String)"Smeltery IMC: No fluid found", (Object[])new Object[0]);
                    continue;
                }
                if (liquid.amount <= 0) {
                    FMLLog.bigWarning((String)"Smeltery IMC: Liquid has to have an amount greater than zero", (Object[])new Object[0]);
                    continue;
                }
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Item"));
                ItemStack block = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Block"));
                int temperature = tag.func_74762_e("Temperature");
                if (FluidType.getFluidType(liquid.getFluid()) == null) {
                    FluidType.registerFluidType(liquid.getFluid().getName(), Block.func_149634_a((Item)block.func_77973_b()), block.func_77960_j(), temperature, liquid.getFluid(), false);
                }
                Smeltery.addMelting(Block.func_149634_a((Item)block.func_77973_b()), block.func_77960_j(), temperature, liquid);
                TConstruct.logger.debug("Smeltery IMC: Added melting: " + item.func_82833_r() + " to " + liquid.amount + "mb " + liquid.getLocalizedName());
                continue;
            }
            if (type.equals("addSmelteryFuel")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (!IMCHandler.checkRequiredTags("Smeltery", tag, "FluidName", "Temperature", "Duration")) continue;
                FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                if (liquid == null) {
                    FMLLog.bigWarning((String)"Smeltery IMC: No fluid found", (Object[])new Object[0]);
                    continue;
                }
                int temperature = tag.func_74762_e("Temperature");
                int duration = tag.func_74762_e("Duration");
                Smeltery.addSmelteryFuel(liquid.getFluid(), temperature, duration);
                TConstruct.logger.debug("Smeltery IMC: Added fuel: " + liquid.getLocalizedName() + " (" + temperature + ", " + duration + ")");
                continue;
            }
            if (!type.equals("addFluxBattery")) continue;
            if (!message.isItemStackMessage()) {
                IMCHandler.logInvalidMessage(message, "ItemStack");
                continue;
            }
            ItemStack battery = message.getItemStackValue();
            battery.field_77994_a = 1;
            if (!(battery.func_77973_b() instanceof IEnergyContainerItem)) {
                FMLLog.bigWarning((String)"Flux Battery IMC: ItemStack is no instance of IEnergyContainerItem", (Object[])new Object[0]);
            }
            if (TinkerTools.modFlux == null) continue;
            TinkerTools.modFlux.batteries.add(battery);
        }
    }

    private static boolean checkRequiredTags(String prefix, NBTTagCompound tag, String ... tags) {
        boolean ok = true;
        for (String t : tags) {
            if (tag.func_74764_b(t)) continue;
            FMLLog.bigWarning((String)String.format("%s IMC: Missing required NBT Tag %s", prefix, t), (Object[])new Object[0]);
            ok = false;
        }
        return ok;
    }

    private static void logInvalidMessage(FMLInterModComms.IMCMessage message) {
        IMCHandler.logInvalidMessage(message, "NBT");
    }

    private static void logInvalidMessage(FMLInterModComms.IMCMessage message, String type) {
        FMLLog.bigWarning((String)String.format("Received invalid IMC '%s' from %s. Not a %s Message.", message.key, message.getSender(), type), (Object[])new Object[0]);
    }

    private static ToolMaterial scanMaterial(NBTTagCompound tag) {
        if (!tag.func_74764_b("Name")) {
            FMLLog.bigWarning((String)"Material IMC: Material has no name", (Object[])new Object[0]);
            return null;
        }
        String name = tag.func_74779_i("Name");
        if (!tag.func_74764_b("Id")) {
            FMLLog.bigWarning((String)("Material IMC: Materials need a unique id. " + name), (Object[])new Object[0]);
            return null;
        }
        if (!tag.func_74764_b("Durability")) {
            FMLLog.bigWarning((String)("Material IMC: Materials need a durability. " + name), (Object[])new Object[0]);
            return null;
        }
        if (!tag.func_74764_b("MiningSpeed")) {
            FMLLog.bigWarning((String)("Material IMC: Materials need a mining speed. " + name), (Object[])new Object[0]);
            return null;
        }
        if (tag.func_74764_b("Stonebound") && tag.func_74764_b("Jagged")) {
            FMLLog.bigWarning((String)("Material IMC: Materials can only be Stonebound or Jagged. " + name), (Object[])new Object[0]);
            return null;
        }
        int hlvl = tag.func_74762_e("HarvestLevel");
        int durability = tag.func_74762_e("Durability");
        int speed = tag.func_74762_e("MiningSpeed");
        int attack = tag.func_74762_e("Attack");
        float handle = tag.func_74760_g("HandleModifier");
        int reinforced = tag.func_74762_e("Reinforced");
        float shoddy = tag.func_74760_g("Stonebound");
        String style = tag.func_74779_i("Style");
        int color = tag.func_74762_e("Color");
        if (tag.func_74764_b("Jagged")) {
            shoddy = -tag.func_74760_g("Jagged");
        }
        if (tag.func_74764_b("localizationString")) {
            return new ToolMaterial(name, tag.func_74779_i("localizationString"), hlvl, durability, speed, attack, handle, reinforced, shoddy, style, color);
        }
        return new ToolMaterial(name, hlvl, durability, speed, attack, handle, reinforced, shoddy, style, color);
    }

    public static void bigWarning(String format, Object ... data) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        TConstruct.logger.error("**********************************************************************");
        TConstruct.logger.error(String.format("* " + format, data));
        for (int i = 2; i < 8 && i < trace.length; ++i) {
            TConstruct.logger.error(String.format("*  at %s%s", trace[i].toString(), i == 7 ? "..." : ""));
        }
        TConstruct.logger.error("**********************************************************************");
    }
}

