/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.tile;

import cpw.mods.fml.common.registry.GameRegistry;
import io.endertech.block.ETBlocks;
import io.endertech.gui.client.GuiTank;
import io.endertech.gui.container.ContainerTank;
import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockValidationException;
import io.endertech.multiblock.block.BlockTankController;
import io.endertech.multiblock.block.BlockTankPart;
import io.endertech.multiblock.controller.ControllerTank;
import io.endertech.multiblock.tile.TileTankPartBase;
import io.endertech.network.PacketETBase;
import io.endertech.util.BlockCoord;
import io.endertech.util.IOutlineDrawer;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTankPart
extends TileTankPartBase
implements IOutlineDrawer {
    public static void init() {
        GameRegistry.registerTileEntity(TileTankPart.class, (String)"tile.endertech.enderTankPart");
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (BlockTankPart.isFrame(metadata)) {
            return;
        }
        throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.tank.part.unsuitable.frame", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (BlockTankPart.isFrame(metadata)) {
            return;
        }
        throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.tank.part.unsuitable.top", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (BlockTankPart.isFrame(metadata)) {
            return;
        }
        throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.tank.part.unsuitable.bottom", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(LocalisationHelper.localiseString("info.multiblock.tank.part.unsuitable.interior", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void onMachineActivated() {
        int metadata;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145838_q() == ETBlocks.blockTankController && BlockTankController.isController(metadata = this.func_145832_p())) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 2);
        }
    }

    @Override
    public void onMachineDeactivated() {
        int metadata;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145838_q() == ETBlocks.blockTankController && BlockTankController.isController(metadata = this.func_145832_p())) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
        }
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockController) {
        super.onMachineAssembled(multiblockController);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (multiblockController == null) {
            throw new IllegalArgumentException("Being assembled into a null controller. This should never happen. Please report this stacktrace to http://github.com/Drayshak/EnderTech/");
        }
        if (this.getMultiblockController() == null) {
            LogHelper.warn(LocalisationHelper.localiseString("warning.multiblock.tank.null_controller_assembly", this.field_145851_c, this.field_145848_d, this.field_145849_e), new Object[0]);
            this.onAttached(multiblockController);
        }
        int metadata = this.func_145832_p();
        Block blockType = this.func_145838_q();
        if (blockType == ETBlocks.blockTankPart) {
            if (BlockTankPart.isFrame(metadata)) {
                this.setCasingMetadataBasedOnWorldPosition();
            }
        } else if (blockType == ETBlocks.blockTankController && BlockTankController.isController(metadata)) {
            if (!this.getTankController().isActive()) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
            } else {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 2);
            }
        }
    }

    @Override
    public void onMachineBroken() {
        int metadata;
        super.onMachineBroken();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145838_q() == ETBlocks.blockTankPart && BlockTankPart.isFrame(metadata = this.func_145832_p())) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        }
    }

    private void setCasingMetadataBasedOnWorldPosition() {
        MultiblockControllerBase controller = this.getMultiblockController();
        assert (controller != null);
        BlockCoord minCoord = controller.getMinimumCoord();
        BlockCoord maxCoord = controller.getMaximumCoord();
        int extremes = 0;
        boolean zExtreme = false;
        boolean yExtreme = false;
        boolean xExtreme = false;
        if (this.field_145851_c == minCoord.x) {
            ++extremes;
            xExtreme = true;
        }
        if (this.field_145848_d == minCoord.y) {
            ++extremes;
            yExtreme = true;
        }
        if (this.field_145849_e == minCoord.z) {
            ++extremes;
            zExtreme = true;
        }
        if (this.field_145851_c == maxCoord.x) {
            ++extremes;
            xExtreme = true;
        }
        if (this.field_145848_d == maxCoord.y) {
            ++extremes;
            yExtreme = true;
        }
        if (this.field_145849_e == maxCoord.z) {
            ++extremes;
            zExtreme = true;
        }
        if (extremes == 3) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
        } else if (extremes == 2) {
            if (!xExtreme) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 4, 2);
            } else if (!zExtreme) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, 2);
            } else {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, 2);
            }
        } else if (extremes == 1) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        }
    }

    @Override
    public PacketETBase getPacket() {
        PacketETBase tileBasePacket = super.getPacket();
        boolean isConnectedAndSaveDelegate = this.isConnected() && this.isMultiblockSaveDelegate();
        tileBasePacket.addBool(isConnectedAndSaveDelegate);
        if (isConnectedAndSaveDelegate) {
            return this.getTankController().getPacket(tileBasePacket);
        }
        return tileBasePacket;
    }

    @Override
    public void handleTilePacket(PacketETBase packetETBase, boolean isServer) {
        super.handleTilePacket(packetETBase, isServer);
        boolean tileWasConnectedAndWasDelegate = packetETBase.getBool();
        if (!isServer) {
            if (!tileWasConnectedAndWasDelegate) {
                return;
            }
            ControllerTank controller = this.getTankController();
            if (controller == null) {
                this.cachedMultiblockPacket = packetETBase;
            } else {
                controller.handleTilePacket(packetETBase, isServer);
            }
        }
    }

    protected boolean canInteractFromDirection(ForgeDirection from) {
        return this.isConnected() && this.getTankController().isAssembled() && this.getOutwardsDir().contains(from);
    }

    protected void updateOutwardNeighbours() {
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    @Override
    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiTank(inventory, this);
    }

    @Override
    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTank(inventory, this);
    }

    @Override
    public boolean hasGui() {
        return this.isConnected() && this.getMultiblockController().isAssembled();
    }
}

