/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.EnderTech;
import io.endertech.util.helper.LogHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemETBase
extends Item {
    public HashMap<Integer, String> items = new HashMap();
    public HashMap<String, IIcon> icons = new HashMap();
    public HashMap<Integer, Integer> rarities = new HashMap();
    private boolean hasTextures = true;

    public ItemETBase() {
        this.setDefaultProperties();
    }

    public ItemETBase(String modName) {
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        this.field_77777_bU = 1;
        this.func_77627_a(true);
        this.func_77637_a(EnderTech.tabET);
        this.setNoRepair();
    }

    public ItemStack addItem(int number, String name, int rarity, boolean shouldRegister) {
        if (this.items.containsKey(number)) {
            return null;
        }
        this.items.put(number, name);
        this.rarities.put(number, rarity);
        ItemStack item = new ItemStack((Item)this, 1, number);
        if (shouldRegister) {
            GameRegistry.registerCustomItemStack((String)name, (ItemStack)item);
        }
        return item;
    }

    public ItemStack addItem(int number, String name) {
        return this.addItem(number, name, 0, true);
    }

    public ItemStack addItem(int number, String name, int rarity) {
        return this.addItem(number, name, rarity, true);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        if (!this.hasTextures) {
            return;
        }
        for (Map.Entry<Integer, String> entry : this.items.entrySet()) {
            String name = entry.getValue();
            String icon_name = "endertech:" + this.func_77658_a().replace("item.endertech.", "") + "/" + name;
            LogHelper.debug("Registering icon: " + icon_name, new Object[0]);
            this.icons.put(name, iconRegister.func_94245_a(icon_name));
        }
    }

    public IIcon func_77617_a(int i) {
        if (!this.items.containsKey(i)) {
            return null;
        }
        return this.icons.get(this.items.get(i));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Map.Entry<Integer, String> entry : this.items.entrySet()) {
            par3List.add(new ItemStack(par1, 1, entry.getKey().intValue()));
        }
    }

    public Item func_77655_b(String name) {
        name = "endertech." + name;
        return super.func_77655_b(name);
    }

    public String func_77667_c(ItemStack stack) {
        int i = stack.func_77960_j();
        if (!this.items.containsKey(i)) {
            return "item.invalid";
        }
        return this.func_77658_a() + '.' + this.items.get(i);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int i = stack.func_77960_j();
        if (!this.rarities.containsKey(i)) {
            return EnumRarity.common;
        }
        return EnumRarity.values()[this.rarities.get(stack.func_77960_j())];
    }
}

