/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.opengl.GL11;

public class ElementTextField
extends ElementBase {
    public int borderColor = new GuiColor(55, 55, 55).getColor();
    public int backgroundColor = new GuiColor(139, 139, 139).getColor();
    public int disabledColor = new GuiColor(198, 198, 198).getColor();
    public int selectedLineColor = new GuiColor(160, 160, 224).getColor();
    public int textColor = new GuiColor(224, 224, 224).getColor();
    public int selectedTextColor = new GuiColor(224, 224, 224).getColor();
    public int defaultCaretColor = new GuiColor(255, 255, 255).getColor();
    protected char[] text;
    protected int textLength;
    protected int selectionStart;
    protected int selectionEnd;
    protected int renderStart;
    protected int caret;
    private boolean isFocused;
    private boolean canFocusChange = true;
    private boolean selecting;
    private byte caretCounter;
    protected boolean caretInsert;
    protected boolean smartCaret = true;
    protected boolean smartCaretCase = true;
    protected boolean enableStencil = true;

    public ElementTextField(GuiBase gui, int posX, int posY, int width, int height) {
        this(gui, posX, posY, width, height, 32);
    }

    public ElementTextField(GuiBase gui, int posX, int posY, int width, int height, short limit) {
        super(gui, posX, posY, width, height);
        this.setMaxLength(limit);
    }

    public ElementTextField setTextColor(Number textColor, Number selectedTextColor) {
        if (textColor != null) {
            this.textColor = textColor.intValue();
        }
        if (selectedTextColor != null) {
            this.selectedTextColor = selectedTextColor.intValue();
        }
        return this;
    }

    public ElementTextField setSelectionColor(Number selectedLineColor, Number defaultCaretColor) {
        if (selectedLineColor != null) {
            this.selectedLineColor = selectedLineColor.intValue();
        }
        if (defaultCaretColor != null) {
            this.defaultCaretColor = defaultCaretColor.intValue();
        }
        return this;
    }

    public ElementTextField setBackgroundColor(Number backgroundColor, Number disabledColor, Number borderColor) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor.intValue();
        }
        if (disabledColor != null) {
            this.disabledColor = disabledColor.intValue();
        }
        if (borderColor != null) {
            this.borderColor = borderColor.intValue();
        }
        return this;
    }

    public ElementTextField setFocusable(boolean focusable) {
        this.canFocusChange = focusable;
        return this;
    }

    public ElementTextField setFocused(boolean focused) {
        if (this.canFocusChange) {
            this.isFocused = focused;
            this.caretCounter = 0;
        }
        return this;
    }

    public ElementTextField setText(String text) {
        this.selectionStart = 0;
        this.selectionEnd = this.textLength;
        this.writeText(text);
        return this;
    }

    public ElementTextField setMaxLength(short limit) {
        char[] oldText = this.text;
        this.text = new char[limit];
        this.textLength = Math.min(limit, this.textLength);
        if (oldText != null) {
            System.arraycopy(oldText, 0, this.text, 0, this.textLength);
        }
        this.findRenderStart();
        return this;
    }

    public int getMaxStringLength() {
        return this.text.length;
    }

    public boolean isFocused() {
        return this.isEnabled() && this.isFocused;
    }

    public boolean isFocusable() {
        return this.canFocusChange;
    }

    public int getContentWidth() {
        FontRenderer font = this.getFontRenderer();
        int width = 0;
        for (int i = 0; i < this.textLength; ++i) {
            width += font.func_78263_a(this.text[i]);
        }
        return width;
    }

    public int getVisibleWidth() {
        FontRenderer font = this.getFontRenderer();
        int width = 0;
        int endX = this.sizeX - 1;
        for (int i = this.renderStart; i < this.textLength; ++i) {
            int charW = font.func_78263_a(this.text[i]);
            if (!this.enableStencil && width + charW > endX) break;
            if ((width += charW) < endX) continue;
            width = Math.min(width, endX);
            break;
        }
        return width;
    }

    public String getText() {
        return new String(this.text, 0, this.textLength);
    }

    public String getSelectedText() {
        if (this.selectionStart != this.selectionEnd) {
            return new String(this.text, this.selectionStart, this.selectionEnd);
        }
        return this.getText();
    }

    public void writeText(String text) {
        int i;
        int e = text.length();
        for (i = 0; i < e && this.insertCharacter(text.charAt(i)); ++i) {
        }
        this.clearSelection();
        this.findRenderStart();
        this.onCharacterEntered(i > 0);
    }

    public boolean isAllowedCharacter(char charTyped) {
        return ChatAllowedCharacters.func_71566_a((char)charTyped);
    }

    protected boolean onEnter() {
        return false;
    }

    protected void onFocusLost() {
    }

    protected void onCharacterEntered(boolean success) {
    }

    protected boolean insertCharacter(char charTyped) {
        if (this.isAllowedCharacter(charTyped)) {
            if (this.selectionStart != this.selectionEnd) {
                if (this.caret == this.selectionStart) {
                    ++this.caret;
                }
                this.text[this.selectionStart++] = charTyped;
                return true;
            }
            if (this.caretInsert && this.caret == this.text.length || this.textLength == this.text.length) {
                return false;
            }
            if (!this.caretInsert) {
                if (this.caret < this.textLength) {
                    System.arraycopy(this.text, this.caret, this.text, this.caret + 1, this.textLength - this.caret);
                }
                ++this.textLength;
            }
            this.text[this.caret++] = charTyped;
            return true;
        }
        return true;
    }

    protected void findRenderStart() {
        this.caret = MathHelper.clampI(this.caret, 0, this.textLength);
        if (this.caret < this.renderStart) {
            this.renderStart = this.caret;
            return;
        }
        FontRenderer font = this.getFontRenderer();
        int endX = this.sizeX - 2;
        int width = 0;
        for (int i = this.renderStart; i < this.caret; ++i) {
            width += font.func_78263_a(this.text[i]);
            while (width >= endX) {
                width -= font.func_78263_a(this.text[this.renderStart++]);
                if (this.renderStart < this.textLength) continue;
                return;
            }
        }
    }

    protected void clearSelection() {
        if (this.selectionStart != this.selectionEnd) {
            if (this.selectionEnd < this.textLength) {
                System.arraycopy(this.text, this.selectionEnd, this.text, this.selectionStart, this.textLength - this.selectionEnd);
            }
            this.textLength -= this.selectionEnd - this.selectionStart;
            this.selectionEnd = this.caret = this.selectionStart;
            this.findRenderStart();
            this.onCharacterEntered(true);
        }
    }

    protected final int seekNextCaretLocation(int pos) {
        return this.seekNextCaretLocation(pos, true);
    }

    protected int seekNextCaretLocation(int pos, boolean forward) {
        char curChar;
        int i;
        int e;
        int dir = forward ? 1 : -1;
        int n = e = forward ? this.textLength : 0;
        if (pos == this.textLength) {
            --pos;
        }
        char prevChar = this.text[pos];
        while (pos != e && Character.isSpaceChar(prevChar)) {
            prevChar = this.text[pos += dir];
        }
        if (this.smartCaret) {
            for (i = pos; i != e; i += dir) {
                boolean caze;
                curChar = this.text[i];
                boolean bl = caze = Character.isUpperCase(curChar) != Character.isUpperCase(prevChar);
                if (!(!caze && Character.isSpaceChar(curChar) == Character.isSpaceChar(prevChar) && Character.isLetterOrDigit(curChar) == Character.isLetterOrDigit(prevChar) || pos + dir == i && Character.isLetterOrDigit(curChar))) {
                    return i + (this.smartCaretCase && caze && Character.isUpperCase(prevChar) ? -dir : 0);
                }
                prevChar = curChar;
            }
        }
        for (i = pos; i != e; i += dir) {
            curChar = this.text[i];
            if (Character.isSpaceChar(curChar) == Character.isSpaceChar(prevChar)) continue;
            return i;
        }
        return forward ? this.textLength : 0;
    }

    @Override
    public boolean onKeyTyped(char charTyped, int keyTyped) {
        if (!this.isFocused()) {
            return false;
        }
        switch (charTyped) {
            case '\u0001': {
                this.selectionEnd = this.caret = this.textLength;
                this.selectionStart = 0;
                this.findRenderStart();
                return true;
            }
            case '\u0003': {
                if (this.selectionStart != this.selectionEnd) {
                    GuiScreen.func_146275_d((String)this.getSelectedText());
                }
                return true;
            }
            case '\u0018': {
                if (this.selectionStart != this.selectionEnd) {
                    GuiScreen.func_146275_d((String)this.getSelectedText());
                    this.clearSelection();
                }
                return true;
            }
            case '\u0016': {
                this.writeText(GuiScreen.func_146277_j());
                return true;
            }
        }
        switch (keyTyped) {
            case 1: {
                this.setFocused(false);
                return !this.isFocused();
            }
            case 28: 
            case 156: {
                return this.onEnter();
            }
            case 210: {
                if (GuiScreen.func_146272_n()) {
                    this.writeText(GuiScreen.func_146277_j());
                } else {
                    this.caretInsert = !this.caretInsert;
                }
                return true;
            }
            case 218: {
                this.clearSelection();
                return true;
            }
            case 211: {
                boolean changed = false;
                if (!GuiScreen.func_146272_n()) {
                    if (this.selectionStart != this.selectionEnd) {
                        this.clearSelection();
                    } else if (GuiScreen.func_146271_m()) {
                        int size = this.seekNextCaretLocation(this.caret, true) - this.caret;
                        this.selectionStart = this.caret;
                        this.selectionEnd = this.caret + size;
                        this.clearSelection();
                    } else if (this.caret < this.textLength && this.textLength > 0) {
                        --this.textLength;
                        System.arraycopy(this.text, this.caret + 1, this.text, this.caret, this.textLength - this.caret);
                        changed = true;
                    }
                    if (this.caret <= this.renderStart) {
                        this.renderStart = MathHelper.clampI(this.caret - 3, 0, this.textLength);
                    }
                    this.findRenderStart();
                    this.onCharacterEntered(changed);
                    return true;
                }
            }
            case 14: {
                boolean changed = false;
                if (this.selectionStart != this.selectionEnd) {
                    this.clearSelection();
                } else if (GuiScreen.func_146271_m()) {
                    int size = this.seekNextCaretLocation(this.caret, false) - this.caret;
                    this.selectionStart = this.caret + size;
                    this.selectionEnd = this.caret;
                    this.clearSelection();
                } else if (this.caret > 0 && this.textLength > 0) {
                    --this.caret;
                    System.arraycopy(this.text, this.caret + 1, this.text, this.caret, this.textLength - this.caret);
                    --this.textLength;
                    changed = true;
                }
                if (this.caret <= this.renderStart) {
                    this.renderStart = MathHelper.clampI(this.caret - 3, 0, this.textLength);
                }
                this.findRenderStart();
                this.onCharacterEntered(changed);
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    if (this.caret > this.selectionEnd) {
                        this.selectionEnd = this.selectionStart;
                    }
                    this.selectionStart = 0;
                } else {
                    this.selectionEnd = 0;
                    this.selectionStart = 0;
                }
                this.caret = 0;
                this.renderStart = 0;
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    if (this.caret < this.selectionStart) {
                        this.selectionStart = this.selectionEnd;
                    }
                    this.selectionEnd = this.textLength;
                } else {
                    this.selectionStart = this.selectionEnd = this.textLength;
                }
                this.caret = this.textLength;
                this.findRenderStart();
                return true;
            }
            case 203: 
            case 205: {
                int size;
                int n = size = keyTyped == 203 ? -1 : 1;
                if (GuiScreen.func_146271_m()) {
                    size = this.seekNextCaretLocation(this.caret, keyTyped == 205) - this.caret;
                }
                if (this.selectionStart == this.selectionEnd || !GuiScreen.func_146272_n()) {
                    this.selectionStart = this.selectionEnd = this.caret;
                }
                int t = this.caret;
                this.caret = MathHelper.clampI(this.caret + size, 0, this.textLength);
                size = this.caret - t;
                this.findRenderStart();
                if (GuiScreen.func_146272_n()) {
                    if (this.caret == this.selectionStart + size) {
                        this.selectionStart = this.caret;
                    } else if (this.caret == this.selectionEnd + size) {
                        this.selectionEnd = this.caret;
                    }
                    if (this.selectionStart > this.selectionEnd) {
                        t = this.selectionStart;
                        this.selectionStart = this.selectionEnd;
                        this.selectionEnd = t;
                    }
                }
                return true;
            }
        }
        if (this.isAllowedCharacter(charTyped)) {
            boolean typed = this.insertCharacter(charTyped);
            this.clearSelection();
            this.findRenderStart();
            this.onCharacterEntered(typed);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        boolean bl = this.selecting = mouseButton == 0;
        if (this.selecting) {
            if (this.textLength == 0) {
                this.caret = 0;
                this.selectionEnd = 0;
                this.selectionStart = 0;
            } else {
                int charW;
                FontRenderer font = this.getFontRenderer();
                int pos = mouseX - this.posX - 1;
                int i = this.renderStart;
                int width = 0;
                while ((width += (charW = font.func_78263_a(this.text[i]))) <= pos && ++i < this.textLength) {
                }
                this.selectionEnd = this.caret = i;
                this.selectionStart = this.caret;
            }
        }
        this.setFocused(true);
        return true;
    }

    @Override
    public void update(int mouseX, int mouseY) {
        this.caretCounter = (byte)(this.caretCounter + 1);
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        if (!this.selecting) {
            boolean focus = this.isFocused();
            this.setFocused(false);
            if (focus && !this.isFocused()) {
                this.onFocusLost();
            }
        }
        this.selecting = false;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.drawModalRect(this.posX - 1, this.posY - 1, this.posX + this.sizeX + 1, this.posY + this.sizeY + 1, this.borderColor);
        this.drawModalRect(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, this.isEnabled() ? this.backgroundColor : this.disabledColor);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.enableStencil) {
            GL11.glEnable((int)2960);
            GL11.glClear((int)1024);
            this.drawStencil(this.posX + 1, this.posY + 1, this.posX + this.sizeX - 1, this.posY + this.sizeY - 1, 1);
        }
        FontRenderer font = this.getFontRenderer();
        char[] text = this.text;
        int startX = this.posX + 1;
        int endX = this.sizeX - 1;
        int startY = this.posY + 1;
        int endY = startY + font.field_78288_b;
        int width = 0;
        for (int i = this.renderStart; i <= this.textLength; ++i) {
            int caretEnd;
            boolean drawCaret;
            boolean end = i == this.textLength;
            int charW = 2;
            if (!end) {
                charW = font.func_78263_a(text[i]);
                if (!this.enableStencil && width + charW > endX) break;
            }
            boolean bl = drawCaret = i == this.caret && (this.caretCounter = (byte)(this.caretCounter & 0x1F)) < 16 && this.isFocused();
            if (drawCaret) {
                caretEnd = width + 2;
                if (this.caretInsert) {
                    caretEnd = width + charW;
                }
                this.drawModalRect(startX + width, startY - 1, startX + caretEnd, endY, 0xFF000000 & this.defaultCaretColor | ~this.defaultCaretColor & 0xFFFFFF);
            }
            if (!end) {
                boolean selected = i >= this.selectionStart & i < this.selectionEnd;
                if (selected) {
                    this.drawModalRect(startX + width, startY, startX + width + charW, endY, this.selectedLineColor);
                }
                font.func_78276_b(String.valueOf(text[i]), startX + width, startY, selected ? this.selectedTextColor : this.textColor);
            }
            if (drawCaret) {
                caretEnd = width + 2;
                if (this.caretInsert) {
                    caretEnd = width + charW;
                }
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)775, (int)0);
                this.gui.drawSizedRect(startX + width, startY - 1, startX + caretEnd, endY, -1);
                GL11.glDisable((int)3042);
            }
            if ((width += charW) > endX) break;
        }
        if (this.enableStencil) {
            GL11.glDisable((int)2960);
        }
    }
}

