/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class ElementIcon
extends ElementBase {
    protected IIcon icon;
    protected int spriteSheet;
    protected GuiColor color = new GuiColor(-1);

    public ElementIcon(GuiBase gui, int posX, int posY, IIcon icon) {
        this(gui, posX, posY, icon, 0);
    }

    public ElementIcon(GuiBase gui, int posX, int posY, IIcon icon, int spriteSheet) {
        super(gui, posX, posY);
        this.icon = icon;
        this.spriteSheet = spriteSheet;
    }

    public ElementIcon setColor(Number color) {
        this.color = new GuiColor(color.intValue());
        return this;
    }

    public ElementIcon setIcon(IIcon icon) {
        this.icon = icon;
        return this;
    }

    public ElementIcon setSpriteSheet(int spriteSheet) {
        this.spriteSheet = spriteSheet;
        return this;
    }

    public int getColor() {
        return this.color.getColor();
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        if (this.icon != null) {
            GL11.glColor4f((float)this.color.getFloatR(), (float)this.color.getFloatG(), (float)this.color.getFloatB(), (float)this.color.getFloatA());
            this.gui.drawColorIcon(this.icon, this.posX, this.posY, this.spriteSheet);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }
}

