/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.item.IControllable;
import tonius.simplyjetpacks.item.IHUDInfoProvider;
import tonius.simplyjetpacks.item.meta.FluxPack;
import tonius.simplyjetpacks.item.meta.Jetpack;
import tonius.simplyjetpacks.item.meta.PackBase;
import tonius.simplyjetpacks.setup.FuelType;
import tonius.simplyjetpacks.setup.ModCreativeTab;
import tonius.simplyjetpacks.setup.ModType;
import tonius.simplyjetpacks.util.StackUtils;
import tonius.simplyjetpacks.util.StringUtils;

public class ItemPack<T extends PackBase>
extends ItemArmor
implements IControllable,
ISpecialArmor,
IEnergyContainerItem,
IFluidContainerItem,
IHUDInfoProvider {
    private static final String TAG_ENERGY = "Energy";
    private static final String TAG_FLUID = "Fluid";
    public final ModType modType;
    private final Map<Integer, T> packs = new LinkedHashMap<Integer, T>();

    public ItemPack(ModType modType) {
        super(ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.modType = modType;
        this.func_77655_b("simplyjetpacks.pack" + modType.suffix);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(ModCreativeTab.tab);
    }

    public ItemStack putPack(int meta, T pack, boolean returnFull) {
        this.packs.put(meta, pack);
        ItemStack stack = new ItemStack((Item)this, 1, meta);
        if (returnFull) {
            this.addFuel(stack, this.getMaxFuelStored(stack), false);
        }
        return stack;
    }

    public ItemStack putPack(int meta, T pack) {
        return this.putPack(meta, pack, false);
    }

    public T getPack(ItemStack stack) {
        return (T)((PackBase)this.packs.get(stack.func_77960_j()));
    }

    public Collection<T> getPacks() {
        return this.packs.values();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        T pack = this.getPack(stack);
        if (pack != null && entity instanceof EntityPlayer) {
            ((PackBase)pack).tickInventory(world, (EntityPlayer)entity, stack, this);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            ((PackBase)pack).tickArmor(world, player, stack, this);
        }
    }

    public String func_77667_c(ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return "item.simplyjetpacks." + ((PackBase)pack).getBaseName() + this.modType.suffix;
        }
        return super.func_77658_a();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return ((PackBase)pack).rarity;
        }
        return super.func_77613_e(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return ((PackBase)pack).hasFuelIndicator;
        }
        return super.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double stored = this.getMaxFuelStored(stack) - this.getFuelStored(stack) + 1;
        double max = this.getMaxFuelStored(stack) + 1;
        return stored / max;
    }

    public int getItemEnchantability(ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return ((PackBase)pack).enchantability;
        }
        return super.getItemEnchantability(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.func_77619_b() > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.func_77619_b() > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        T pack = this.getPack(stack);
        if (pack != null) {
            ((PackBase)pack).addInformation(stack, this, player, list);
            if (StringUtils.canShowDetails()) {
                ((PackBase)pack).addShiftInformation(stack, this, player, list);
            } else {
                list.add(StringUtils.getShiftText());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Map.Entry<Integer, T> e : this.packs.entrySet()) {
            if (!((PackBase)e.getValue()).showInCreativeTab) continue;
            if (((PackBase)e.getValue()).showEmptyInCreativeTab) {
                list.add(new ItemStack((Item)this, 1, e.getKey().intValue()));
            }
            ItemStack full = new ItemStack((Item)this, 1, e.getKey().intValue());
            this.addFuel(full, this.getMaxFuelStored(full), false);
            list.add(full);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (PackBase pack : this.packs.values()) {
            pack.icon = register.func_94245_a("simplyjetpacks:" + pack.getBaseName() + this.modType.suffix);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        PackBase pack = (PackBase)this.packs.get(damage);
        if (pack != null && pack.icon != null) {
            return pack.icon;
        }
        return super.func_77617_a(damage);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return "simplyjetpacks:textures/armor/" + ((PackBase)pack).getBaseName() + this.modType.suffix + ".png";
        }
        return super.getArmorTexture(stack, entity, slot, type);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, int armorSlot) {
        ModelBiped model;
        T pack = this.getPack(stack);
        if (pack != null && ((PackBase)pack).armorModel != null && (model = RenderUtils.getArmorModel(pack, entityLiving)) != null) {
            return model;
        }
        return super.getArmorModel(entityLiving, stack, armorSlot);
    }

    @Override
    public void toggle(ItemStack stack, EntityPlayer player, boolean sneakChangesToggleBehavior, boolean showInChat) {
        T pack = this.getPack(stack);
        if (pack != null) {
            ((PackBase)pack).toggleOn(stack, player, sneakChangesToggleBehavior, showInChat);
        }
    }

    @Override
    public void switchMode(ItemStack stack, EntityPlayer player, boolean sneakChangesToggleBehavior, boolean showInChat) {
        T pack = this.getPack(stack);
        if (pack != null) {
            ((PackBase)pack).switchMode(stack, player, sneakChangesToggleBehavior, showInChat);
        }
    }

    protected int getFuelPerDamage(ItemStack stack, T pack) {
        int unbreakingLevel = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        return (int)Math.round((double)(((PackBase)pack).armorFuelPerHit * (5 - unbreakingLevel)) / 5.0);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        T pack = this.getPack(armor);
        if (pack != null && ((PackBase)pack).isArmored && !source.func_76363_c()) {
            if (((PackBase)pack).isFluxBased && source.field_76373_n.equals("flux")) {
                return new ISpecialArmor.ArmorProperties(0, 0.5, Integer.MAX_VALUE);
            }
            int energyPerDamage = this.getFuelPerDamage(armor, pack);
            int maxAbsorbed = energyPerDamage > 0 ? 25 * (this.getFuelStored(armor) / energyPerDamage) : 0;
            return new ISpecialArmor.ArmorProperties(0, 0.75 * ((double)((PackBase)pack).armorReduction / 20.0), maxAbsorbed);
        }
        return new ISpecialArmor.ArmorProperties(0, 1.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        T pack = this.getPack(armor);
        if (pack != null && ((PackBase)pack).isArmored && this.getFuelStored(armor) >= ((PackBase)pack).armorFuelPerHit) {
            return ((PackBase)pack).armorReduction;
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        T pack = this.getPack(armor);
        if (pack != null && ((PackBase)pack).isArmored && ((PackBase)pack).usesFuel) {
            if (((PackBase)pack).fuelType == FuelType.ENERGY && ((PackBase)pack).isFluxBased && source.field_76373_n.equals("flux")) {
                this.addFuel(armor, damage * (source.func_76346_g() == null ? ((PackBase)pack).armorFuelPerHit / 2 : this.getFuelPerDamage(armor, pack)), false);
            } else {
                this.useFuel(armor, damage * this.getFuelPerDamage(armor, pack), false);
            }
        }
    }

    public int getFuelStored(ItemStack stack) {
        T pack = this.getPack(stack);
        switch (((PackBase)pack).fuelType) {
            default: {
                return this.getEnergyStored(stack);
            }
            case FLUID: 
        }
        FluidStack stored = this.getFluid(stack);
        return stored != null ? stored.amount : 0;
    }

    public int getMaxFuelStored(ItemStack stack) {
        T pack = this.getPack(stack);
        switch (((PackBase)pack).fuelType) {
            default: {
                return this.getMaxEnergyStored(stack);
            }
            case FLUID: 
        }
        return this.getCapacity(stack);
    }

    public int addFuel(ItemStack stack, int maxAdd, boolean simulate) {
        T pack = this.getPack(stack);
        if (pack == null) {
            return 0;
        }
        switch (((PackBase)pack).fuelType) {
            default: {
                int energy = this.getEnergyStored(stack);
                int energyReceived = Math.min(this.getMaxEnergyStored(stack) - energy, maxAdd);
                if (!simulate) {
                    StackUtils.getNBT(stack).func_74768_a(TAG_ENERGY, energy += energyReceived);
                }
                return energyReceived;
            }
            case FLUID: 
        }
        if (((PackBase)pack).fuelFluid == null) {
            return 0;
        }
        FluidStack fluid = this.getFluid(stack);
        int amount = fluid != null ? fluid.amount : 0;
        int fluidReceived = Math.min(this.getCapacity(stack) - amount, maxAdd);
        if (!simulate) {
            StackUtils.getNBT(stack).func_74768_a(TAG_FLUID, amount += fluidReceived);
        }
        return fluidReceived;
    }

    public int useFuel(ItemStack stack, int maxUse, boolean simulate) {
        T pack = this.getPack(stack);
        switch (((PackBase)pack).fuelType) {
            default: {
                int energy = this.getEnergyStored(stack);
                int energyExtracted = Math.min(energy, maxUse);
                if (!simulate) {
                    StackUtils.getNBT(stack).func_74768_a(TAG_ENERGY, energy -= energyExtracted);
                }
                return energyExtracted;
            }
            case FLUID: 
        }
        if (((PackBase)pack).fuelFluid == null) {
            return 0;
        }
        FluidStack fluid = this.getFluid(stack);
        int amount = fluid != null ? fluid.amount : 0;
        int fluidExtracted = Math.min(amount, maxUse);
        if (!simulate) {
            StackUtils.getNBT(stack).func_74768_a(TAG_FLUID, amount -= fluidExtracted);
        }
        return fluidExtracted;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.ENERGY) {
            return 0;
        }
        int energy = this.getEnergyStored(container);
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(maxReceive, ((PackBase)pack).fuelPerTickIn));
        if (!simulate) {
            StackUtils.getNBT(container).func_74768_a(TAG_ENERGY, energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.ENERGY) {
            return 0;
        }
        int energy = this.getEnergyStored(container);
        int energyExtracted = Math.min(energy, Math.min(maxExtract, ((PackBase)pack).fuelPerTickOut));
        if (!simulate) {
            StackUtils.getNBT(container).func_74768_a(TAG_ENERGY, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.ENERGY) {
            return 0;
        }
        return StackUtils.getNBT(container).func_74762_e(TAG_ENERGY);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.ENERGY) {
            return 0;
        }
        return ((PackBase)pack).fuelCapacity;
    }

    public FluidStack getFluid(ItemStack container) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.FLUID || ((PackBase)pack).fuelFluid == null) {
            return null;
        }
        int amount = StackUtils.getNBT(container).func_74762_e(TAG_FLUID);
        return amount > 0 ? new FluidStack(FluidRegistry.getFluid((String)((PackBase)pack).fuelFluid), amount) : null;
    }

    public int getCapacity(ItemStack container) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.FLUID || ((PackBase)pack).fuelFluid == null) {
            return 0;
        }
        return ((PackBase)pack).fuelCapacity;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.FLUID || ((PackBase)pack).fuelFluid == null || resource.getFluid() != FluidRegistry.getFluid((String)((PackBase)pack).fuelFluid)) {
            return 0;
        }
        FluidStack fluid = this.getFluid(container);
        int amount = fluid != null ? fluid.amount : 0;
        int fluidReceived = Math.min(this.getCapacity(container) - amount, Math.min(resource.amount, ((PackBase)pack).fuelPerTickIn));
        if (doFill) {
            StackUtils.getNBT(container).func_74768_a(TAG_FLUID, amount += fluidReceived);
        }
        return fluidReceived;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.FLUID || ((PackBase)pack).fuelFluid == null) {
            return null;
        }
        FluidStack fluid = this.getFluid(container);
        int amount = fluid != null ? fluid.amount : 0;
        int fluidExtracted = Math.min(amount, Math.min(maxDrain, ((PackBase)pack).fuelPerTickOut));
        if (doDrain) {
            StackUtils.getNBT(container).func_74768_a(TAG_FLUID, amount -= fluidExtracted);
        }
        return fluidExtracted > 0 ? new FluidStack(FluidRegistry.getFluid((String)((PackBase)pack).fuelFluid), fluidExtracted) : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHUDInfo(ItemStack stack, List<String> list) {
        T pack = this.getPack(stack);
        if (pack != null) {
            if (((PackBase)pack).hasFuelIndicator) {
                list.add(((PackBase)pack).getHUDFuelInfo(stack, this));
            }
            if (((PackBase)pack).hasStateIndicators) {
                list.add(((PackBase)pack).getHUDStatesInfo(stack, this));
            }
        }
    }

    public static class ItemFluxPack
    extends ItemPack<FluxPack> {
        public ItemFluxPack(ModType modType) {
            super(modType);
        }
    }

    public static class ItemJetpack
    extends ItemPack<Jetpack> {
        public ItemJetpack(ModType modType) {
            super(modType);
        }
    }
}

