/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.config.Defaults;
import tonius.simplyjetpacks.config.Section;
import tonius.simplyjetpacks.item.meta.PackBase;

public class Config {
    public static final List<Section> configSections = new ArrayList<Section>();
    private static final Section sectionIntegration = new Section(false, "Integration Settings", "integration");
    private static final Section sectionControls = new Section(true, "Controls Settings", "controls");
    private static final Section sectionSounds = new Section(true, "Sound Settings", "sounds");
    private static final Section sectionGui = new Section(true, "GUI Settings", "gui");
    public static Configuration config;
    public static Configuration configClient;
    public static boolean enableIntegrationTE;
    public static boolean enableIntegrationEIO;
    public static boolean enableIntegrationBC;
    public static boolean customControls;
    public static String flyKey;
    public static String descendKey;
    public static boolean invertHoverSneakingBehavior;
    public static boolean sneakChangesToggleBehavior;
    public static boolean jetpackSounds;
    public static boolean holdShiftForDetails;
    public static int HUDPosition;
    public static int HUDOffsetX;
    public static int HUDOffsetY;
    public static double HUDScale;
    public static boolean showHUDWhileChatting;
    public static boolean enableFuelHUD;
    public static boolean minimalFuelHUD;
    public static boolean showExactFuelInHUD;
    public static boolean enableStateHUD;
    public static boolean enableStateChatMessages;

    public static void preInit(FMLPreInitializationEvent evt) {
        FMLCommonHandler.instance().bus().register((Object)new Config());
        config = new Configuration(new File(evt.getModConfigurationDirectory(), "simplyjetpacks.cfg"));
        configClient = new Configuration(new File(evt.getModConfigurationDirectory(), "simplyjetpacks-client.cfg"));
        Config.syncConfig();
        SimplyJetpacks.proxy.updateCustomKeybinds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncConfig() {
        SimplyJetpacks.logger.info("Loading configuration files");
        try {
            Config.processConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            config.save();
            configClient.save();
        }
    }

    public static void onConfigChanged(String modid) {
        if (modid.equals("simplyjetpacks")) {
            Config.syncConfig();
            SimplyJetpacks.proxy.updateCustomKeybinds();
        }
    }

    private static void processConfig() {
        enableIntegrationTE = config.get(Config.sectionIntegration.name, "Thermal Expansion integration", true, "When enabled, Simply Jetpacks will register its Thermal Expansion-based jetpacks and flux packs.").setRequiresMcRestart(true).getBoolean(true);
        enableIntegrationEIO = config.get(Config.sectionIntegration.name, "Ender IO integration", true, "When enabled, Simply Jetpacks will register its Ender IO-based jetpacks and flux packs.").setRequiresMcRestart(true).getBoolean(true);
        customControls = configClient.get(Config.sectionControls.name, "Custom controls", false, "When enabled, the key codes specified here will be used for the fly and descend keys. Otherwise, the vanilla jump and sneak keys will be used.").getBoolean(false);
        flyKey = configClient.get(Config.sectionControls.name, "Custom Fly key", "SPACE", "The name of the Fly key when custom controls are enabled.").getString();
        descendKey = configClient.get(Config.sectionControls.name, "Custom Descend key", "LSHIFT", "The name of the Descend key when custom controls are enabled.").getString();
        invertHoverSneakingBehavior = configClient.get(Config.sectionControls.name, "Invert Hover Mode sneaking behavior", false, "Invert Hover Mode sneaking behavior").getBoolean(false);
        sneakChangesToggleBehavior = configClient.get(Config.sectionControls.name, "Sneak Changes Toggle Behavior", true, "If enabled, when sneaking, the Turn on/off and Switch mode keys will respectively toggle JetPlate chargers and emergency hover mode. If not, use /simplyjetpacks_switch or /sjs to toggle these features.").getBoolean(true);
        jetpackSounds = configClient.get(Config.sectionSounds.name, "Jetpack Sounds", true, "When enabled, jetpacks will make sounds when used.").getBoolean(true);
        holdShiftForDetails = configClient.get(Config.sectionGui.name, "Hold Shift for Details", true, "When enabled, item details are only shown in the tooltip when holding Shift.").getBoolean(true);
        HUDPosition = configClient.get(Config.sectionGui.name, "HUD Base Position", Defaults.HUDPosition, "The base position of the HUD on the screen. 0 = top left, 1 = top center, 2 = top right, 3 = left, 4 = right, 5 = bottom left, 6 = bottom right").setMinValue(0).setMaxValue(RenderUtils.HUDPositions.values().length - 1).getInt(Defaults.HUDPosition);
        HUDOffsetX = configClient.get(Config.sectionGui.name, "HUD Offset - X", 0, "The HUD display will be shifted horizontally by this value. This value may be negative.").getInt(0);
        HUDOffsetY = configClient.get(Config.sectionGui.name, "HUD Offset - Y", 0, "The HUD display will be shifted vertically by this value. This value may be negative.").getInt(0);
        HUDScale = Math.abs(configClient.get(Config.sectionGui.name, "HUD Scale", 1.0, "How large the HUD will be rendered. Default is 1.0, can be bigger or smaller").setMinValue(0.001).getDouble(1.0));
        showHUDWhileChatting = configClient.get(Config.sectionGui.name, "Show HUD while chatting", true, "When enabled, the HUD will display even when the chat window is opened.").getBoolean(true);
        enableFuelHUD = configClient.get(Config.sectionGui.name, "Enable Fuel HUD", true, "When enabled, a HUD that displays the fuel level of the currently worn jetpack or flux pack will show.").getBoolean(true);
        minimalFuelHUD = configClient.get(Config.sectionGui.name, "Minimal Fuel HUD", false, "When enabled, only the fuel amounts themselves will be rendered on the fuel HUD.").getBoolean(false);
        showExactFuelInHUD = configClient.get(Config.sectionGui.name, "Exact fuel amounts in Energy HUD", false, "When enabled, the fuel HUD will display the exact amount of RF or mB other than just a percentage.").getBoolean(false);
        enableStateHUD = configClient.get(Config.sectionGui.name, "Enable State HUD", true, "When enabled, a HUD that displays the states (engine/mode/etc.) of the currently worn jetpack or flux pack will show.").getBoolean(true);
        enableStateChatMessages = configClient.get(Config.sectionGui.name, "Enable State Chat Messages", false, "When enabled, switching jetpacks or flux packs on or off will display chat messages.").getBoolean(false);
        PackBase.loadAllConfigs(config);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        Config.onConfigChanged(evt.modID);
    }

    static {
        enableIntegrationTE = true;
        enableIntegrationEIO = true;
        enableIntegrationBC = true;
        customControls = false;
        flyKey = "SPACE";
        descendKey = "LSHIFT";
        invertHoverSneakingBehavior = false;
        sneakChangesToggleBehavior = true;
        jetpackSounds = true;
        holdShiftForDetails = true;
        HUDPosition = Defaults.HUDPosition;
        HUDOffsetX = 0;
        HUDOffsetY = 0;
        HUDScale = 1.0;
        showHUDWhileChatting = true;
        enableFuelHUD = true;
        minimalFuelHUD = false;
        showExactFuelInHUD = false;
        enableStateHUD = true;
        enableStateChatMessages = false;
    }
}

