/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

public enum ReadableNumberConverter {
    INSTANCE;

    private static final int DIVISION_BASE = 1000;
    private static final double LOG_DIVISION_BASE;
    private static final char[] ENCODED_POSTFIXES;
    private static final int SHORT_THRESHOLD = 100;

    public String toHumanReadableForm(long number) {
        String sign = this.getSign(number);
        long absNumber = Math.abs(number);
        if (absNumber < 1000L) {
            return Long.toString(number);
        }
        int exp = (int)(Math.log(absNumber) / LOG_DIVISION_BASE);
        char postFix = ENCODED_POSTFIXES[exp - 1];
        int result = (int)((double)absNumber / Math.pow(1000.0, exp));
        return String.format("%s%d%s", sign, result, Character.valueOf(postFix));
    }

    private String getSign(long number) {
        if (number < 0L) {
            return "-";
        }
        return "";
    }

    public String toShortHumanReadableForm(long number) {
        String sign = this.getSign(number);
        long absNumber = Math.abs(number);
        if (absNumber < 1000L) {
            return Long.toString(number);
        }
        int exp = (int)(Math.log(absNumber) / LOG_DIVISION_BASE);
        int result = (int)((double)absNumber / Math.pow(1000.0, exp));
        if (result >= 100) {
            int shortResult = result / 100;
            char postFix = ENCODED_POSTFIXES[exp];
            return String.format("%s.%d%s", sign, shortResult, Character.valueOf(postFix));
        }
        char postFix = ENCODED_POSTFIXES[exp - 1];
        return String.format("%s%d%s", sign, result, Character.valueOf(postFix));
    }

    public String toLongHumanReadableForm(long number) {
        String sign = this.getSign(number);
        long absNumber = Math.abs(number);
        if (absNumber < 10000L) {
            return Long.toString(number);
        }
        int exp = (int)(Math.log(absNumber / 10L) / LOG_DIVISION_BASE);
        int result = (int)((double)absNumber / Math.pow(1000.0, exp));
        char postFix = ENCODED_POSTFIXES[exp - 1];
        return String.format("%s%d%s", sign, result, Character.valueOf(postFix));
    }

    static {
        LOG_DIVISION_BASE = Math.log(1000.0);
        ENCODED_POSTFIXES = "KMGTPE".toCharArray();
    }
}

