/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.ITileDefinition;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.parts.IFacadePart;
import appeng.api.util.AEItemDefinition;
import appeng.api.util.IOrientableBlock;
import appeng.facade.FacadePart;
import appeng.integration.BaseModule;
import appeng.integration.abstraction.IBC;
import appeng.integration.modules.BCHelpers.AECableSchematicTile;
import appeng.integration.modules.BCHelpers.AEGenericSchematicTile;
import appeng.integration.modules.BCHelpers.AERotatableBlockSchematic;
import appeng.integration.modules.BCHelpers.BCPipeHandler;
import buildcraft.BuildCraftEnergy;
import buildcraft.BuildCraftTransport;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.ISchematicRegistry;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.PipeIconProvider;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public final class BC
extends BaseModule
implements IBC {
    public static BC instance;

    public BC() {
        this.testClassExistence(IPipeConnection.class);
        this.testClassExistence(ItemFacade.class);
        this.testClassExistence(IToolWrench.class);
    }

    @Override
    public boolean isWrench(Item eq) {
        return eq instanceof IToolWrench;
    }

    @Override
    public boolean canWrench(Item i, EntityPlayer p, int x, int y, int z) {
        return ((IToolWrench)i).canWrench(p, x, y, z);
    }

    @Override
    public void wrenchUsed(Item i, EntityPlayer p, int x, int y, int z) {
        ((IToolWrench)i).wrenchUsed(p, x, y, z);
    }

    @Override
    public boolean canAddItemsToPipe(TileEntity te, ItemStack is, ForgeDirection dir) {
        int amt;
        IInjectable pt;
        return is != null && te != null && te instanceof IInjectable && (pt = (IInjectable)te).canInjectItems(dir) && (amt = pt.injectItem(is, false, dir, null)) == is.field_77994_a;
    }

    @Override
    public boolean addItemsToPipe(TileEntity te, ItemStack is, ForgeDirection dir) {
        int amt;
        IInjectable pt;
        if (is != null && te != null && te instanceof IInjectable && (pt = (IInjectable)te).canInjectItems(dir) && (amt = pt.injectItem(is, false, dir, null)) == is.field_77994_a) {
            pt.injectItem(is, true, dir, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isFacade(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() instanceof IFacadeItem;
    }

    @Override
    public boolean isPipe(TileEntity te, ForgeDirection dir) {
        if (te instanceof IPipeTile) {
            IPipeTile pipeTile = (IPipeTile)te;
            return !pipeTile.hasPipePluggable(dir.getOpposite());
        }
        return false;
    }

    @Override
    public void addFacade(ItemStack item) {
        if (item != null) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (ItemStack)item);
        }
    }

    @Override
    public void registerPowerP2P() {
        IP2PTunnelRegistry reg = AEApi.instance().registries().p2pTunnel();
        reg.addNewAttunement(new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 0), TunnelType.RF_POWER);
        reg.addNewAttunement(new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 1), TunnelType.RF_POWER);
        reg.addNewAttunement(new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 2), TunnelType.RF_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerCobblestone), TunnelType.RF_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerDiamond), TunnelType.RF_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerGold), TunnelType.RF_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerQuartz), TunnelType.RF_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerStone), TunnelType.RF_POWER);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipePowerWood), TunnelType.RF_POWER);
    }

    @Override
    public void registerItemP2P() {
        IP2PTunnelRegistry reg = AEApi.instance().registries().p2pTunnel();
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsWood), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsVoid), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsSandstone), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsQuartz), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsObsidian), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsIron), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsGold), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsEmerald), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsDiamond), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsStone), TunnelType.ITEM);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeItemsCobblestone), TunnelType.ITEM);
    }

    @Override
    public void registerLiquidsP2P() {
        IP2PTunnelRegistry reg = AEApi.instance().registries().p2pTunnel();
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsCobblestone), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsEmerald), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsGold), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsIron), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsSandstone), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsStone), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsVoid), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(BuildCraftTransport.pipeFluidsWood), TunnelType.FLUID);
    }

    @Override
    public IFacadePart createFacadePart(Block blk, int meta, ForgeDirection side) {
        try {
            ItemFacade.FacadeState state = ItemFacade.FacadeState.create((Block)blk, (int)meta);
            ItemStack facade = ItemFacade.getFacade((ItemFacade.FacadeState[])new ItemFacade.FacadeState[]{state});
            return new FacadePart(facade, side);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public IFacadePart createFacadePart(ItemStack fs, ForgeDirection side) {
        return new FacadePart(fs, side);
    }

    @Override
    public ItemStack getTextureForFacade(ItemStack facade) {
        Item maybeFacadeItem = facade.func_77973_b();
        if (maybeFacadeItem instanceof IFacadeItem) {
            IFacadeItem facadeItem = (IFacadeItem)maybeFacadeItem;
            Block[] blocks = facadeItem.getBlocksForFacade(facade);
            int[] metas = facadeItem.getMetaValuesForFacade(facade);
            if (blocks.length > 0 && metas.length > 0) {
                return new ItemStack(blocks[0], 1, metas[0]);
            }
        }
        return null;
    }

    @Override
    public IIcon getFacadeTexture() {
        try {
            return BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public void init() {
        IAppEngApi api = AEApi.instance();
        api.partHelper().registerNewLayer("appeng.parts.layers.LayerIPipeConnection", "buildcraft.api.transport.IPipeConnection");
        api.registries().externalStorage().addExternalStorageInterface(new BCPipeHandler());
        IBlocks blocks = api.definitions().blocks();
        this.addFacadeStack(blocks.fluix());
        this.addFacadeStack(blocks.quartz());
        this.addFacadeStack(blocks.quartzChiseled());
        this.addFacadeStack(blocks.quartzPillar());
        try {
            this.initBuilderSupport();
        }
        catch (Throwable builderSupport) {
            // empty catch block
        }
        for (Block skyStoneBlock : blocks.skyStone().maybeBlock().asSet()) {
            this.addFacade(new ItemStack(skyStoneBlock, 1, 0));
            this.addFacade(new ItemStack(skyStoneBlock, 1, 1));
            this.addFacade(new ItemStack(skyStoneBlock, 1, 2));
            this.addFacade(new ItemStack(skyStoneBlock, 1, 3));
        }
    }

    private void addFacadeStack(IBlockDefinition definition) {
        for (ItemStack facadeStack : definition.maybeStack(1).asSet()) {
            this.addFacade(facadeStack);
        }
    }

    private void initBuilderSupport() {
        ISchematicRegistry schematicRegistry = BuilderAPI.schematicRegistry;
        IBlocks blocks = AEApi.instance().definitions().blocks();
        ITileDefinition maybeMultiPart = blocks.multiPart();
        for (Method blockDefinition : blocks.getClass().getMethods()) {
            try {
                AEItemDefinition def = (AEItemDefinition)blockDefinition.invoke((Object)blocks, new Object[0]);
                Block myBlock = def.block();
                if (myBlock instanceof IOrientableBlock && ((IOrientableBlock)myBlock).usesMetadata() && def.entity() == null) {
                    schematicRegistry.registerSchematicBlock(myBlock, AERotatableBlockSchematic.class, new Object[0]);
                    continue;
                }
                if (maybeMultiPart.isSameAs(new ItemStack(myBlock))) {
                    schematicRegistry.registerSchematicBlock(myBlock, AECableSchematicTile.class, new Object[0]);
                    continue;
                }
                if (def.entity() == null) continue;
                schematicRegistry.registerSchematicBlock(myBlock, AEGenericSchematicTile.class, new Object[0]);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    @Override
    public void postInit() {
        this.registerPowerP2P();
        this.registerItemP2P();
        this.registerLiquidsP2P();
    }

    private void registerOrientableBlocks() {
    }
}

