/*
 * Decompiled with CFR 0.152.
 */
package appeng.fmp;

import appeng.block.AEBaseBlock;
import appeng.block.misc.BlockQuartzTorch;
import appeng.block.networking.BlockCableBus;
import appeng.core.Api;
import appeng.fmp.CableBusPart;
import appeng.fmp.QuartzTorchPart;
import codechicken.multipart.TMultiPart;
import net.minecraft.block.Block;

public enum PartRegistry {
    QuartzTorchPart("ae2_torch", BlockQuartzTorch.class, QuartzTorchPart.class),
    CableBusPart("ae2_cablebus", BlockCableBus.class, CableBusPart.class);

    private final String name;
    private final Class<? extends AEBaseBlock> blk;
    private final Class<? extends TMultiPart> part;

    private PartRegistry(String name, Class<? extends AEBaseBlock> blk, Class<? extends TMultiPart> part) {
        this.name = name;
        this.blk = blk;
        this.part = part;
    }

    public static String getPartName(TMultiPart part) {
        Class<?> c = part.getClass();
        for (PartRegistry pr : PartRegistry.values()) {
            if (!pr.equals(c)) continue;
            return pr.name;
        }
        throw new RuntimeException("Invalid PartName");
    }

    public static TMultiPart getPartByBlock(Block block, int meta) {
        for (PartRegistry pr : PartRegistry.values()) {
            if (!pr.blk.isInstance(block)) continue;
            return pr.construct(meta);
        }
        return null;
    }

    public TMultiPart construct(int meta) {
        try {
            if (this == CableBusPart) {
                return (TMultiPart)Api.INSTANCE.getPartHelper().getCombinedInstance(this.part.getName()).newInstance();
            }
            return this.part.getConstructor(Integer.TYPE).newInstance(meta);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static boolean isPart(Block block) {
        for (PartRegistry pr : PartRegistry.values()) {
            if (!pr.blk.isInstance(block)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }
}

