/*
 * Decompiled with CFR 0.152.
 */
package ichun.common.core.config;

import com.google.common.base.Splitter;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import ichun.client.keybind.KeyBind;
import ichun.common.core.config.IConfigUser;
import ichun.common.iChunUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Config
implements Comparable {
    public static int printKey = -1;
    public static String curMod = "sync";
    public static Configuration configKeybind;
    public final Configuration config;
    public final String modId;
    public final String modName;
    public final Logger logger;
    public final IConfigUser parent;
    public String currentCat;
    public String currentCatName;
    public HashMap<String, Property> props = new HashMap();
    public HashMap<Property, String> propName = new HashMap();
    public HashMap<String, String> propNameToProp = new HashMap();
    public HashMap<Property, int[]> minmax = new HashMap();
    public HashMap<Property, int[]> nestedMinmax = new HashMap();
    public ArrayList<Property> sessionProps = new ArrayList();
    public HashMap<String, ArrayList<Property>> categories = new HashMap();
    public ArrayList<String> categoriesList = new ArrayList();
    public HashMap<Property, EnumPropType> propType = new HashMap();
    public HashMap<String, KeyBind> keyBindMap = new HashMap();
    public ArrayList<Property> propNeedsRestart = new ArrayList();
    public ArrayList<String> unfound = new ArrayList();
    public EnumMap<Side, HashMap<String, Object>> sessionState = new EnumMap<Side, HashMap<String, Object>>(Side.class){
        {
            this.put(Side.CLIENT, new HashMap());
            this.put(Side.SERVER, new HashMap());
        }
    };
    private boolean setup;

    public Config(Configuration cfg, String ModId, String ModName, Logger lg, IConfigUser configParent) {
        this.config = cfg;
        this.modId = ModId;
        this.modName = ModName;
        this.logger = lg;
        this.setup = false;
        this.parent = configParent;
        this.currentCat = "general";
        this.currentCatName = StatCollector.func_74838_a((String)"ichun.config.cat.general.name");
    }

    public void resetSession() {
        this.sessionState.get(FMLCommonHandler.instance().getEffectiveSide()).clear();
        for (Property prop : this.sessionProps) {
            this.sessionState.get(FMLCommonHandler.instance().getEffectiveSide()).put(prop.getName(), prop.getType() == Property.Type.INTEGER ? Integer.valueOf(prop.getInt()) : prop.getString());
        }
    }

    public void updateSession(String s, Object obj) {
        this.sessionState.get(FMLCommonHandler.instance().getEffectiveSide()).put(s, obj);
    }

    public Property get(String s) {
        if (!this.props.containsKey(s) && !this.unfound.contains(s)) {
            this.unfound.add(s);
            if (this.logger != null) {
                this.logger.log(Level.WARN, "Tried to reference unknown property: " + s);
            }
        }
        return this.props.get(s);
    }

    public int getInt(String s) {
        Property prop = this.get(s);
        if (prop != null && prop.getType() == Property.Type.INTEGER) {
            return prop.getInt();
        }
        if (this.logger != null && !this.unfound.contains(s)) {
            this.unfound.add(s);
            this.logger.log(Level.WARN, "Tried to reference non-int property as int: " + s);
        }
        return -2;
    }

    public String getString(String s) {
        Property prop = this.get(s);
        if (prop != null && prop.getType() == Property.Type.STRING) {
            return prop.getString();
        }
        if (this.logger != null && !this.unfound.contains(s)) {
            this.unfound.add(s);
            this.logger.log(Level.WARN, "Tried to reference non-string property as string: " + s);
        }
        return "";
    }

    public HashMap<String, ArrayList<String>> getStringArray(String s) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        String s1 = this.getString(s);
        String[] split = s1.split(", *");
        if (split.length > 0 && !split[0].equalsIgnoreCase("")) {
            for (String splits : split) {
                String[] split1 = splits.split(": *");
                if (split1.length <= 0 || split1[0].equalsIgnoreCase("")) continue;
                if (split1.length == 1) {
                    map.put(split1[0], new ArrayList());
                    continue;
                }
                ArrayList<String> strings = new ArrayList<String>();
                for (int i = 1; i < split1.length; ++i) {
                    strings.add(split1[i]);
                }
                map.put(split1[0], strings);
            }
        }
        return map;
    }

    public KeyBind getKeyBind(String s) {
        KeyBind bind = this.keyBindMap.get(s);
        if (bind != null) {
            return bind;
        }
        bind = new KeyBind(0, false, false, false, false);
        this.keyBindMap.put(s, bind);
        if (this.logger != null && !this.unfound.contains(s)) {
            this.unfound.add(s);
            this.logger.log(Level.WARN, "Tried to reference non-existent keybind: " + s);
        }
        return bind;
    }

    public ArrayList<Integer> getIntArray(String s) {
        Property prop = this.get(s);
        if (prop != null && prop.getType() == Property.Type.STRING) {
            return this.parseIntArray(this.getString(s));
        }
        if (this.logger != null && !this.unfound.contains(s)) {
            this.unfound.add(s);
            this.logger.log(Level.WARN, "Tried to reference non-string property as string: " + s);
        }
        return new ArrayList<Integer>();
    }

    public LinkedHashMap<Integer, ArrayList<Integer>> getNestedIntArray(String s) {
        Property prop = this.get(s);
        if (prop != null && prop.getType() == Property.Type.STRING) {
            return this.parseNestedIntArray(this.getString(s));
        }
        if (this.logger != null && !this.unfound.contains(s)) {
            this.unfound.add(s);
            this.logger.log(Level.WARN, "Tried to reference non-string property as string: " + s);
        }
        return new LinkedHashMap<Integer, ArrayList<Integer>>();
    }

    public ArrayList<Integer> parseIntArray(String s) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] split = s.split(", *");
        if (split.length > 0 && !split[0].equalsIgnoreCase("")) {
            for (String splits : split) {
                try {
                    Integer i = Integer.parseInt(splits);
                    list.add(i);
                }
                catch (NumberFormatException e) {
                    if (this.logger != null) {
                        this.logger.log(Level.WARN, "Could not parse following as int: " + splits);
                    }
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public LinkedHashMap<Integer, ArrayList<Integer>> parseNestedIntArray(String s) {
        LinkedHashMap<Integer, ArrayList<Integer>> map = new LinkedHashMap<Integer, ArrayList<Integer>>();
        String[] split = s.split(", *");
        if (split.length > 0 && !split[0].equalsIgnoreCase("")) {
            for (String splits : split) {
                String[] split1 = splits.split(": *");
                if (split1.length <= 0 || split1[0].equalsIgnoreCase("")) continue;
                try {
                    if (split1.length == 1) {
                        map.put(Integer.parseInt(split1[0]), new ArrayList());
                        continue;
                    }
                    ArrayList<Integer> ints = new ArrayList<Integer>();
                    for (int i = 1; i < split1.length; ++i) {
                        try {
                            ints.add(Integer.parseInt(split1[i]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            if (this.logger != null) {
                                this.logger.log(Level.WARN, "Could not parse following as (nested) int: " + split1[i]);
                            }
                            e.printStackTrace();
                        }
                    }
                    map.put(Integer.parseInt(split1[0]), ints);
                }
                catch (NumberFormatException e) {
                    if (this.logger != null) {
                        this.logger.log(Level.WARN, "Could not parse following as int: " + split1[0]);
                    }
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    public int getSessionInt(String s) {
        Object obj = this.sessionState.get(FMLCommonHandler.instance().getEffectiveSide()).get(s);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -2;
    }

    public String getSessionString(String s) {
        Object obj = this.sessionState.get(FMLCommonHandler.instance().getEffectiveSide()).get(s);
        if (obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    public HashMap<String, ArrayList<String>> getSessionStringArray(String s) {
        Object obj = this.sessionState.get(FMLCommonHandler.instance().getEffectiveSide()).get(s);
        if (obj instanceof HashMap) {
            return (HashMap)obj;
        }
        return new HashMap<String, ArrayList<String>>();
    }

    public ArrayList<Integer> getSessionIntArray(String s) {
        Object obj = this.sessionState.get(FMLCommonHandler.instance().getEffectiveSide()).get(s);
        if (obj instanceof ArrayList) {
            return (ArrayList)obj;
        }
        return new ArrayList<Integer>();
    }

    public HashMap<Integer, ArrayList<Integer>> getSessionNestedIntArray(String s) {
        Object obj = this.sessionState.get(FMLCommonHandler.instance().getEffectiveSide()).get(s);
        if (obj instanceof HashMap) {
            return (HashMap)obj;
        }
        return new HashMap<Integer, ArrayList<Integer>>();
    }

    private void addToCategory(String catName, Property prop) {
        ArrayList<Object> categoryList;
        if (catName != null && this.categories.containsKey(catName) || catName == null && this.categories.containsKey("uncat")) {
            categoryList = this.categories.get(catName != null ? catName : "uncat");
        } else {
            categoryList = new ArrayList();
            this.categories.put(catName != null ? catName : "uncat", categoryList);
        }
        if (!categoryList.contains(prop)) {
            categoryList.add(prop);
        }
        if (this.setup && !this.categoriesList.contains(catName)) {
            this.categoriesList.add(catName);
            Collections.sort(this.categoriesList);
        }
    }

    public int createIntProperty(String propName1, String fullPropName, String comment, boolean changable, boolean isSessionProp, int i, int min, int max) {
        Property prop;
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 2) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".name=" + fullPropName);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 3) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment=" + comment);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 4) {
            System.out.println("config.createIntProperty(\"" + propName1 + "\", \"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".name\", " + "\"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment\", " + Boolean.toString(changable) + ", " + Boolean.toString(isSessionProp) + ", " + Integer.toString(i) + ", " + (min == Integer.MIN_VALUE ? "Integer.MIN_VALUE" : Integer.toString(min)) + ", " + (max == Integer.MAX_VALUE ? "Integer.MAX_VALUE" : Integer.toString(max)) + ");");
        }
        if (this.props.containsKey(propName1)) {
            prop = this.props.get(propName1);
            prop.set(i);
        } else {
            prop = this.config.get(this.currentCat, propName1, i);
            if (prop.getInt() > max) {
                prop.set(max);
            }
            if (prop.getInt() < min) {
                prop.set(min);
            }
        }
        if (!comment.equalsIgnoreCase("")) {
            List cms = Splitter.on((String)"\\n").splitToList((CharSequence)StatCollector.func_74838_a((String)comment));
            String cm = "";
            for (int ll = 0; ll < cms.size(); ++ll) {
                cm = cm + cms.get(ll);
                if (ll == cms.size() - 1) continue;
                cm = cm + "\n";
            }
            prop.comment = cm + "\n" + (min != Integer.MIN_VALUE ? "\nMin: " + min : "") + (max != Integer.MAX_VALUE ? "\nMax: " + max : "");
        }
        this.props.put(propName1, prop);
        this.propName.put(prop, fullPropName);
        this.propNameToProp.put(fullPropName, propName1);
        this.minmax.put(prop, new int[]{min, max});
        this.propType.put(prop, EnumPropType.INT);
        if (!changable && !this.propNeedsRestart.contains(prop)) {
            this.propNeedsRestart.add(prop);
        }
        if (isSessionProp && !this.sessionProps.contains(prop)) {
            this.sessionProps.add(prop);
        }
        this.addToCategory(this.currentCatName, prop);
        this.save();
        return prop.getInt();
    }

    public int createIntBoolProperty(String propName1, String fullPropName, String comment, boolean changable, boolean isSessionProp, boolean flag) {
        Property prop;
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 2) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".name=" + fullPropName);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 3) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment=" + comment);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 4) {
            System.out.println("config.createIntBoolProperty(\"" + propName1 + "\", \"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".name\", " + "\"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment\", " + Boolean.toString(changable) + ", " + Boolean.toString(isSessionProp) + ", " + Boolean.toString(flag) + ");");
        }
        if (this.props.containsKey(propName1)) {
            prop = this.props.get(propName1);
            prop.set(flag ? 1 : 0);
        } else {
            prop = this.config.get(this.currentCat, propName1, flag ? 1 : 0);
            if (prop.getInt() > 1) {
                prop.set(1);
            }
            if (prop.getInt() < 0) {
                prop.set(0);
            }
        }
        if (!comment.equalsIgnoreCase("")) {
            List cms = Splitter.on((String)"\\n").splitToList((CharSequence)StatCollector.func_74838_a((String)comment));
            String cm = "";
            for (int ll = 0; ll < cms.size(); ++ll) {
                cm = cm + cms.get(ll);
                if (ll == cms.size() - 1) continue;
                cm = cm + "\n";
            }
            prop.comment = cm + "\n\nMin: 0\nMax: 1";
        }
        this.props.put(propName1, prop);
        this.propName.put(prop, fullPropName);
        this.propNameToProp.put(fullPropName, propName1);
        this.minmax.put(prop, new int[]{0, 1});
        this.propType.put(prop, EnumPropType.INT_BOOL);
        if (!changable && !this.propNeedsRestart.contains(prop)) {
            this.propNeedsRestart.add(prop);
        }
        if (isSessionProp && !this.sessionProps.contains(prop)) {
            this.sessionProps.add(prop);
        }
        this.addToCategory(this.currentCatName, prop);
        this.save();
        return prop.getInt();
    }

    public int createColourProperty(String propName1, String fullPropName, String comment, boolean changable, boolean isSessionProp, int colour) {
        Property prop;
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 2) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".name=" + fullPropName);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 3) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment=" + comment);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 4) {
            System.out.println("config.createColourProperty(\"" + propName1 + "\", \"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".name\", " + "\"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment\", " + Boolean.toString(changable) + ", " + Boolean.toString(isSessionProp) + ", " + Integer.toHexString(colour) + ");");
        }
        if (this.props.containsKey(propName1)) {
            prop = this.props.get(propName1);
            prop.set("#" + Integer.toHexString(colour));
        } else {
            prop = this.config.get(this.currentCat, propName1, "#" + Integer.toHexString(colour));
            try {
                Integer.decode(prop.getString().trim());
            }
            catch (NumberFormatException e) {
                if (this.logger != null) {
                    this.logger.log(Level.WARN, "Could not parse following as colour code, setting as default: " + prop.getString());
                }
                e.printStackTrace();
                prop.set("#" + Integer.toHexString(colour));
            }
        }
        if (!comment.equalsIgnoreCase("")) {
            List cms = Splitter.on((String)"\\n").splitToList((CharSequence)StatCollector.func_74838_a((String)comment));
            String cm = "";
            for (int ll = 0; ll < cms.size(); ++ll) {
                cm = cm + cms.get(ll);
                if (ll == cms.size() - 1) continue;
                cm = cm + "\n";
            }
            prop.comment = cm;
        }
        this.props.put(propName1, prop);
        this.propName.put(prop, fullPropName);
        this.propNameToProp.put(fullPropName, propName1);
        this.propType.put(prop, EnumPropType.COLOUR);
        if (!changable && !this.propNeedsRestart.contains(prop)) {
            this.propNeedsRestart.add(prop);
        }
        if (isSessionProp && !this.sessionProps.contains(prop)) {
            this.sessionProps.add(prop);
        }
        this.addToCategory(this.currentCatName, prop);
        this.save();
        return Integer.decode(prop.getString().trim());
    }

    public String createStringProperty(String propName1, String fullPropName, String comment, boolean changable, boolean isSessionProp, String value) {
        Property prop;
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 2) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".name=" + fullPropName);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 3) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment=" + comment);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 4) {
            System.out.println("config.createStringProperty(\"" + propName1 + "\", \"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".name\", " + "\"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment\", " + Boolean.toString(changable) + ", " + Boolean.toString(isSessionProp) + ", \"" + value + "\");");
        }
        if (this.props.containsKey(propName1)) {
            prop = this.props.get(propName1);
            prop.set(value);
        } else {
            prop = this.config.get(this.currentCat, propName1, value);
        }
        if (!comment.equalsIgnoreCase("")) {
            List cms = Splitter.on((String)"\\n").splitToList((CharSequence)StatCollector.func_74838_a((String)comment));
            String cm = "";
            for (int ll = 0; ll < cms.size(); ++ll) {
                cm = cm + cms.get(ll);
                if (ll == cms.size() - 1) continue;
                cm = cm + "\n";
            }
            prop.comment = cm;
        }
        this.props.put(propName1, prop);
        this.propName.put(prop, fullPropName);
        this.propNameToProp.put(fullPropName, propName1);
        this.propType.put(prop, EnumPropType.STRING);
        if (!changable && !this.propNeedsRestart.contains(prop)) {
            this.propNeedsRestart.add(prop);
        }
        if (isSessionProp && !this.sessionProps.contains(prop)) {
            this.sessionProps.add(prop);
        }
        this.addToCategory(this.currentCatName, prop);
        this.save();
        return prop.getString();
    }

    public Property createKeybindProperty(String propName1, String fullPropName, String comment, int keyValue, boolean holdShift, boolean holdCtrl, boolean holdAlt, boolean canPulse, int pulseTime, boolean ignoreHold) {
        KeyBind bind;
        ArrayList<Object> categoryList;
        int ll;
        String cm;
        List cms;
        Property prop;
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 2) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".name=" + fullPropName);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 3) {
            System.out.println(this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment=" + comment);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 4) {
            System.out.println("config.createKeybindProperty(\"" + propName1 + "\", \"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".name\", " + "\"" + this.modId.toLowerCase() + ".config.prop." + propName1 + ".comment\", " + Integer.toString(keyValue) + ", " + Boolean.toString(holdShift) + ", " + Boolean.toString(holdCtrl) + ", " + Boolean.toString(holdAlt) + ", " + Boolean.toString(canPulse) + ", " + Integer.toString(pulseTime) + ", " + Boolean.toString(ignoreHold) + ");");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(keyValue);
        if (holdShift) {
            sb.append(":SHIFT");
        }
        if (holdCtrl) {
            sb.append(":CTRL");
        }
        if (holdAlt) {
            sb.append(":ALT");
        }
        if (this.props.containsKey(propName1)) {
            prop = this.props.get(propName1);
            prop.set(sb.toString());
        } else {
            cms = Splitter.on((String)"\\n").splitToList((CharSequence)StatCollector.func_74838_a((String)"ichun.config.keybind.comment"));
            cm = "";
            for (ll = 0; ll < cms.size(); ++ll) {
                cm = cm + cms.get(ll);
                if (ll == cms.size() - 1) continue;
                cm = cm + "\n";
            }
            configKeybind.addCustomCategoryComment("keybinds", cm);
            prop = configKeybind.get("keybinds." + this.modName, propName1, sb.toString());
            if (prop.getString() != sb.toString()) {
                String[] strings = prop.getString().split(":");
                if (strings.length == 0) {
                    iChunUtil.console("Invalid keybind for mod " + this.modName + ": " + fullPropName, true);
                    prop.set(sb.toString());
                } else {
                    try {
                        Integer.parseInt(strings[0].trim());
                    }
                    catch (NumberFormatException e) {
                        iChunUtil.console("Invalid key for mod " + this.modName + ": " + fullPropName, true);
                        prop.set(sb.toString());
                    }
                }
            }
        }
        if (!comment.equalsIgnoreCase("")) {
            cms = Splitter.on((String)"\\n").splitToList((CharSequence)StatCollector.func_74838_a((String)comment));
            cm = "";
            for (ll = 0; ll < cms.size(); ++ll) {
                cm = cm + cms.get(ll);
                if (ll == cms.size() - 1) continue;
                cm = cm + "\n";
            }
            prop.comment = cm;
        }
        this.props.put(propName1, prop);
        this.propName.put(prop, fullPropName);
        this.propNameToProp.put(fullPropName, propName1);
        this.propType.put(prop, EnumPropType.KEYBIND);
        if (this.categories.containsKey("Key Binds")) {
            categoryList = this.categories.get("Key Binds");
        } else {
            categoryList = new ArrayList();
            this.categories.put("Key Binds", categoryList);
        }
        if (!categoryList.contains(prop)) {
            categoryList.add(prop);
        }
        String keyString = prop.getString();
        String[] strings = keyString.split(":");
        try {
            bind = new KeyBind(Integer.parseInt(strings[0].trim()), keyString.contains("SHIFT"), keyString.contains("CTRL"), keyString.contains("ALT"), ignoreHold);
        }
        catch (Exception e) {
            iChunUtil.console("Error parsing key for mod " + this.modName + ": " + fullPropName, true);
            bind = new KeyBind(keyValue, holdShift, holdCtrl, holdAlt, ignoreHold);
        }
        bind.setPulse(canPulse, pulseTime);
        this.keyBindMap.put(propName1, iChunUtil.proxy.registerKeyBind(bind, null));
        this.save();
        return prop;
    }

    public void createIntArrayProperty(String propName1, String fullPropName, String comment, boolean changable, boolean isSessionProp, boolean nestedIntArray, String value, int[] minMax, int[] nestedMinMax) {
        Property prop;
        if (this.props.containsKey(propName1)) {
            prop = this.props.get(propName1);
            prop.set(value);
        } else {
            prop = this.config.get(this.currentCat, propName1, value);
        }
        if (!comment.equalsIgnoreCase("")) {
            List cms = Splitter.on((String)"\\n").splitToList((CharSequence)StatCollector.func_74838_a((String)comment));
            String cm = "";
            for (int ll = 0; ll < cms.size(); ++ll) {
                cm = cm + cms.get(ll);
                if (ll == cms.size() - 1) continue;
                cm = cm + "\n";
            }
            prop.comment = cm;
        }
        this.props.put(propName1, prop);
        this.propName.put(prop, fullPropName);
        this.propNameToProp.put(fullPropName, propName1);
        if (nestedIntArray) {
            this.propType.put(prop, EnumPropType.NESTED_INT_ARRAY);
        } else {
            this.propType.put(prop, EnumPropType.INT_ARRAY);
        }
        if (minMax == null || minMax.length != 2) {
            minMax = new int[]{minMax != null && minMax.length > 0 ? minMax[0] : Integer.MIN_VALUE, minMax != null && minMax.length > 1 ? minMax[1] : Integer.MAX_VALUE};
        }
        this.minmax.put(prop, minMax);
        if (nestedIntArray) {
            if (nestedMinMax == null || nestedMinMax.length != 2) {
                nestedMinMax = new int[]{nestedMinMax != null && nestedMinMax.length > 0 ? nestedMinMax[0] : Integer.MIN_VALUE, nestedMinMax != null && nestedMinMax.length > 1 ? nestedMinMax[1] : Integer.MAX_VALUE};
            }
            this.nestedMinmax.put(prop, nestedMinMax);
        }
        if (!changable && !this.propNeedsRestart.contains(prop)) {
            this.propNeedsRestart.add(prop);
        }
        if (isSessionProp && !this.sessionProps.contains(prop)) {
            this.sessionProps.add(prop);
        }
        this.addToCategory(this.currentCatName, prop);
        this.save();
    }

    public void setCurrentCategory(String cat, String catName, String comment) {
        this.currentCat = cat;
        this.currentCatName = StatCollector.func_74838_a((String)catName);
        List cms = Splitter.on((String)"\\n").splitToList((CharSequence)StatCollector.func_74838_a((String)comment));
        String cm = "";
        for (int ll = 0; ll < cms.size(); ++ll) {
            cm = cm + cms.get(ll);
            if (ll == cms.size() - 1) continue;
            cm = cm + "\n";
        }
        this.config.addCustomCategoryComment(this.currentCat, cm);
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 0) {
            System.out.println(this.modId.toLowerCase() + ".config.cat." + cat + ".name=" + catName);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 1) {
            System.out.println(this.modId.toLowerCase() + ".config.cat." + cat + ".comment=" + comment);
        }
        if (this.modId.equalsIgnoreCase(curMod) && printKey == 4) {
            System.out.println("config.setCurrentCategory(\"" + cat + "\", \"" + this.modId.toLowerCase() + ".config.cat." + cat + ".name\", \"" + this.modId.toLowerCase() + ".config.cat." + cat + ".comment\");");
        }
    }

    public void setup() {
        this.categoriesList.clear();
        this.setup = true;
        this.save();
        for (Map.Entry<String, ArrayList<Property>> e : this.categories.entrySet()) {
            if (e.getKey().equals("uncat")) continue;
            this.categoriesList.add(e.getKey());
        }
        Collections.sort(this.categoriesList);
    }

    public void save() {
        if (this.setup && this.config.hasChanged()) {
            this.config.save();
        }
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof Config) {
            Config cfg = (Config)arg0;
            return this.modName.compareTo(cfg.modName);
        }
        return 0;
    }

    public EnumPropType getPropType(Property prop) {
        EnumPropType type = this.propType.get(prop);
        if (this.propType == null) {
            iChunUtil.console("Property has no type: " + prop.getName(), true);
            return EnumPropType.UNDEFINED;
        }
        return type;
    }

    public static enum EnumPropType {
        UNDEFINED,
        STRING,
        INT,
        INT_BOOL,
        INT_ARRAY,
        NESTED_INT_ARRAY,
        KEYBIND,
        COLOUR;

    }
}

