/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.vec;

import cofh.repack.codechicken.lib.util.Copyable;
import cofh.repack.codechicken.lib.vec.IrreversibleTransformationException;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import org.lwjgl.opengl.GL11;

public class Matrix4
extends Transformation
implements Copyable<Matrix4> {
    private static DoubleBuffer glBuf = ByteBuffer.allocateDirect(128).order(ByteOrder.nativeOrder()).asDoubleBuffer();
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Matrix4() {
        this.m33 = 1.0;
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public Matrix4(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
    }

    public Matrix4(Matrix4 matrix4) {
        this.set(matrix4);
    }

    public Matrix4 setIdentity() {
        this.m33 = 1.0;
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        this.m23 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        return this;
    }

    public Matrix4 translate(Vector3 vector3) {
        this.m03 += this.m00 * vector3.x + this.m01 * vector3.y + this.m02 * vector3.z;
        this.m13 += this.m10 * vector3.x + this.m11 * vector3.y + this.m12 * vector3.z;
        this.m23 += this.m20 * vector3.x + this.m21 * vector3.y + this.m22 * vector3.z;
        this.m33 += this.m30 * vector3.x + this.m31 * vector3.y + this.m32 * vector3.z;
        return this;
    }

    public Matrix4 scale(Vector3 vector3) {
        this.m00 *= vector3.x;
        this.m10 *= vector3.x;
        this.m20 *= vector3.x;
        this.m30 *= vector3.x;
        this.m01 *= vector3.y;
        this.m11 *= vector3.y;
        this.m21 *= vector3.y;
        this.m31 *= vector3.y;
        this.m02 *= vector3.z;
        this.m12 *= vector3.z;
        this.m22 *= vector3.z;
        this.m32 *= vector3.z;
        return this;
    }

    public Matrix4 rotate(double d, Vector3 vector3) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 1.0 - d2;
        double d5 = vector3.x * vector3.y;
        double d6 = vector3.y * vector3.z;
        double d7 = vector3.x * vector3.z;
        double d8 = vector3.x * d3;
        double d9 = vector3.y * d3;
        double d10 = vector3.z * d3;
        double d11 = vector3.x * vector3.x * d4 + d2;
        double d12 = d5 * d4 + d10;
        double d13 = d7 * d4 - d9;
        double d14 = d5 * d4 - d10;
        double d15 = vector3.y * vector3.y * d4 + d2;
        double d16 = d6 * d4 + d8;
        double d17 = d7 * d4 + d9;
        double d18 = d6 * d4 - d8;
        double d19 = vector3.z * vector3.z * d4 + d2;
        double d20 = this.m00 * d11 + this.m01 * d12 + this.m02 * d13;
        double d21 = this.m10 * d11 + this.m11 * d12 + this.m12 * d13;
        double d22 = this.m20 * d11 + this.m21 * d12 + this.m22 * d13;
        double d23 = this.m30 * d11 + this.m31 * d12 + this.m32 * d13;
        double d24 = this.m00 * d14 + this.m01 * d15 + this.m02 * d16;
        double d25 = this.m10 * d14 + this.m11 * d15 + this.m12 * d16;
        double d26 = this.m20 * d14 + this.m21 * d15 + this.m22 * d16;
        double d27 = this.m30 * d14 + this.m31 * d15 + this.m32 * d16;
        this.m02 = this.m00 * d17 + this.m01 * d18 + this.m02 * d19;
        this.m12 = this.m10 * d17 + this.m11 * d18 + this.m12 * d19;
        this.m22 = this.m20 * d17 + this.m21 * d18 + this.m22 * d19;
        this.m32 = this.m30 * d17 + this.m31 * d18 + this.m32 * d19;
        this.m00 = d20;
        this.m10 = d21;
        this.m20 = d22;
        this.m30 = d23;
        this.m01 = d24;
        this.m11 = d25;
        this.m21 = d26;
        this.m31 = d27;
        return this;
    }

    public Matrix4 rotate(Rotation rotation) {
        rotation.apply(this);
        return this;
    }

    public Matrix4 leftMultiply(Matrix4 matrix4) {
        double d = this.m00 * matrix4.m00 + this.m10 * matrix4.m01 + this.m20 * matrix4.m02 + this.m30 * matrix4.m03;
        double d2 = this.m01 * matrix4.m00 + this.m11 * matrix4.m01 + this.m21 * matrix4.m02 + this.m31 * matrix4.m03;
        double d3 = this.m02 * matrix4.m00 + this.m12 * matrix4.m01 + this.m22 * matrix4.m02 + this.m32 * matrix4.m03;
        double d4 = this.m03 * matrix4.m00 + this.m13 * matrix4.m01 + this.m23 * matrix4.m02 + this.m33 * matrix4.m03;
        double d5 = this.m00 * matrix4.m10 + this.m10 * matrix4.m11 + this.m20 * matrix4.m12 + this.m30 * matrix4.m13;
        double d6 = this.m01 * matrix4.m10 + this.m11 * matrix4.m11 + this.m21 * matrix4.m12 + this.m31 * matrix4.m13;
        double d7 = this.m02 * matrix4.m10 + this.m12 * matrix4.m11 + this.m22 * matrix4.m12 + this.m32 * matrix4.m13;
        double d8 = this.m03 * matrix4.m10 + this.m13 * matrix4.m11 + this.m23 * matrix4.m12 + this.m33 * matrix4.m13;
        double d9 = this.m00 * matrix4.m20 + this.m10 * matrix4.m21 + this.m20 * matrix4.m22 + this.m30 * matrix4.m23;
        double d10 = this.m01 * matrix4.m20 + this.m11 * matrix4.m21 + this.m21 * matrix4.m22 + this.m31 * matrix4.m23;
        double d11 = this.m02 * matrix4.m20 + this.m12 * matrix4.m21 + this.m22 * matrix4.m22 + this.m32 * matrix4.m23;
        double d12 = this.m03 * matrix4.m20 + this.m13 * matrix4.m21 + this.m23 * matrix4.m22 + this.m33 * matrix4.m23;
        double d13 = this.m00 * matrix4.m30 + this.m10 * matrix4.m31 + this.m20 * matrix4.m32 + this.m30 * matrix4.m33;
        double d14 = this.m01 * matrix4.m30 + this.m11 * matrix4.m31 + this.m21 * matrix4.m32 + this.m31 * matrix4.m33;
        double d15 = this.m02 * matrix4.m30 + this.m12 * matrix4.m31 + this.m22 * matrix4.m32 + this.m32 * matrix4.m33;
        double d16 = this.m03 * matrix4.m30 + this.m13 * matrix4.m31 + this.m23 * matrix4.m32 + this.m33 * matrix4.m33;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
        return this;
    }

    public Matrix4 multiply(Matrix4 matrix4) {
        double d = this.m00 * matrix4.m00 + this.m01 * matrix4.m10 + this.m02 * matrix4.m20 + this.m03 * matrix4.m30;
        double d2 = this.m00 * matrix4.m01 + this.m01 * matrix4.m11 + this.m02 * matrix4.m21 + this.m03 * matrix4.m31;
        double d3 = this.m00 * matrix4.m02 + this.m01 * matrix4.m12 + this.m02 * matrix4.m22 + this.m03 * matrix4.m32;
        double d4 = this.m00 * matrix4.m03 + this.m01 * matrix4.m13 + this.m02 * matrix4.m23 + this.m03 * matrix4.m33;
        double d5 = this.m10 * matrix4.m00 + this.m11 * matrix4.m10 + this.m12 * matrix4.m20 + this.m13 * matrix4.m30;
        double d6 = this.m10 * matrix4.m01 + this.m11 * matrix4.m11 + this.m12 * matrix4.m21 + this.m13 * matrix4.m31;
        double d7 = this.m10 * matrix4.m02 + this.m11 * matrix4.m12 + this.m12 * matrix4.m22 + this.m13 * matrix4.m32;
        double d8 = this.m10 * matrix4.m03 + this.m11 * matrix4.m13 + this.m12 * matrix4.m23 + this.m13 * matrix4.m33;
        double d9 = this.m20 * matrix4.m00 + this.m21 * matrix4.m10 + this.m22 * matrix4.m20 + this.m23 * matrix4.m30;
        double d10 = this.m20 * matrix4.m01 + this.m21 * matrix4.m11 + this.m22 * matrix4.m21 + this.m23 * matrix4.m31;
        double d11 = this.m20 * matrix4.m02 + this.m21 * matrix4.m12 + this.m22 * matrix4.m22 + this.m23 * matrix4.m32;
        double d12 = this.m20 * matrix4.m03 + this.m21 * matrix4.m13 + this.m22 * matrix4.m23 + this.m23 * matrix4.m33;
        double d13 = this.m30 * matrix4.m00 + this.m31 * matrix4.m10 + this.m32 * matrix4.m20 + this.m33 * matrix4.m30;
        double d14 = this.m30 * matrix4.m01 + this.m31 * matrix4.m11 + this.m32 * matrix4.m21 + this.m33 * matrix4.m31;
        double d15 = this.m30 * matrix4.m02 + this.m31 * matrix4.m12 + this.m32 * matrix4.m22 + this.m33 * matrix4.m32;
        double d16 = this.m30 * matrix4.m03 + this.m31 * matrix4.m13 + this.m32 * matrix4.m23 + this.m33 * matrix4.m33;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
        return this;
    }

    public Matrix4 transpose() {
        double d = this.m00;
        double d2 = this.m01;
        double d3 = this.m02;
        double d4 = this.m03;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        double d8 = this.m13;
        double d9 = this.m20;
        double d10 = this.m21;
        double d11 = this.m22;
        double d12 = this.m23;
        double d13 = this.m30;
        double d14 = this.m31;
        double d15 = this.m32;
        double d16 = this.m33;
        this.m00 = d;
        this.m01 = d5;
        this.m02 = d9;
        this.m03 = d13;
        this.m10 = d2;
        this.m11 = d6;
        this.m12 = d10;
        this.m13 = d14;
        this.m20 = d3;
        this.m21 = d7;
        this.m22 = d11;
        this.m23 = d15;
        this.m30 = d4;
        this.m31 = d8;
        this.m32 = d12;
        this.m33 = d16;
        return this;
    }

    @Override
    public Matrix4 copy() {
        return new Matrix4(this);
    }

    public Matrix4 set(Matrix4 matrix4) {
        this.m00 = matrix4.m00;
        this.m01 = matrix4.m01;
        this.m02 = matrix4.m02;
        this.m03 = matrix4.m03;
        this.m10 = matrix4.m10;
        this.m11 = matrix4.m11;
        this.m12 = matrix4.m12;
        this.m13 = matrix4.m13;
        this.m20 = matrix4.m20;
        this.m21 = matrix4.m21;
        this.m22 = matrix4.m22;
        this.m23 = matrix4.m23;
        this.m30 = matrix4.m30;
        this.m31 = matrix4.m31;
        this.m32 = matrix4.m32;
        this.m33 = matrix4.m33;
        return this;
    }

    @Override
    public void apply(Matrix4 matrix4) {
        matrix4.multiply(this);
    }

    private void mult3x3(Vector3 vector3) {
        double d = this.m00 * vector3.x + this.m01 * vector3.y + this.m02 * vector3.z;
        double d2 = this.m10 * vector3.x + this.m11 * vector3.y + this.m12 * vector3.z;
        double d3 = this.m20 * vector3.x + this.m21 * vector3.y + this.m22 * vector3.z;
        vector3.x = d;
        vector3.y = d2;
        vector3.z = d3;
    }

    @Override
    public void apply(Vector3 vector3) {
        this.mult3x3(vector3);
        vector3.add(this.m03, this.m13, this.m23);
    }

    @Override
    public void applyN(Vector3 vector3) {
        this.mult3x3(vector3);
        vector3.normalize();
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "[" + new BigDecimal(this.m00, mathContext) + "," + new BigDecimal(this.m01, mathContext) + "," + new BigDecimal(this.m02, mathContext) + "," + new BigDecimal(this.m03, mathContext) + "]\n" + "[" + new BigDecimal(this.m10, mathContext) + "," + new BigDecimal(this.m11, mathContext) + "," + new BigDecimal(this.m12, mathContext) + "," + new BigDecimal(this.m13, mathContext) + "]\n" + "[" + new BigDecimal(this.m20, mathContext) + "," + new BigDecimal(this.m21, mathContext) + "," + new BigDecimal(this.m22, mathContext) + "," + new BigDecimal(this.m23, mathContext) + "]\n" + "[" + new BigDecimal(this.m30, mathContext) + "," + new BigDecimal(this.m31, mathContext) + "," + new BigDecimal(this.m32, mathContext) + "," + new BigDecimal(this.m33, mathContext) + "]";
    }

    public Matrix4 apply(Transformation transformation) {
        transformation.apply(this);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void glApply() {
        glBuf.put(this.m00).put(this.m10).put(this.m20).put(this.m30).put(this.m01).put(this.m11).put(this.m21).put(this.m31).put(this.m02).put(this.m12).put(this.m22).put(this.m32).put(this.m03).put(this.m13).put(this.m23).put(this.m33);
        glBuf.flip();
        GL11.glMultMatrix((DoubleBuffer)glBuf);
    }

    @Override
    public Transformation inverse() {
        throw new IrreversibleTransformationException(this);
    }
}

