/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.item.IEmpowerableItem;
import cofh.api.item.IInventoryContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.lib.util.OreDictionaryProxy;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class ItemHelper {
    public static final String BLOCK = "block";
    public static final String ORE = "ore";
    public static final String DUST = "dust";
    public static final String INGOT = "ingot";
    public static final String NUGGET = "nugget";
    public static final String LOG = "log";
    public static OreDictionaryProxy oreProxy = new OreDictionaryProxy();

    private ItemHelper() {
    }

    public static ItemStack cloneStack(Item item, int n) {
        if (item == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(item, n);
        return itemStack;
    }

    public static ItemStack cloneStack(Block block, int n) {
        if (block == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(block, n);
        return itemStack;
    }

    public static ItemStack cloneStack(ItemStack itemStack, int n) {
        if (itemStack == null) {
            return null;
        }
        ItemStack itemStack2 = itemStack.func_77946_l();
        itemStack2.field_77994_a = n;
        return itemStack2;
    }

    public static ItemStack cloneStack(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemStack itemStack2 = itemStack.func_77946_l();
        return itemStack2;
    }

    public static ItemStack copyTag(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack2 != null && itemStack2.field_77990_d != null) {
            itemStack.field_77990_d = (NBTTagCompound)itemStack2.field_77990_d.func_74737_b();
        }
        return itemStack;
    }

    public static NBTTagCompound setItemStackTagName(NBTTagCompound nBTTagCompound, String string) {
        if (string == "") {
            return null;
        }
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        if (!nBTTagCompound.func_74764_b("display")) {
            nBTTagCompound.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        nBTTagCompound.func_74775_l("display").func_74778_a("Name", string);
        return nBTTagCompound;
    }

    public static ItemStack readItemStackFromNBT(NBTTagCompound nBTTagCompound) {
        ItemStack itemStack = new ItemStack(Item.func_150899_d((int)nBTTagCompound.func_74765_d("id")));
        itemStack.field_77994_a = nBTTagCompound.func_74762_e("Count");
        itemStack.func_77964_b(Math.max(0, nBTTagCompound.func_74765_d("Damage")));
        if (nBTTagCompound.func_150297_b("tag", 10)) {
            itemStack.field_77990_d = nBTTagCompound.func_74775_l("tag");
        }
        return itemStack;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack itemStack, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74777_a("id", (short)Item.func_150891_b((Item)itemStack.func_77973_b()));
        nBTTagCompound.func_74768_a("Count", itemStack.field_77994_a);
        nBTTagCompound.func_74777_a("Damage", (short)ItemHelper.getItemDamage(itemStack));
        if (itemStack.field_77990_d != null) {
            nBTTagCompound.func_74782_a("tag", (NBTBase)itemStack.field_77990_d);
        }
        return nBTTagCompound;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack itemStack, int n, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74777_a("id", (short)Item.func_150891_b((Item)itemStack.func_77973_b()));
        nBTTagCompound.func_74768_a("Count", n);
        nBTTagCompound.func_74777_a("Damage", (short)ItemHelper.getItemDamage(itemStack));
        if (itemStack.field_77990_d != null) {
            nBTTagCompound.func_74782_a("tag", (NBTBase)itemStack.field_77990_d);
        }
        return nBTTagCompound;
    }

    public static String getNameFromItemStack(ItemStack itemStack) {
        if (itemStack == null || itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("display")) {
            return "";
        }
        return itemStack.field_77990_d.func_74775_l("display").func_74779_i("Name");
    }

    public static ItemStack consumeItem(ItemStack itemStack) {
        boolean bl;
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        boolean bl2 = bl = itemStack.field_77994_a > 1;
        if (bl) {
            --itemStack.field_77994_a;
        }
        if (item.hasContainerItem(itemStack)) {
            ItemStack itemStack2 = item.getContainerItem(itemStack);
            if (itemStack2 == null) {
                return null;
            }
            if (itemStack2.func_77984_f() && itemStack2.func_77960_j() > itemStack2.func_77958_k()) {
                itemStack2 = null;
            }
            return itemStack2;
        }
        return bl ? itemStack : null;
    }

    public static ItemStack consumeItem(ItemStack itemStack, EntityPlayer entityPlayer) {
        boolean bl;
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        boolean bl2 = bl = itemStack.field_77994_a > 1;
        if (bl) {
            --itemStack.field_77994_a;
        }
        if (item.hasContainerItem(itemStack)) {
            ItemStack itemStack2 = item.getContainerItem(itemStack);
            if (itemStack2 == null || itemStack2.func_77984_f() && itemStack2.func_77960_j() > itemStack2.func_77958_k()) {
                itemStack2 = null;
            }
            if (itemStack.field_77994_a < 1) {
                return itemStack2;
            }
            if (itemStack2 != null && !entityPlayer.field_71071_by.func_70441_a(itemStack2)) {
                entityPlayer.func_146097_a(itemStack2, false, true);
            }
        }
        return bl ? itemStack : null;
    }

    public static boolean disposePlayerItem(ItemStack itemStack, ItemStack itemStack2, EntityPlayer entityPlayer, boolean bl) {
        return ItemHelper.disposePlayerItem(itemStack, itemStack2, entityPlayer, bl, true);
    }

    public static boolean disposePlayerItem(ItemStack itemStack, ItemStack itemStack2, EntityPlayer entityPlayer, boolean bl, boolean bl2) {
        if (entityPlayer == null || entityPlayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (bl2 && itemStack.field_77994_a <= 1) {
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            entityPlayer.field_71071_by.func_70441_a(itemStack2);
            return true;
        }
        if (bl) {
            --itemStack.field_77994_a;
            if (itemStack2 != null && !entityPlayer.field_71071_by.func_70441_a(itemStack2)) {
                entityPlayer.func_146097_a(itemStack2, false, true);
            }
            return true;
        }
        return false;
    }

    public static int getItemDamage(ItemStack itemStack) {
        return Items.field_151045_i.getDamage(itemStack);
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting inventoryCrafting, World world) {
        ItemStack[] itemStackArray = new ItemStack[2];
        for (int i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
            if (inventoryCrafting.func_70301_a(i) == null) continue;
            if (itemStackArray[0] == null) {
                itemStackArray[0] = inventoryCrafting.func_70301_a(i);
                continue;
            }
            itemStackArray[1] = inventoryCrafting.func_70301_a(i);
            break;
        }
        if (itemStackArray[0] == null || itemStackArray[0].func_77973_b() == null) {
            return null;
        }
        if (itemStackArray[1] != null && itemStackArray[0].func_77973_b() == itemStackArray[1].func_77973_b() && itemStackArray[0].field_77994_a == 1 && itemStackArray[1].field_77994_a == 1 && itemStackArray[0].func_77973_b().isRepairable()) {
            Item item = itemStackArray[0].func_77973_b();
            int n = item.func_77612_l() - itemStackArray[0].func_77952_i();
            int n2 = item.func_77612_l() - itemStackArray[1].func_77952_i();
            int n3 = n + n2 + item.func_77612_l() * 5 / 100;
            int n4 = Math.max(0, item.func_77612_l() - n3);
            return new ItemStack(itemStackArray[0].func_77973_b(), 1, n4);
        }
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe iRecipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!iRecipe.func_77569_a(inventoryCrafting, world)) continue;
            return iRecipe.func_77572_b(inventoryCrafting);
        }
        return null;
    }

    public static ItemStack getOre(String string) {
        return oreProxy.getOre(string);
    }

    public static String getOreName(ItemStack itemStack) {
        return oreProxy.getOreName(itemStack);
    }

    public static boolean isOreIDEqual(ItemStack itemStack, int n) {
        return oreProxy.isOreIDEqual(itemStack, n);
    }

    public static boolean isOreNameEqual(ItemStack itemStack, String string) {
        return oreProxy.isOreNameEqual(itemStack, string);
    }

    public static boolean oreNameExists(String string) {
        return oreProxy.oreNameExists(string);
    }

    public static boolean hasOreName(ItemStack itemStack) {
        return !ItemHelper.getOreName(itemStack).equals("Unknown");
    }

    public static boolean isBlock(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(BLOCK);
    }

    public static boolean isOre(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(ORE);
    }

    public static boolean isDust(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(DUST);
    }

    public static boolean isIngot(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(INGOT);
    }

    public static boolean isNugget(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(NUGGET);
    }

    public static boolean isLog(ItemStack itemStack) {
        return ItemHelper.getOreName(itemStack).startsWith(LOG);
    }

    public static final ItemStack stack(Item item) {
        return new ItemStack(item);
    }

    public static final ItemStack stack(Item item, int n) {
        return new ItemStack(item, n);
    }

    public static final ItemStack stack(Item item, int n, int n2) {
        return new ItemStack(item, n, n2);
    }

    public static final ItemStack stack(Block block) {
        return new ItemStack(block);
    }

    public static final ItemStack stack(Block block, int n) {
        return new ItemStack(block, n);
    }

    public static final ItemStack stack(Block block, int n, int n2) {
        return new ItemStack(block, n, n2);
    }

    public static final ItemStack stack2(Item item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }

    public static final ItemStack stack2(Item item, int n) {
        return new ItemStack(item, n, Short.MAX_VALUE);
    }

    public static final ItemStack stack2(Block block) {
        return new ItemStack(block, 1, Short.MAX_VALUE);
    }

    public static final ItemStack stack2(Block block, int n) {
        return new ItemStack(block, n, Short.MAX_VALUE);
    }

    public static final IRecipe ShapedRecipe(Block block, Object ... objectArray) {
        return new ShapedOreRecipe(block, objectArray);
    }

    public static final IRecipe ShapedRecipe(Item item, Object ... objectArray) {
        return new ShapedOreRecipe(item, objectArray);
    }

    public static final IRecipe ShapedRecipe(ItemStack itemStack, Object ... objectArray) {
        return new ShapedOreRecipe(itemStack, objectArray);
    }

    public static final IRecipe ShapedRecipe(Block block, int n, Object ... objectArray) {
        return new ShapedOreRecipe(ItemHelper.stack(block, n), objectArray);
    }

    public static final IRecipe ShapedRecipe(Item item, int n, Object ... objectArray) {
        return new ShapedOreRecipe(ItemHelper.stack(item, n), objectArray);
    }

    public static final IRecipe ShapedRecipe(ItemStack itemStack, int n, Object ... objectArray) {
        return new ShapedOreRecipe(ItemHelper.cloneStack(itemStack, n), objectArray);
    }

    public static final IRecipe ShapelessRecipe(Block block, Object ... objectArray) {
        return new ShapelessOreRecipe(block, objectArray);
    }

    public static final IRecipe ShapelessRecipe(Item item, Object ... objectArray) {
        return new ShapelessOreRecipe(item, objectArray);
    }

    public static final IRecipe ShapelessRecipe(ItemStack itemStack, Object ... objectArray) {
        return new ShapelessOreRecipe(itemStack, objectArray);
    }

    public static final IRecipe ShapelessRecipe(Block block, int n, Object ... objectArray) {
        return new ShapelessOreRecipe(ItemHelper.stack(block, n), objectArray);
    }

    public static final IRecipe ShapelessRecipe(Item item, int n, Object ... objectArray) {
        return new ShapelessOreRecipe(ItemHelper.stack(item, n), objectArray);
    }

    public static final IRecipe ShapelessRecipe(ItemStack itemStack, int n, Object ... objectArray) {
        return new ShapelessOreRecipe(ItemHelper.cloneStack(itemStack, n), objectArray);
    }

    public static boolean addGearRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), string, Character.valueOf('I'), "ingotIron"}));
        return true;
    }

    public static boolean addGearRecipe(ItemStack itemStack, String string, String string2) {
        if (itemStack == null || !ItemHelper.oreNameExists(string) || !ItemHelper.oreNameExists(string2)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), string, Character.valueOf('I'), string2}));
        return true;
    }

    public static boolean addGearRecipe(ItemStack itemStack, String string, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), string, Character.valueOf('I'), itemStack2}));
        return true;
    }

    public static boolean addGearRecipe(ItemStack itemStack, ItemStack itemStack2, String string) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), itemStack2, Character.valueOf('I'), string}));
        return true;
    }

    public static boolean addGearRecipe(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        if (itemStack == null | itemStack2 == null | itemStack3 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{" X ", "XIX", " X ", Character.valueOf('X'), ItemHelper.cloneStack(itemStack2, 1), Character.valueOf('I'), ItemHelper.cloneStack(itemStack3, 1)});
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack itemStack, String string, String string2) {
        if (itemStack == null || !ItemHelper.oreNameExists(string) || !ItemHelper.oreNameExists(string2)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"X X", " I ", "X X", Character.valueOf('X'), string, Character.valueOf('I'), string2}));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack itemStack, String string, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"X X", " I ", "X X", Character.valueOf('X'), string, Character.valueOf('I'), itemStack2}));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack itemStack, ItemStack itemStack2, String string) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"X X", " I ", "X X", Character.valueOf('X'), itemStack2, Character.valueOf('I'), string}));
        return true;
    }

    public static boolean addRotatedGearRecipe(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        if (itemStack == null | itemStack2 == null | itemStack3 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{"X X", " I ", "X X", Character.valueOf('X'), ItemHelper.cloneStack(itemStack2, 1), Character.valueOf('I'), ItemHelper.cloneStack(itemStack3, 1)});
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        if (itemStack == null | itemStack2 == null | itemStack3 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), ItemHelper.cloneStack(itemStack3, 1), Character.valueOf('I'), ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack itemStack, String string, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), itemStack2, Character.valueOf('I'), string}));
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack itemStack, ItemStack itemStack2, String string) {
        if (itemStack == null | itemStack2 == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), string, Character.valueOf('I'), itemStack2}));
        return true;
    }

    public static boolean addSurroundRecipe(ItemStack itemStack, String string, String string2) {
        if (itemStack == null || !ItemHelper.oreNameExists(string) || !ItemHelper.oreNameExists(string2)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"XXX", "XIX", "XXX", Character.valueOf('X'), string2, Character.valueOf('I'), string}));
        return true;
    }

    public static boolean addFenceRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addFenceRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"XXX", "XXX", Character.valueOf('X'), string}));
        return true;
    }

    public static boolean addReverseStorageRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(ItemHelper.cloneStack(itemStack, 9), new Object[]{string}));
        return true;
    }

    public static boolean addReverseStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(itemStack, 9), (Object[])new Object[]{ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addSmallReverseStorageRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(ItemHelper.cloneStack(itemStack, 4), new Object[]{string}));
        return true;
    }

    public static boolean addSmallReverseStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(itemStack, 4), (Object[])new Object[]{ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addStorageRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemStack, new Object[]{string, string, string, string, string, string, string, string, string}));
        return true;
    }

    public static boolean addStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        itemStack2 = ItemHelper.cloneStack(itemStack2, 1);
        GameRegistry.addShapelessRecipe((ItemStack)itemStack, (Object[])new Object[]{itemStack2, itemStack2, itemStack2, itemStack2, itemStack2, itemStack2, itemStack2, itemStack2, itemStack2});
        return true;
    }

    public static boolean addSmallStorageRecipe(ItemStack itemStack, String string) {
        if (itemStack == null || !ItemHelper.oreNameExists(string)) {
            return false;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, new Object[]{"XX", "XX", Character.valueOf('X'), string}));
        return true;
    }

    public static boolean addSmallStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addRecipe((ItemStack)ItemHelper.cloneStack(itemStack), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), ItemHelper.cloneStack(itemStack2, 1)});
        return true;
    }

    public static boolean addTwoWayStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.addStorageRecipe(itemStack, itemStack2) && ItemHelper.addReverseStorageRecipe(itemStack2, itemStack);
    }

    public static boolean addTwoWayStorageRecipe(ItemStack itemStack, String string, ItemStack itemStack2, String string2) {
        return ItemHelper.addStorageRecipe(itemStack, string2) && ItemHelper.addReverseStorageRecipe(itemStack2, string);
    }

    public static boolean addSmallTwoWayStorageRecipe(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.addSmallStorageRecipe(itemStack, itemStack2) && ItemHelper.addSmallReverseStorageRecipe(itemStack2, itemStack);
    }

    public static boolean addSmallTwoWayStorageRecipe(ItemStack itemStack, String string, ItemStack itemStack2, String string2) {
        return ItemHelper.addSmallStorageRecipe(itemStack, string2) && ItemHelper.addSmallReverseStorageRecipe(itemStack2, string);
    }

    public static boolean addSmelting(ItemStack itemStack, Item item) {
        if (itemStack == null | item == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(item, 1), ItemHelper.cloneStack(itemStack), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, Block block) {
        if (itemStack == null | block == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(block, 1), ItemHelper.cloneStack(itemStack), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(itemStack2, 1), ItemHelper.cloneStack(itemStack), 0.0f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, Item item, float f) {
        if (itemStack == null | item == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(item, 1), ItemHelper.cloneStack(itemStack), f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, Block block, float f) {
        if (itemStack == null | block == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(block, 1), ItemHelper.cloneStack(itemStack), f);
        return true;
    }

    public static boolean addSmelting(ItemStack itemStack, ItemStack itemStack2, float f) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(itemStack2, 1), ItemHelper.cloneStack(itemStack), f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack itemStack, Item item) {
        if (itemStack == null | item == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(item, 1), ItemHelper.cloneStack(itemStack), 0.1f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack itemStack, Block block) {
        if (itemStack == null | block == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(block, 1), ItemHelper.cloneStack(itemStack), 0.1f);
        return true;
    }

    public static boolean addWeakSmelting(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(ItemHelper.cloneStack(itemStack2, 1), ItemHelper.cloneStack(itemStack), 0.1f);
        return true;
    }

    public static boolean addTwoWayConversionRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(itemStack, 1), (Object[])new Object[]{ItemHelper.cloneStack(itemStack2, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)ItemHelper.cloneStack(itemStack2, 1), (Object[])new Object[]{ItemHelper.cloneStack(itemStack, 1)});
        return true;
    }

    public static void registerWithHandlers(String string, ItemStack itemStack) {
        OreDictionary.registerOre((String)string, (ItemStack)itemStack);
        GameRegistry.registerCustomItemStack((String)string, (ItemStack)itemStack);
        FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)itemStack);
    }

    public static void addRecipe(IRecipe iRecipe) {
        GameRegistry.addRecipe((IRecipe)iRecipe);
    }

    public static void addRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((ItemStack)itemStack, (Object[])objectArray);
    }

    public static void addShapedRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((ItemStack)itemStack, (Object[])objectArray);
    }

    public static void addShapedRecipe(Item item, Object ... objectArray) {
        ItemHelper.addRecipe(new ItemStack(item), objectArray);
    }

    public static void addShapedRecipe(Block block, Object ... objectArray) {
        ItemHelper.addRecipe(new ItemStack(block), objectArray);
    }

    public static void addShapelessRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addShapelessRecipe((ItemStack)itemStack, (Object[])objectArray);
    }

    public static void addShapelessRecipe(Item item, Object ... objectArray) {
        ItemHelper.addShapelessRecipe(new ItemStack(item), objectArray);
    }

    public static void addShapelessRecipe(Block block, Object ... objectArray) {
        ItemHelper.addShapelessRecipe(new ItemStack(block), objectArray);
    }

    public static void addShapedOreRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(itemStack, objectArray));
    }

    public static void addShapedOreRecipe(Item item, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(item, objectArray));
    }

    public static void addShapedOreRecipe(Block block, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe(block, objectArray));
    }

    public static void addShapelessOreRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(itemStack, objectArray));
    }

    public static void addShapelessOreRecipe(Item item, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(item, objectArray));
    }

    public static void addShapelessOreRecipe(Block block, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe(block, objectArray));
    }

    public static boolean isPlayerHoldingEmpowerableItem(EntityPlayer entityPlayer) {
        Item item = entityPlayer.func_71045_bC() != null ? entityPlayer.func_71045_bC().func_77973_b() : null;
        return item instanceof IEmpowerableItem;
    }

    public static boolean isPlayerHoldingEmpoweredItem(EntityPlayer entityPlayer) {
        Item item = entityPlayer.func_71045_bC() != null ? entityPlayer.func_71045_bC().func_77973_b() : null;
        return item instanceof IEmpowerableItem && ((IEmpowerableItem)item).isEmpowered(entityPlayer.func_71045_bC());
    }

    public static boolean toggleHeldEmpowerableItemState(EntityPlayer entityPlayer) {
        ItemStack itemStack;
        IEmpowerableItem iEmpowerableItem;
        return iEmpowerableItem.setEmpoweredState(itemStack, !(iEmpowerableItem = (IEmpowerableItem)(itemStack = entityPlayer.func_71045_bC()).func_77973_b()).isEmpowered(itemStack));
    }

    public static boolean isPlayerHoldingMultiModeItem(EntityPlayer entityPlayer) {
        Item item = entityPlayer.func_71045_bC() != null ? entityPlayer.func_71045_bC().func_77973_b() : null;
        return item instanceof IMultiModeItem;
    }

    public static boolean incrHeldMultiModeItemState(EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        IMultiModeItem iMultiModeItem = (IMultiModeItem)itemStack.func_77973_b();
        return iMultiModeItem.incrMode(itemStack);
    }

    public static boolean decrHeldMultiModeItemState(EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        IMultiModeItem iMultiModeItem = (IMultiModeItem)itemStack.func_77973_b();
        return iMultiModeItem.incrMode(itemStack);
    }

    public static boolean setHeldMultiModeItemState(EntityPlayer entityPlayer, int n) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        IMultiModeItem iMultiModeItem = (IMultiModeItem)itemStack.func_77973_b();
        return iMultiModeItem.setMode(itemStack, n);
    }

    public static final boolean isPlayerHoldingFluidContainer(EntityPlayer entityPlayer) {
        return FluidContainerRegistry.isContainer((ItemStack)entityPlayer.func_71045_bC());
    }

    public static final boolean isPlayerHoldingFluidContainerItem(EntityPlayer entityPlayer) {
        return FluidHelper.isPlayerHoldingFluidContainerItem(entityPlayer);
    }

    public static final boolean isPlayerHoldingEnergyContainerItem(EntityPlayer entityPlayer) {
        return EnergyHelper.isPlayerHoldingEnergyContainerItem(entityPlayer);
    }

    public static final boolean isPlayerHoldingNothing(EntityPlayer entityPlayer) {
        return entityPlayer.func_71045_bC() == null;
    }

    public static Item getItemFromStack(ItemStack itemStack) {
        return itemStack == null ? null : itemStack.func_77973_b();
    }

    public static boolean areItemsEqual(Item item, Item item2) {
        if (item == null | item2 == null) {
            return false;
        }
        return item == item2 || item.equals(item2);
    }

    public static final boolean isPlayerHoldingItem(Class<?> clazz, EntityPlayer entityPlayer) {
        return clazz.isInstance(ItemHelper.getItemFromStack(entityPlayer.func_71045_bC()));
    }

    public static final boolean isPlayerHoldingItem(Item item, EntityPlayer entityPlayer) {
        return ItemHelper.areItemsEqual(item, ItemHelper.getItemFromStack(entityPlayer.func_71045_bC()));
    }

    public static final boolean isPlayerHoldingItemStack(ItemStack itemStack, EntityPlayer entityPlayer) {
        return ItemHelper.itemsEqualWithMetadata(itemStack, entityPlayer.func_71045_bC());
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        return ItemHelper.areItemsEqual(itemStack.func_77973_b(), itemStack2.func_77973_b());
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        return ItemHelper.itemsEqualWithoutMetadata(itemStack, itemStack2) && (!bl || ItemHelper.doNBTsMatch(itemStack.field_77990_d, itemStack2.field_77990_d));
    }

    public static boolean itemsEqualWithMetadata(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.itemsEqualWithoutMetadata(itemStack, itemStack2) && (!itemStack.func_77981_g() || itemStack.func_77960_j() == itemStack2.func_77960_j());
    }

    public static boolean itemsEqualWithMetadata(ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        return ItemHelper.itemsEqualWithMetadata(itemStack, itemStack2) && (!bl || ItemHelper.doNBTsMatch(itemStack.field_77990_d, itemStack2.field_77990_d));
    }

    public static boolean itemsIdentical(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.itemsEqualWithoutMetadata(itemStack, itemStack2) && itemStack.func_77960_j() == itemStack2.func_77960_j() && ItemHelper.doNBTsMatch(itemStack.field_77990_d, itemStack2.field_77990_d);
    }

    public static boolean doNBTsMatch(NBTTagCompound nBTTagCompound, NBTTagCompound nBTTagCompound2) {
        if (nBTTagCompound == null & nBTTagCompound2 == null) {
            return true;
        }
        if (nBTTagCompound != null & nBTTagCompound2 != null) {
            return nBTTagCompound.equals((Object)nBTTagCompound2);
        }
        return false;
    }

    public static boolean itemsEqualForCrafting(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.itemsEqualWithoutMetadata(itemStack, itemStack2) && (!itemStack.func_77981_g() || itemStack.func_77960_j() == Short.MAX_VALUE || itemStack2.func_77960_j() == Short.MAX_VALUE || itemStack2.func_77960_j() == itemStack.func_77960_j());
    }

    public static boolean craftingEquivalent(ItemStack itemStack, ItemStack itemStack2, String string, ItemStack itemStack3) {
        if (ItemHelper.itemsEqualForCrafting(itemStack, itemStack2)) {
            return true;
        }
        if (itemStack3 != null && ItemHelper.isBlacklist(itemStack3)) {
            return false;
        }
        if (string == null || string.equals("Unknown")) {
            return false;
        }
        return ItemHelper.getOreName(itemStack).equalsIgnoreCase(string);
    }

    public static boolean doOreIDsMatch(ItemStack itemStack, ItemStack itemStack2) {
        int n = oreProxy.getOreID(itemStack);
        return n >= 0 && n == oreProxy.getOreID(itemStack2);
    }

    public static boolean isBlacklist(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return Item.func_150898_a((Block)Blocks.field_150487_bG) == item || Item.func_150898_a((Block)Blocks.field_150481_bH) == item || Item.func_150898_a((Block)Blocks.field_150476_ad) == item || Item.func_150898_a((Block)Blocks.field_150485_bF) == item || Item.func_150898_a((Block)Blocks.field_150344_f) == item || Item.func_150898_a((Block)Blocks.field_150376_bx) == item;
    }

    public static String getItemNBTString(ItemStack itemStack, String string, String string2) {
        return itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b(string) ? itemStack.field_77990_d.func_74779_i(string) : string2;
    }

    public static void addInventoryInformation(ItemStack itemStack, List<String> list) {
        ItemHelper.addInventoryInformation(itemStack, list, 0, Integer.MAX_VALUE);
    }

    public static void addInventoryInformation(ItemStack itemStack, List<String> list, int n, int n2) {
        int n3;
        if (itemStack.field_77990_d == null) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        if (itemStack.func_77973_b() instanceof IInventoryContainerItem && itemStack.field_77990_d.func_74764_b("Accessible")) {
            ItemHelper.addAccessibleInventoryInformation(itemStack, list, n, n2);
            return;
        }
        if (!itemStack.field_77990_d.func_74764_b("Inventory") || itemStack.field_77990_d.func_150295_c("Inventory", (int)itemStack.field_77990_d.func_74732_a()).func_74745_c() <= 0) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        NBTTagList nBTTagList = itemStack.field_77990_d.func_150295_c("Inventory", (int)itemStack.field_77990_d.func_74732_a());
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        boolean[] blArray = new boolean[nBTTagList.func_74745_c()];
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound = nBTTagList.func_150305_b(i);
            n3 = nBTTagCompound.func_74762_e("Slot");
            if (blArray[i] || n3 < n || n3 > n2) continue;
            blArray[i] = true;
            ItemStack itemStack2 = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound);
            if (itemStack2 == null) continue;
            arrayList.add(itemStack2);
            for (int j = 0; j < nBTTagList.func_74745_c(); ++j) {
                ItemStack itemStack3;
                NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(j);
                int n4 = nBTTagCompound.func_74762_e("Slot");
                if (blArray[j] || n4 < n || n4 > n2 || (itemStack3 = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2)) == null || !ItemHelper.itemsEqualWithMetadata(itemStack2, itemStack3)) continue;
                itemStack2.field_77994_a += itemStack3.field_77994_a;
                blArray[j] = true;
            }
        }
        if (arrayList.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        }
        for (ItemStack itemStack2 : arrayList) {
            n3 = itemStack2.func_77976_d();
            if (!StringHelper.displayStackCount || itemStack2.field_77994_a < n3 || n3 == 1) {
                list.add("    \u00a7a" + itemStack2.field_77994_a + " " + StringHelper.getItemName(itemStack2));
                continue;
            }
            if (itemStack2.field_77994_a % n3 != 0) {
                list.add("    \u00a7a" + n3 + "x" + itemStack2.field_77994_a / n3 + "+" + itemStack2.field_77994_a % n3 + " " + StringHelper.getItemName(itemStack2));
                continue;
            }
            list.add("    \u00a7a" + n3 + "x" + itemStack2.field_77994_a / n3 + " " + StringHelper.getItemName(itemStack2));
        }
    }

    public static void addAccessibleInventoryInformation(ItemStack itemStack, List<String> list, int n, int n2) {
        int n3 = ((IInventoryContainerItem)itemStack.func_77973_b()).getSizeInventory(itemStack);
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        boolean[] blArray = new boolean[n3];
        for (int i = n; i < Math.min(n3, n2); ++i) {
            if (blArray[i] || !itemStack.field_77990_d.func_74764_b("Slot" + i)) continue;
            ItemStack itemStack2 = ItemStack.func_77949_a((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Slot" + i));
            blArray[i] = true;
            if (itemStack2 == null) continue;
            arrayList.add(itemStack2);
            for (int j = n; j < Math.min(n3, n2); ++j) {
                ItemStack itemStack3;
                if (blArray[j] || !itemStack.field_77990_d.func_74764_b("Slot" + j) || (itemStack3 = ItemStack.func_77949_a((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Slot" + j))) == null || !ItemHelper.itemsEqualWithMetadata(itemStack2, itemStack3)) continue;
                itemStack2.field_77994_a += itemStack3.field_77994_a;
                blArray[j] = true;
            }
        }
        if (arrayList.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        } else {
            list.add(StringHelper.localize("info.cofh.empty"));
        }
        for (ItemStack itemStack4 : arrayList) {
            int n4 = itemStack4.func_77976_d();
            if (!StringHelper.displayStackCount || itemStack4.field_77994_a < n4 || n4 == 1) {
                list.add("    \u00a7a" + itemStack4.field_77994_a + " " + StringHelper.getItemName(itemStack4));
                continue;
            }
            if (itemStack4.field_77994_a % n4 != 0) {
                list.add("    \u00a7a" + n4 + "x" + itemStack4.field_77994_a / n4 + "+" + itemStack4.field_77994_a % n4 + " " + StringHelper.getItemName(itemStack4));
                continue;
            }
            list.add("    \u00a7a" + n4 + "x" + itemStack4.field_77994_a / n4 + " " + StringHelper.getItemName(itemStack4));
        }
    }
}

