/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class ElementTextField
extends ElementBase {
    public int borderColor = new GuiColor(55, 55, 55).getColor();
    public int backgroundColor = new GuiColor(139, 139, 139).getColor();
    public int disabledColor = new GuiColor(198, 198, 198).getColor();
    public int selectedLineColor = new GuiColor(160, 160, 224).getColor();
    public int textColor = new GuiColor(224, 224, 224).getColor();
    public int selectedTextColor = new GuiColor(224, 224, 224).getColor();
    public int defaultCaretColor = new GuiColor(255, 255, 255).getColor();
    @Deprecated
    protected int renderStart;
    protected char[] text;
    protected int textLength;
    protected int selectionStart;
    protected int selectionEnd;
    protected int renderStartX;
    protected int renderStartY;
    protected int caret;
    protected int prevCaret;
    protected int caretX;
    private boolean isFocused;
    private boolean canFocusChange = true;
    private boolean selecting;
    private boolean pressed;
    private byte caretCounter;
    protected boolean caretInsert;
    protected boolean smartCaret = true;
    protected boolean smartCaretCase = true;
    protected boolean multiline = false;
    protected boolean enableStencil = true;

    public ElementTextField(GuiBase guiBase, int n, int n2, int n3, int n4) {
        this(guiBase, n, n2, n3, n4, 32);
    }

    public ElementTextField(GuiBase guiBase, int n, int n2, int n3, int n4, short s) {
        super(guiBase, n, n2, n3, n4);
        this.setMaxLength(s);
    }

    public ElementTextField setTextColor(Number number, Number number2) {
        if (number != null) {
            this.textColor = number.intValue();
        }
        if (number2 != null) {
            this.selectedTextColor = number2.intValue();
        }
        return this;
    }

    public ElementTextField setSelectionColor(Number number, Number number2) {
        if (number != null) {
            this.selectedLineColor = number.intValue();
        }
        if (number2 != null) {
            this.defaultCaretColor = number2.intValue();
        }
        return this;
    }

    public ElementTextField setBackgroundColor(Number number, Number number2, Number number3) {
        if (number != null) {
            this.backgroundColor = number.intValue();
        }
        if (number2 != null) {
            this.disabledColor = number2.intValue();
        }
        if (number3 != null) {
            this.borderColor = number3.intValue();
        }
        return this;
    }

    public ElementTextField setMultiline(boolean bl) {
        this.multiline = bl;
        return this;
    }

    public ElementTextField setFocusable(boolean bl) {
        this.canFocusChange = bl;
        return this;
    }

    public ElementTextField setFocused(boolean bl) {
        if (this.isFocusable()) {
            this.isFocused = bl;
            this.caretCounter = 0;
        }
        return this;
    }

    public ElementTextField setText(String string) {
        this.selectionStart = 0;
        this.selectionEnd = this.textLength;
        this.writeText(string);
        return this;
    }

    public ElementTextField setMaxLength(short s) {
        char[] cArray = this.text;
        this.text = new char[s];
        this.textLength = Math.min(s, this.textLength);
        if (cArray != null) {
            System.arraycopy(cArray, 0, this.text, 0, this.textLength);
        }
        this.findRenderStart();
        return this;
    }

    public int getMaxLength() {
        return this.text.length;
    }

    @Deprecated
    public int getMaxStringLength() {
        return this.text.length;
    }

    public boolean isFocused() {
        return this.isEnabled() && this.isFocused;
    }

    public boolean isFocusable() {
        return this.canFocusChange;
    }

    public int getContentHeight() {
        FontRenderer fontRenderer = this.getFontRenderer();
        int n = fontRenderer.field_78288_b;
        if (this.multiline) {
            for (int i = 0; i < this.textLength; ++i) {
                if (this.text[i] != '\n') continue;
                n += fontRenderer.field_78288_b;
            }
        }
        return n;
    }

    public int getVisibleHeight() {
        FontRenderer fontRenderer = this.getFontRenderer();
        int n = fontRenderer.field_78288_b;
        if (this.multiline) {
            for (int i = 0; i < this.textLength; ++i) {
                if (this.text[i] != '\n') continue;
                n += fontRenderer.field_78288_b;
            }
        }
        return Math.min(n - this.renderStartY, this.sizeY);
    }

    public int getContentWidth() {
        FontRenderer fontRenderer = this.getFontRenderer();
        int n = 0;
        for (int i = 0; i < this.textLength; ++i) {
            n += fontRenderer.func_78263_a(this.text[i]);
        }
        return n;
    }

    public int getVisibleWidth() {
        FontRenderer fontRenderer = this.getFontRenderer();
        int n = 0;
        int n2 = this.sizeX - 1;
        int n3 = 0;
        if (this.multiline) {
            for (int i = 0; i < this.textLength; ++i) {
                char c = this.text[i];
                int n4 = fontRenderer.func_78263_a(c);
                if (c == '\n') {
                    n3 = Math.max(n3, n);
                    n = 0;
                } else {
                    n += n4;
                }
                if (n - this.renderStartX < n2) continue;
                n3 = n2 + this.renderStartX;
                break;
            }
            n3 -= this.renderStartX;
        } else {
            for (int i = this.renderStartX; i < this.textLength; ++i) {
                char c = this.text[i];
                int n5 = fontRenderer.func_78263_a(c);
                if ((n3 += n5) < n2) continue;
                n3 = n2;
                break;
            }
        }
        return n3;
    }

    public String getText() {
        return new String(this.text, 0, this.textLength);
    }

    public String getSelectedText() {
        if (this.selectionStart != this.selectionEnd) {
            return new String(this.text, this.selectionStart, this.selectionEnd);
        }
        return this.getText();
    }

    public void writeText(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && this.insertCharacter(string.charAt(n)); ++n) {
        }
        this.clearSelection();
        this.findRenderStart();
        this.onCharacterEntered(n > 0);
    }

    public boolean isAllowedCharacter(char c) {
        return this.multiline && c == '\n' || ChatAllowedCharacters.func_71566_a((char)c);
    }

    protected boolean onEnter() {
        if (this.multiline) {
            boolean bl;
            if (this.caretInsert && this.selectionStart == this.selectionEnd) {
                this.caretInsert = false;
                bl = this.insertCharacter('\n');
                this.caretInsert = true;
            } else {
                bl = this.insertCharacter('\n');
            }
            this.clearSelection();
            this.findRenderStart();
            this.onCharacterEntered(bl);
            return true;
        }
        return false;
    }

    protected void onFocusLost() {
    }

    protected void onCharacterEntered(boolean bl) {
    }

    protected boolean insertCharacter(char c) {
        if (this.isAllowedCharacter(c)) {
            if (this.selectionStart != this.selectionEnd) {
                if (this.caret == this.selectionStart) {
                    ++this.caret;
                }
                this.text[this.selectionStart++] = c;
                return true;
            }
            int n = this.getMaxLength();
            if (this.caretInsert && this.caret == n || this.textLength == n) {
                return false;
            }
            if (!this.caretInsert || this.multiline && this.text[this.caret] == '\n') {
                if (this.caret < this.textLength) {
                    System.arraycopy(this.text, this.caret, this.text, this.caret + 1, this.textLength - this.caret);
                }
                ++this.textLength;
            }
            this.text[this.caret++] = c;
            return true;
        }
        return true;
    }

    protected void findRenderStart() {
        this.caret = MathHelper.clampI(this.caret, 0, this.textLength);
        if (this.selectionStart == this.selectionEnd) {
            this.selectionStart = this.selectionEnd = this.caret;
        }
        if (this.multiline) {
            this.findRenderStartML();
            return;
        }
        this.renderStartY = 0;
        if (this.caret < this.renderStartX) {
            this.renderStartX = this.caret;
            return;
        }
        FontRenderer fontRenderer = this.getFontRenderer();
        int n = this.sizeX - 2;
        int n2 = 0;
        for (int i = this.renderStartX; i < this.caret; ++i) {
            n2 += fontRenderer.func_78263_a(this.text[i]);
            while (n2 >= n) {
                n2 -= fontRenderer.func_78263_a(this.text[this.renderStartX++]);
                if (this.renderStartX < this.textLength) continue;
                return;
            }
        }
    }

    protected void findRenderStartML() {
        char c;
        int n;
        if (this.caret == this.textLength && this.textLength == 0) {
            this.renderStartY = 0;
            this.renderStartX = 0;
            return;
        }
        FontRenderer fontRenderer = this.getFontRenderer();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.caret;
        while (n4-- > 0) {
            n = this.text[n4];
            if (n == 10) {
                while (n4 > 0) {
                    n = this.text[n4];
                    if (n == 10) {
                        n3 += fontRenderer.field_78288_b;
                    }
                    --n4;
                }
                break;
            }
            n2 += fontRenderer.func_78263_a((char)n);
        }
        this.caretX = n2;
        n4 = Math.max(0, (this.sizeY - 2) / fontRenderer.field_78288_b) * fontRenderer.field_78288_b;
        if (this.caret > 0 && this.text[this.caret - 1] == '\n') {
            this.renderStartX = 0;
            if (this.caret == this.textLength) {
                this.renderStartY -= n4;
                this.renderStartY &= ~this.renderStartY >> 31;
            }
        }
        while (n3 - this.renderStartY < 0) {
            this.renderStartY -= fontRenderer.field_78288_b;
        }
        while (n3 - this.renderStartY >= n4) {
            this.renderStartY += fontRenderer.field_78288_b;
        }
        n = this.prevCaret > this.caret ? 1 : -1;
        int n5 = 0;
        while (n2 - this.renderStartX < 0 && (c = this.text[this.caret + n5]) != '\n') {
            this.renderStartX -= fontRenderer.func_78263_a(c);
            n5 += n;
        }
        this.renderStartX &= ~this.renderStartX >> 31;
        n4 = this.sizeX - 2 - 3;
        n5 = 0;
        while (n2 - this.renderStartX >= n4) {
            this.renderStartX += fontRenderer.func_78263_a(this.text[this.caret - n5]);
            ++n5;
        }
        this.prevCaret = this.caret;
    }

    protected void clearSelection() {
        if (this.selectionStart != this.selectionEnd) {
            if (this.selectionEnd < this.textLength) {
                System.arraycopy(this.text, this.selectionEnd, this.text, this.selectionStart, this.textLength - this.selectionEnd);
            }
            this.textLength -= this.selectionEnd - this.selectionStart;
            this.selectionEnd = this.caret = this.selectionStart;
            this.findRenderStart();
            this.onCharacterEntered(true);
        }
    }

    protected final int seekNextCaretLocation(int n) {
        return this.seekNextCaretLocation(n, true);
    }

    protected int seekNextCaretLocation(int n, boolean bl) {
        int n2;
        char c;
        int n3;
        int n4 = bl ? 1 : -1;
        int n5 = n3 = bl ? this.textLength : 0;
        if (n != n3) {
            n += n4;
        }
        char c2 = c = n == this.textLength ? (char)'\u0000' : this.text[n];
        if (!bl) {
            if (n != n3 && Character.isSpaceChar(c)) {
                n += !Character.isSpaceChar(this.text[n + n4]) ? n4 : 0;
            }
        } else if (n != n3 && Character.isSpaceChar(c)) {
            n -= !Character.isSpaceChar(this.text[n - n4]) ? n4 : 0;
        }
        c = this.text[n];
        if (this.smartCaret) {
            for (n2 = n; n2 != n3; n2 += n4) {
                boolean bl2;
                char c3 = this.text[n2];
                boolean bl3 = Character.isLetterOrDigit(c3) != Character.isLetterOrDigit(c);
                boolean bl4 = !bl3 && Character.isUpperCase(c3) != Character.isUpperCase(c);
                boolean bl5 = bl2 = Character.isWhitespace(c) != Character.isWhitespace(c3);
                if (bl3 || bl4 || bl2) {
                    int n6 = 0;
                    if (this.smartCaretCase && bl4) {
                        n6 = !bl ? 0 : -n4;
                    } else if (bl2) {
                        if (bl) {
                            if (n2 != n3 && !Character.isWhitespace(this.text[n2 + n4])) {
                                n6 = Character.isWhitespace(c3) ? 1 : 0;
                            }
                        } else {
                            n6 = 1;
                        }
                    }
                    return n2 + n6;
                }
                c = c3;
            }
        } else {
            while (n2 != n3) {
                char c4 = this.text[n2];
                if (Character.isSpaceChar(c4) != Character.isSpaceChar(c)) {
                    return n2;
                }
                n2 += n4;
            }
        }
        return bl ? this.textLength : 0;
    }

    @Override
    public boolean onKeyTyped(char c, int n) {
        if (!this.isFocused()) {
            return false;
        }
        switch (c) {
            case '\u0001': {
                this.selectionEnd = this.caret = this.textLength;
                this.selectionStart = 0;
                this.findRenderStart();
                return true;
            }
            case '\u0003': {
                if (this.selectionStart != this.selectionEnd) {
                    GuiScreen.func_146275_d((String)this.getSelectedText());
                }
                return true;
            }
            case '\u0018': {
                if (this.selectionStart != this.selectionEnd) {
                    GuiScreen.func_146275_d((String)this.getSelectedText());
                    this.clearSelection();
                }
                return true;
            }
            case '\u0016': {
                this.writeText(GuiScreen.func_146277_j());
                return true;
            }
        }
        switch (n) {
            case 1: {
                this.setFocused(false);
                return !this.isFocused();
            }
            case 28: 
            case 156: {
                return this.onEnter();
            }
            case 210: {
                if (GuiScreen.func_146272_n()) {
                    this.writeText(GuiScreen.func_146277_j());
                } else {
                    this.caretInsert = !this.caretInsert;
                }
                return true;
            }
            case 218: {
                this.clearSelection();
                return true;
            }
            case 211: {
                boolean bl = false;
                if (!GuiScreen.func_146272_n()) {
                    if (this.selectionStart != this.selectionEnd) {
                        this.clearSelection();
                    } else if (GuiScreen.func_146271_m()) {
                        int n2 = this.seekNextCaretLocation(this.caret, true) - this.caret;
                        this.selectionStart = this.caret;
                        this.selectionEnd = this.caret + n2;
                        this.clearSelection();
                    } else {
                        if (this.caret < this.textLength && this.textLength > 0) {
                            --this.textLength;
                            System.arraycopy(this.text, this.caret + 1, this.text, this.caret, this.textLength - this.caret);
                            bl = true;
                        }
                        this.findRenderStart();
                        this.onCharacterEntered(bl);
                    }
                    return true;
                }
            }
            case 14: {
                int n3;
                boolean bl = false;
                boolean bl2 = true;
                boolean bl3 = false;
                if (this.selectionStart != this.selectionEnd) {
                    this.clearSelection();
                } else if (GuiScreen.func_146271_m()) {
                    n3 = this.seekNextCaretLocation(this.caret, false) - this.caret;
                    this.selectionStart = this.caret + n3;
                    this.selectionEnd = this.caret;
                    this.clearSelection();
                } else {
                    bl2 = false;
                    if (this.caret > 0 && this.textLength > 0) {
                        if (this.caret != this.textLength) {
                            System.arraycopy(this.text, this.caret, this.text, this.caret - 1, this.textLength - this.caret);
                        }
                        bl3 = this.text[--this.caret] == '\n';
                        --this.textLength;
                        bl = true;
                    }
                }
                n3 = this.caret;
                if (!bl3) {
                    int n4 = 3;
                    while (n4-- > 0 && this.caret > 1 && this.text[this.caret - 1] != '\n') {
                        --this.caret;
                    }
                }
                this.findRenderStart();
                this.caret = n3;
                if (!bl2) {
                    this.onCharacterEntered(bl);
                }
                return true;
            }
            case 199: {
                int n5 = 0;
                if (!GuiScreen.func_146271_m()) {
                    for (int i = this.caret - 1; i > 0; --i) {
                        if (this.text[i] != '\n') continue;
                        n5 = Math.min(i + 1, this.textLength);
                        break;
                    }
                }
                if (GuiScreen.func_146272_n()) {
                    if (this.caret >= this.selectionEnd) {
                        this.selectionEnd = this.selectionStart;
                    }
                    this.selectionStart = n5;
                } else {
                    this.selectionStart = this.selectionEnd = n5;
                }
                this.caret = n5;
                this.findRenderStart();
                return true;
            }
            case 207: {
                int n6 = this.textLength;
                if (!GuiScreen.func_146271_m()) {
                    for (int i = this.caret; i < this.textLength; ++i) {
                        if (this.text[i] != '\n') continue;
                        n6 = i;
                        break;
                    }
                }
                if (GuiScreen.func_146272_n()) {
                    if (this.caret <= this.selectionStart) {
                        this.selectionStart = this.selectionEnd;
                    }
                    this.selectionEnd = n6;
                } else {
                    this.selectionStart = this.selectionEnd = n6;
                }
                this.caret = n6;
                this.findRenderStart();
                return true;
            }
            case 203: 
            case 205: {
                int n7 = n == 203 ? -1 : 1;
                boolean bl = false;
                if (GuiScreen.func_146271_m()) {
                    n7 = this.seekNextCaretLocation(this.caret, n == 205) - this.caret;
                } else if (StringHelper.isAltKeyDown() && GuiScreen.func_146272_n()) {
                    this.selectionStart = this.selectionEnd = (this.caret = this.seekNextCaretLocation(this.caret, n == 205));
                    n7 = this.seekNextCaretLocation(this.caret, n != 205) - this.caret;
                    bl = true;
                }
                if (!GuiScreen.func_146272_n()) {
                    this.selectionStart = this.selectionEnd = this.caret;
                }
                int n8 = this.caret;
                this.caret = MathHelper.clampI(this.caret + n7, 0, this.textLength);
                n7 = this.caret - n8;
                if (GuiScreen.func_146272_n()) {
                    if (this.caret == this.selectionStart + n7) {
                        this.selectionStart = this.caret;
                    } else if (this.caret == this.selectionEnd + n7) {
                        this.selectionEnd = this.caret;
                    }
                    if (this.selectionStart > this.selectionEnd) {
                        n8 = this.selectionStart;
                        this.selectionStart = this.selectionEnd;
                        this.selectionEnd = n8;
                    }
                }
                if (bl) {
                    this.caret -= n7;
                }
                this.findRenderStart();
                return true;
            }
            case 200: 
            case 208: {
                int n9;
                if (!this.multiline) {
                    return false;
                }
                if (!GuiScreen.func_146272_n()) {
                    this.selectionStart = this.selectionEnd = this.caret;
                }
                int n10 = n == 200 ? -1 : 1;
                int n11 = n10 == -1 ? 0 : this.textLength;
                int n12 = this.caretX;
                int n13 = n9;
                for (n9 = this.caret; n9 != n11; n9 += n10) {
                    if (n10 == -1 && n9 == this.caret || this.text[n9] != '\n') continue;
                    if (n9 != n11) {
                        n9 += n10;
                        break;
                    }
                    return true;
                }
                if (n10 == -1) {
                    while (n9 > 0 && this.text[n9] != '\n') {
                        --n9;
                    }
                    if (n9 == 0) {
                        if (this.text[0] == '\n') {
                            this.caret = 0;
                            this.findRenderStart();
                            this.caretX = n12;
                        }
                    } else {
                        ++n9;
                    }
                }
                FontRenderer fontRenderer = this.getFontRenderer();
                int n14 = 0;
                while (n9 <= this.textLength) {
                    char c2;
                    char c3 = c2 = n9 < this.textLength ? this.text[n9] : (char)'\u0000';
                    if (n9 == this.textLength || c2 == '\n' || n14 >= n12) {
                        this.caret = n9;
                        this.findRenderStart();
                        this.caretX = n12;
                        break;
                    }
                    n14 += fontRenderer.func_78263_a(c2);
                    ++n9;
                }
                int n15 = this.caret - n13;
                if (GuiScreen.func_146272_n()) {
                    if (this.selectionStart == this.selectionEnd) {
                        this.selectionStart = this.selectionEnd = n13;
                    }
                    if (this.caret == this.selectionStart + n15) {
                        this.selectionStart = this.caret;
                    } else if (this.caret == this.selectionEnd + n15) {
                        this.selectionEnd = this.caret;
                    }
                    if (this.selectionStart > this.selectionEnd) {
                        n14 = this.selectionStart;
                        this.selectionStart = this.selectionEnd;
                        this.selectionEnd = n14;
                    }
                }
                return true;
            }
        }
        if (this.isAllowedCharacter(c)) {
            boolean bl = this.insertCharacter(c);
            this.clearSelection();
            this.findRenderStart();
            this.onCharacterEntered(bl);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        this.pressed = n3 == 0;
        boolean bl = this.selecting = n3 == 0 && this.isFocused();
        if (this.selecting) {
            if (this.textLength == 0) {
                this.caret = 0;
                this.selectionEnd = 0;
                this.selectionStart = 0;
            } else {
                block12: {
                    FontRenderer fontRenderer = this.getFontRenderer();
                    int n4 = n - this.posX - 1;
                    int n5 = n2 - this.posY - 1;
                    if (!this.multiline) {
                        int n6;
                        int n7 = this.renderStartX;
                        int n8 = 0;
                        while ((n8 += (n6 = fontRenderer.func_78263_a(this.text[n7]))) <= n4 && ++n7 < this.textLength) {
                        }
                        this.selectionEnd = this.caret = n7;
                        this.selectionStart = this.caret;
                    } else {
                        n4 += this.renderStartX;
                        n5 += this.renderStartY;
                        int n9 = 0;
                        boolean bl2 = false;
                        int n10 = 0;
                        int n11 = 0;
                        int n12 = fontRenderer.field_78288_b;
                        while (n10 < this.textLength) {
                            char c = this.text[n10];
                            int n13 = 0;
                            if (c == '\n') {
                                if (n12 > n5) {
                                    n9 = n10;
                                    break;
                                }
                                bl2 = false;
                                n11 = 0;
                                n12 += fontRenderer.field_78288_b;
                            } else {
                                n13 = fontRenderer.func_78263_a(c);
                            }
                            if (!bl2) {
                                n9 = n10;
                            }
                            if ((n11 += n13) <= n4 && ++n10 < this.textLength) continue;
                            if (n5 < n12 || n10 >= this.textLength) {
                                this.selectionEnd = this.caret = n10;
                                this.selectionStart = this.caret;
                                break block12;
                            }
                            ++n10;
                            bl2 = true;
                        }
                        this.selectionEnd = this.caret = n9;
                        this.selectionStart = this.caret;
                    }
                }
                this.findRenderStart();
            }
        }
        this.setFocused(true);
        return true;
    }

    @Override
    public void update(int n, int n2) {
        this.caretCounter = (byte)(this.caretCounter + 1);
    }

    @Override
    public void onMouseReleased(int n, int n2) {
        if (!this.pressed) {
            boolean bl = this.isFocused();
            this.setFocused(false);
            if (bl && !this.isFocused()) {
                this.onFocusLost();
            }
        }
        this.selecting = false;
        this.pressed = false;
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        this.drawModalRect(this.posX - 1, this.posY - 1, this.posX + this.sizeX + 1, this.posY + this.sizeY + 1, this.borderColor);
        this.drawModalRect(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, this.isEnabled() ? this.backgroundColor : this.disabledColor);
    }

    @Override
    public void drawForeground(int n, int n2) {
        boolean bl = this.enableStencil;
        int n3 = -1;
        if (bl) {
            n3 = MinecraftForgeClient.reserveStencilBit();
            if (n3 == -1) {
                bl = false;
            } else {
                GL11.glEnable((int)2960);
                this.drawStencil(this.posX + 1, this.posY + 1, this.posX + this.sizeX - 1, this.posY + this.sizeY - 1, 1 << n3);
            }
        }
        FontRenderer fontRenderer = this.getFontRenderer();
        char[] cArray = this.text;
        int n4 = this.posX + 1 - (this.multiline ? this.renderStartX : 0);
        int n5 = this.sizeX - 1;
        int n6 = this.posY + 1 - this.renderStartY;
        int n7 = n6 + fontRenderer.field_78288_b;
        int n8 = this.renderStartY + Math.max(0, (this.sizeY - 2) / fontRenderer.field_78288_b) * fontRenderer.field_78288_b;
        if (bl && this.sizeY - (n8 - this.renderStartY) > 2) {
            n8 += fontRenderer.field_78288_b;
        }
        int n9 = n5 + (this.multiline ? this.renderStartX : 0);
        int n10 = 0;
        int n11 = 0;
        for (int i = this.multiline ? 0 : this.renderStartX; i <= this.textLength; ++i) {
            int n12;
            int n13;
            boolean bl2 = i == this.textLength;
            boolean bl3 = n11 >= this.renderStartY && n10 < n9 && n11 < n8;
            int n14 = 2;
            char c = '\u0000';
            if (!bl2) {
                c = cArray[i];
                if (bl3) {
                    n14 = this.multiline && c == '\n' ? 2 : fontRenderer.func_78263_a(c);
                }
                n13 = n10 + n14;
                if (this.multiline) {
                    if (!bl) {
                        bl3 &= n10 >= this.renderStartX;
                    }
                    bl3 &= n13 > this.renderStartX;
                }
                if (!bl && n13 > n5) {
                    bl3 = false;
                    if (!this.multiline) break;
                    if (c != '\n') continue;
                }
            }
            int n15 = n13 = bl3 && i == this.caret && (this.caretCounter = (byte)(this.caretCounter & 0x1F)) < 16 && this.isFocused() ? 1 : 0;
            if (n13 != 0) {
                n12 = n10 + 2;
                if (this.caretInsert) {
                    n12 = n10 + n14;
                }
                this.drawModalRect(n4 + n10, n6 - 1 + n11, n4 + n12, n7 + n11, 0xFF000000 & this.defaultCaretColor | ~this.defaultCaretColor & 0xFFFFFF);
            }
            if (bl3 && !bl2) {
                n12 = (i >= this.selectionStart ? 1 : 0) & (i < this.selectionEnd ? 1 : 0);
                if (n12 != 0) {
                    this.drawModalRect(n4 + n10, n6 + n11, n4 + n10 + n14, n7 + n11, this.selectedLineColor);
                }
                if (c != '\n') {
                    fontRenderer.func_78276_b(String.valueOf(c), n4 + n10, n6 + n11, n12 != 0 ? this.selectedTextColor : this.textColor);
                }
            }
            if (n13 != 0) {
                n12 = n10 + 2;
                if (this.caretInsert) {
                    n12 = n10 + n14;
                }
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)775, (int)0);
                this.gui.drawSizedRect(n4 + n10, n6 - 1 + n11, n4 + n12, n7 + n11, -1);
                GL11.glDisable((int)3042);
            }
            if (c == '\n') {
                n10 = 0;
                n14 = 0;
                if ((n11 += fontRenderer.field_78288_b) > n8) break;
            }
            if (!this.multiline && (n10 += n14) > n5) break;
        }
        if (bl) {
            GL11.glDisable((int)2960);
            MinecraftForgeClient.releaseStencilBit((int)n3);
        }
    }
}

