/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.listbox.IListBoxElement;
import cofh.lib.util.helpers.StringHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class ElementListBox
extends ElementBase {
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();
    public int selectedLineColor = new GuiColor(0, 0, 0, 255).getColor();
    public int textColor = new GuiColor(150, 150, 150, 255).getColor();
    public int selectedTextColor = new GuiColor(255, 255, 255, 255).getColor();
    private final int _marginTop = 2;
    private final int _marginLeft = 2;
    private final int _marginRight = 2;
    private final int _marginBottom = 2;
    private final List<IListBoxElement> _elements = new LinkedList<IListBoxElement>();
    private int _firstIndexDisplayed;
    private int _selectedIndex;
    private int scrollHoriz;

    public ElementListBox(GuiBase guiBase, int n, int n2, int n3, int n4) {
        super(guiBase, n, n2, n3, n4);
    }

    public void add(IListBoxElement iListBoxElement) {
        this._elements.add(iListBoxElement);
    }

    public void add(Collection<? extends IListBoxElement> collection) {
        this._elements.addAll(collection);
    }

    public void remove(IListBoxElement iListBoxElement) {
        this._elements.remove(iListBoxElement);
    }

    public void removeAt(int n) {
        this._elements.remove(n);
    }

    public int getInternalWidth() {
        int n = 0;
        for (int i = 0; i < this._elements.size(); ++i) {
            n = Math.max(this._elements.get(i).getWidth(), n);
        }
        return n;
    }

    public int getInternalHeight() {
        int n = 0;
        for (int i = 0; i < this._elements.size(); ++i) {
            n += this._elements.get(i).getHeight();
        }
        return n;
    }

    public int getContentWidth() {
        return this.sizeX - 2 - 2;
    }

    public int getContentHeight() {
        return this.sizeY - 2 - 2;
    }

    public int getContentTop() {
        return this.posY + 2;
    }

    public int getContentLeft() {
        return this.posX + 2;
    }

    public final int getContentBottom() {
        return this.getContentTop() + this.getContentHeight();
    }

    public final int getContentRight() {
        return this.getContentLeft() + this.getContentWidth();
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        this.drawModalRect(this.posX - 1, this.posY - 1, this.posX + this.sizeX + 1, this.posY + this.sizeY + 1, this.borderColor);
        this.drawModalRect(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, this.backgroundColor);
    }

    @Override
    public void drawForeground(int n, int n2) {
        int n3 = 0;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2960);
        GL11.glClear((int)1024);
        this.drawStencil(this.getContentLeft(), this.getContentTop(), this.getContentRight(), this.getContentBottom(), 1);
        GL11.glTranslated((double)(-this.scrollHoriz), (double)0.0, (double)0.0);
        int n4 = this._elements.size();
        for (int i = this._firstIndexDisplayed; i < n4 && n3 <= this.getContentHeight(); n3 += this._elements.get(i).getHeight(), ++i) {
            if (i == this._selectedIndex) {
                this._elements.get(i).draw(this, this.getContentLeft(), this.getContentTop() + n3, this.selectedLineColor, this.selectedTextColor);
                continue;
            }
            this._elements.get(i).draw(this, this.getContentLeft(), this.getContentTop() + n3, this.backgroundColor, this.textColor);
        }
        GL11.glDisable((int)2960);
        GL11.glPopMatrix();
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && n5 <= this.getContentHeight(); n5 += n4, ++i) {
            n4 = this._elements.get(i).getHeight();
            if (this.getContentTop() + n5 > n2 || this.getContentTop() + n5 + n4 < n2) continue;
            this.setSelectedIndex(i);
            this.onElementClicked(this._elements.get(i));
            break;
        }
        return true;
    }

    @Override
    public boolean onMouseWheel(int n, int n2, int n3) {
        if (StringHelper.isControlKeyDown()) {
            if (n3 > 0) {
                this.scrollLeft();
            } else if (n3 < 0) {
                this.scrollRight();
            }
        } else if (n3 > 0) {
            this.scrollUp();
        } else if (n3 < 0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        int n = 0;
        int n2 = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && n + this._elements.get(i).getHeight() <= this.sizeY; ++i) {
            n += this._elements.get(i).getHeight();
            ++n2;
        }
        if (this._firstIndexDisplayed + n2 < this._elements.size()) {
            ++this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollUp() {
        if (this._firstIndexDisplayed > 0) {
            --this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollLeft() {
        this.scrollHoriz = Math.max(this.scrollHoriz - 15, 0);
        this.onScrollH(this.scrollHoriz);
    }

    public void scrollRight() {
        this.scrollHoriz = Math.min(this.scrollHoriz + 15, this.getLastScrollPositionH());
        this.onScrollH(this.scrollHoriz);
    }

    public int getLastScrollPosition() {
        int n = this._elements.size() - 1;
        for (int i = this._elements.get(n).getHeight(); n > 0 && i < this.sizeY; i += this._elements.get(--n).getHeight()) {
        }
        return n + 1;
    }

    public int getLastScrollPositionH() {
        return Math.max(this.getInternalWidth() - this.getContentWidth(), 0);
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getIndexOf(Object object) {
        for (int i = 0; i < this._elements.size(); ++i) {
            if (!this._elements.get(i).getValue().equals(object)) continue;
            return i;
        }
        return -1;
    }

    public IListBoxElement getSelectedElement() {
        return this._elements.get(this._selectedIndex);
    }

    public void setSelectedIndex(int n) {
        if (n >= 0 && n < this._elements.size() && n != this._selectedIndex) {
            this._selectedIndex = n;
            this.onSelectionChanged(this._selectedIndex, this.getSelectedElement());
        }
    }

    public IListBoxElement getElement(int n) {
        return this._elements.get(n);
    }

    public int getElementCount() {
        return this._elements.size();
    }

    public void scrollToV(int n) {
        if (n >= 0 && n < this._elements.size()) {
            this._firstIndexDisplayed = n;
        }
    }

    public void scrollToH(int n) {
        if (n >= 0 && n <= this.getLastScrollPositionH()) {
            this.scrollHoriz = n;
        }
    }

    protected void onElementClicked(IListBoxElement iListBoxElement) {
    }

    protected void onScrollV(int n) {
    }

    protected void onScrollH(int n) {
    }

    protected void onSelectionChanged(int n, IListBoxElement iListBoxElement) {
    }
}

