/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props;

import com.mia.props.Props;
import com.mia.props.TabProps;
import com.mia.props.TileProps;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;

public class ModelData {
    public float x1;
    public float x2 = 1.0f;
    public float y1;
    public float y2 = 1.0f;
    public float z1;
    public float z2 = 1.0f;
    public String name;
    public int type = -1;
    public boolean walkthrough = false;
    public int light = 0;
    public boolean limitRotation = false;
    public TabProps tab;
    public String sound;
    public int invX;
    public int invY = 0;

    public ModelData(String name, int type) {
        this(name, type, TabProps.Main, TileProps.class);
    }

    public ModelData(String name, int type, String sound) {
        this(name, type, TabProps.Main, TileProps.class, sound);
    }

    public ModelData(String name, int type, Class<? extends TileProps> tileClass) {
        this(name, type, TabProps.Main, tileClass);
    }

    public ModelData(String name, int type, Class<? extends TileProps> tileClass, String sound) {
        this(name, type, TabProps.Main, tileClass, sound);
    }

    public ModelData(String name, int type, TabProps tab) {
        this(name, type, tab, TileProps.class);
    }

    public ModelData(String name, int type, TabProps tab, String sound) {
        this(name, type, tab, TileProps.class, sound);
    }

    public ModelData(String name, int type, TabProps tab, Class<? extends TileProps> tileClass) {
        this(name, type, tab, tileClass, null);
    }

    public ModelData(String name, int type, TabProps tab, Class<? extends TileProps> tileClass, String sound) {
        this.name = name;
        this.type = type;
        this.tab = tab;
        this.sound = sound;
        Props.data[type] = this;
        Props.tileEntities[type] = tileClass;
        if (!Props.registeredTileEntities.contains(tileClass)) {
            GameRegistry.registerTileEntity(tileClass, (String)tileClass.getCanonicalName());
            Props.registeredTileEntities.add(tileClass);
        }
    }

    public ModelData setLightValue(int i) {
        this.light = i;
        return this;
    }

    public ModelData setBounds(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.z1 = z1;
        this.z2 = z2;
        return this;
    }

    public ModelData setWalkthrough() {
        this.walkthrough = true;
        return this;
    }

    public ModelData setRecipe(String recipe) {
        if (Props.recipes.contains(recipe)) {
            throw new RuntimeException(String.format("Recipe %s is already registered !", new Object[0]));
        }
        Props.recipes.add(recipe);
        if (recipe.length() != 9) {
            throw new RuntimeException(String.format("Recipe %s is not 9 chars long !", new Object[0]));
        }
        String row_top = recipe.substring(0, 3).replace("_", " ");
        String row_mid = recipe.substring(3, 6).replace("_", " ");
        String row_bot = recipe.substring(6, 9).replace("_", " ");
        GameRegistry.addRecipe((ItemStack)new ItemStack(Props.props, 1, this.type), (Object[])new Object[]{row_top.toUpperCase(), row_mid.toUpperCase(), row_bot.toUpperCase(), Character.valueOf('R'), new ItemStack(Props.clay, 1, 0), Character.valueOf('B'), new ItemStack(Props.clay, 1, 1), Character.valueOf('G'), new ItemStack(Props.clay, 1, 2)});
        return this;
    }

    public ModelData setDefaultRecipe() {
        String[] symbols = new String[]{"_", "R", "G", "B"};
        String recipe = "";
        for (int i = 0; i < 9; ++i) {
            recipe = recipe + symbols[(this.type + 1) / (i + 1) % 4];
        }
        this.setRecipe(recipe);
        return this;
    }

    public ModelData hasLimitedRotation() {
        this.limitRotation = true;
        return this;
    }

    public ModelData setInventorySize(int x, int y) {
        this.invX = x;
        this.invY = y;
        return this;
    }
}

