/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import java.lang.reflect.Method;
import java.util.List;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionJavaLambda;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.type.ZenTypeFunction;
import stanhebben.zenscript.type.ZenTypeNative;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionFunction
extends Expression {
    private final List<ParsedFunctionArgument> arguments;
    private final ZenType returnType;
    private final List<Statement> statements;
    private final ZenTypeFunction functionType;

    public ExpressionFunction(ZenPosition position, List<ParsedFunctionArgument> arguments, ZenType returnType, List<Statement> statements) {
        super(position);
        System.out.println("Function expression: " + arguments.size() + " arguments");
        this.arguments = arguments;
        this.returnType = returnType;
        this.statements = statements;
        ZenType[] argumentTypes = new ZenType[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            argumentTypes[i] = arguments.get(i).getType();
        }
        this.functionType = new ZenTypeFunction(returnType, argumentTypes);
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, ZenType type) {
        if (type instanceof ZenTypeNative) {
            ZenTypeNative nativeType = (ZenTypeNative)type;
            Class nativeClass = nativeType.getNativeClass();
            if (nativeClass.isInterface() && nativeClass.getMethods().length == 1) {
                Method method = nativeClass.getMethods()[0];
                if (this.returnType != ZenTypeAny.INSTANCE && !this.returnType.canCastImplicit(environment.getType(method.getGenericReturnType()), environment)) {
                    environment.error(position, "return type not compatible");
                    return new ExpressionInvalid(position);
                }
                if (this.arguments.size() != method.getParameterTypes().length) {
                    environment.error(position, "number of arguments incorrect");
                    return new ExpressionInvalid(position);
                }
                for (int i = 0; i < this.arguments.size(); ++i) {
                    ZenType argumentType = environment.getType(method.getGenericParameterTypes()[i]);
                    if (this.arguments.get(i).getType() == ZenTypeAny.INSTANCE || argumentType.canCastImplicit(this.arguments.get(i).getType(), environment)) continue;
                    environment.error(position, "argument " + i + " doesn't match");
                    return new ExpressionInvalid(position);
                }
                return new ExpressionJavaLambda(position, nativeClass, this.arguments, this.statements, environment.getType(nativeClass));
            }
            environment.error(position, type.toString() + " is not a functional interface");
            return new ExpressionInvalid(position);
        }
        environment.error(position, "Cannot cast a function literal to " + type.toString());
        return new ExpressionInvalid(position);
    }

    @Override
    public ZenType getType() {
        return this.functionType;
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

