/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.liquid.WeightedLiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc1710.util.MineTweakerPlatformUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.api.RanchedItem;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.AutoSpawner")
@ModOnly(value={"MineFactoryReloaded"})
public class Rancher {
    private static final Random random = new Random();

    @ZenMethod
    public static void addRanchable(String entityClassName, WeightedItemStack[] possibleDrops, @Optional WeightedLiquidStack[] possibleLiquids) {
        if (possibleLiquids == null) {
            possibleLiquids = new WeightedLiquidStack[]{};
        }
        Class<? extends EntityLivingBase> entityClass = MineTweakerPlatformUtils.getLivingEntityClass(entityClassName);
        MineTweakerAPI.apply(new AddRanchableAction(new TweakerRanchable(entityClass, possibleDrops, possibleLiquids)));
    }

    @ZenMethod
    public static void removeRanchable(String entityClassName) {
        Class<? extends EntityLivingBase> entityClass = MineTweakerPlatformUtils.getLivingEntityClass(entityClassName);
        if (!MFRRegistry.getRanchables().containsKey(entityClass)) {
            MineTweakerAPI.logWarning("No such ranchable: " + entityClassName);
        } else {
            MineTweakerAPI.apply(new RemoveRanchableAction((IFactoryRanchable)MFRRegistry.getRanchables().get(entityClass)));
        }
    }

    private static class RemoveRanchableAction
    implements IUndoableAction {
        private final IFactoryRanchable ranchable;

        public RemoveRanchableAction(IFactoryRanchable ranchable) {
            this.ranchable = ranchable;
        }

        @Override
        public void apply() {
            MFRRegistry.getRanchables().remove(this.ranchable.getRanchableEntity());
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getRanchables().put(this.ranchable.getRanchableEntity(), this.ranchable);
        }

        @Override
        public String describe() {
            return "Removing ranchable entity " + this.ranchable.getRanchableEntity().getName();
        }

        @Override
        public String describeUndo() {
            return "Restoring ranchable entity " + this.ranchable.getRanchableEntity().getName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRanchableAction
    implements IUndoableAction {
        private final TweakerRanchable ranchable;

        public AddRanchableAction(TweakerRanchable ranchable) {
            this.ranchable = ranchable;
        }

        @Override
        public void apply() {
            MFRRegistry.registerRanchable((IFactoryRanchable)this.ranchable);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getRanchables().remove(this.ranchable.entityClass);
        }

        @Override
        public String describe() {
            return "Adding ranchable entity " + this.ranchable.entityClass.getName();
        }

        @Override
        public String describeUndo() {
            return "Removing ranchable entity " + this.ranchable.entityClass.getName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class TweakerRanchable
    implements IFactoryRanchable {
        private final Class<? extends EntityLivingBase> entityClass;
        private final WeightedItemStack[] possibleDrops;
        private final WeightedLiquidStack[] possibleLiquids;

        public TweakerRanchable(Class<? extends EntityLivingBase> entityClass, WeightedItemStack[] possibleDrops, WeightedLiquidStack[] possibleLiquids) {
            this.entityClass = entityClass;
            this.possibleDrops = possibleDrops;
            this.possibleLiquids = possibleLiquids;
        }

        public Class<? extends EntityLivingBase> getRanchableEntity() {
            return this.entityClass;
        }

        public List<RanchedItem> ranch(World world, EntityLivingBase entity, IInventory inventory) {
            ArrayList<RanchedItem> result = new ArrayList<RanchedItem>();
            if (this.entityClass.isAssignableFrom(entity.getClass())) {
                for (IItemStack droppedItem : WeightedItemStack.pickRandomDrops(random, this.possibleDrops)) {
                    result.add(new RanchedItem(MineTweakerMC.getItemStack(droppedItem)));
                }
                block1: for (ILiquidStack droppedLiquid : WeightedLiquidStack.pickRandomDrops(random, this.possibleLiquids)) {
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack filled;
                        ItemStack stack = inventory.func_70301_a(i);
                        if (stack == null || (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)MineTweakerMC.getLiquidStack(droppedLiquid), (ItemStack)stack)) == null) continue;
                        inventory.func_70299_a(i, filled);
                        continue block1;
                    }
                }
            }
            return result;
        }
    }
}

