/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.EnumMap;
import mcp.mobius.betterbarrels.common.LocalizedChat;
import mcp.mobius.betterbarrels.network.IBarrelMessage;
import mcp.mobius.betterbarrels.network.Message0x00FulleTileEntityNBT;
import mcp.mobius.betterbarrels.network.Message0x01ContentUpdate;
import mcp.mobius.betterbarrels.network.Message0x02GhostUpdate;
import mcp.mobius.betterbarrels.network.Message0x03SideupgradeUpdate;
import mcp.mobius.betterbarrels.network.Message0x04Structuralupdate;
import mcp.mobius.betterbarrels.network.Message0x05CoreUpdate;
import mcp.mobius.betterbarrels.network.Message0x06FullStorage;
import mcp.mobius.betterbarrels.network.Message0x07ForceRender;
import mcp.mobius.betterbarrels.network.Message0x08LinkUpdate;
import mcp.mobius.betterbarrels.network.Message0x09LocalizedChat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public enum BarrelPacketHandler {
    INSTANCE;

    public EnumMap<Side, FMLEmbeddedChannel> channels = NetworkRegistry.INSTANCE.newChannel("JABBA", new ChannelHandler[]{new BarrelCodec()});

    private BarrelPacketHandler() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.addClientHandlers();
        }
    }

    private void addClientHandlers() {
        FMLEmbeddedChannel channel = this.channels.get(Side.CLIENT);
        String codec = channel.findChannelHandlerNameForType(BarrelCodec.class);
        channel.pipeline().addAfter(codec, "ClientHandler", (ChannelHandler)new Message0x00FulleTileEntityNBT());
        channel.pipeline().addAfter("ClientHandler", "ContentUpdate", (ChannelHandler)new Message0x01ContentUpdate());
        channel.pipeline().addAfter("ContentUpdate", "GhostUpdate", (ChannelHandler)new Message0x02GhostUpdate());
        channel.pipeline().addAfter("GhostUpdate", "Sideupgradeupdate", (ChannelHandler)new Message0x03SideupgradeUpdate());
        channel.pipeline().addAfter("Sideupgradeupdate", "Structuralupdate", (ChannelHandler)new Message0x04Structuralupdate());
        channel.pipeline().addAfter("Structuralupdate", "CoreUpdate", (ChannelHandler)new Message0x05CoreUpdate());
        channel.pipeline().addAfter("CoreUpdate", "FullStorage", (ChannelHandler)new Message0x06FullStorage());
        channel.pipeline().addAfter("FullStorage", "ForceRender", (ChannelHandler)new Message0x07ForceRender());
        channel.pipeline().addAfter("ForceRender", "LinkUpdate", (ChannelHandler)new Message0x08LinkUpdate());
        channel.pipeline().addAfter("LinkUpdate", "LocalizedChat", (ChannelHandler)new Message0x09LocalizedChat());
    }

    public void sendTo(IBarrelMessage message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(IBarrelMessage message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(IBarrelMessage message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendLocalizedChat(EntityPlayer player, LocalizedChat message, Object ... extraNumbers) {
        if (player instanceof EntityPlayerMP) {
            INSTANCE.sendTo(new Message0x09LocalizedChat(message, extraNumbers), (EntityPlayerMP)player);
        }
    }

    public void writeNBTTagCompoundToBuffer(ByteBuf target, NBTTagCompound tag) throws IOException {
        if (tag == null) {
            target.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            target.writeShort((int)((short)abyte.length));
            target.writeBytes(abyte);
        }
    }

    public NBTTagCompound readNBTTagCompoundFromBuffer(ByteBuf dat) throws IOException {
        short short1 = dat.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        dat.readBytes(abyte);
        return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
    }

    public void writeItemStackToBuffer(ByteBuf target, ItemStack stack) throws IOException {
        if (stack == null) {
            target.writeShort(-1);
        } else {
            target.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            target.writeByte(stack.field_77994_a);
            target.writeShort(stack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.field_77990_d;
            }
            this.writeNBTTagCompoundToBuffer(target, nbttagcompound);
        }
    }

    public ItemStack readItemStackFromBuffer(ByteBuf dat) throws IOException {
        ItemStack itemstack = null;
        short short1 = dat.readShort();
        if (short1 >= 0) {
            byte b0 = dat.readByte();
            short short2 = dat.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)short1), (int)b0, (int)short2);
            itemstack.field_77990_d = this.readNBTTagCompoundFromBuffer(dat);
        }
        return itemstack;
    }

    private class BarrelCodec
    extends FMLIndexedMessageToMessageCodec<IBarrelMessage> {
        public BarrelCodec() {
            this.addDiscriminator(0, Message0x00FulleTileEntityNBT.class);
            this.addDiscriminator(1, Message0x01ContentUpdate.class);
            this.addDiscriminator(2, Message0x02GhostUpdate.class);
            this.addDiscriminator(3, Message0x03SideupgradeUpdate.class);
            this.addDiscriminator(4, Message0x04Structuralupdate.class);
            this.addDiscriminator(5, Message0x05CoreUpdate.class);
            this.addDiscriminator(6, Message0x06FullStorage.class);
            this.addDiscriminator(7, Message0x07ForceRender.class);
            this.addDiscriminator(8, Message0x08LinkUpdate.class);
            this.addDiscriminator(9, Message0x09LocalizedChat.class);
        }

        public void encodeInto(ChannelHandlerContext ctx, IBarrelMessage msg, ByteBuf target) throws Exception {
            msg.encodeInto(ctx, msg, target);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf dat, IBarrelMessage msg) {
            msg.decodeInto(ctx, dat, msg);
        }
    }
}

