/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class Utils {
    public static String getUnlocalizedName(String name) {
        return "headcrumbs." + name;
    }

    public static String getBlockTexture(String name) {
        return "headcrumbs:" + name;
    }

    public static String getItemTexture(String name) {
        return "headcrumbs:" + name;
    }

    public static String getEntityTexture(String name) {
        return "headcrumbs:textures/entities/" + name + ".png";
    }

    public static String getConainerName(String name) {
        return "container.headcrumbs." + name;
    }

    public static int getColour(int R, int G, int B) {
        return new Color(R < 0 ? 0 : R, G < 0 ? 0 : G, B < 0 ? 0 : B).getRGB() & 0xFFFFFF;
    }

    public static ResourceLocation getResource(String path) {
        return new ResourceLocation(path);
    }

    public static <T> T getTileEntity(IBlockAccess world, int x, int y, int z, Class<T> cls) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!cls.isInstance(tile)) {
            return null;
        }
        return (T)tile;
    }

    public static void dropStack(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && stack != null && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityItem.field_145804_b = 10;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static void addDungeonLoot(ItemStack stack, int minChance, int maxChance, int weight) {
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, minChance, maxChance, weight));
        ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, minChance, maxChance, weight));
        ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, minChance, maxChance, weight));
        ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, minChance, maxChance, weight));
    }

    public static void addStrongholdLoot(ItemStack stack, int minChance, int maxChance, int weight) {
        ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, minChance, maxChance, weight));
        ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, minChance, maxChance, weight));
        ChestGenHooks.addItem((String)"strongholdCrossing", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, minChance, maxChance, weight));
    }

    public static final void breakBlockWithParticles(World world, int x, int y, int z, int meta) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return;
        }
        world.func_147468_f(x, y, z);
        Utils.doBreakParticles(world, x, y, z, block, meta);
    }

    public static final void doBreakParticles(World world, int x, int y, int z, Block block, int meta) {
        world.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
    }
}

