/*
 * Decompiled with CFR 0.152.
 */
package lib.enderwizards.sandstone.util;

import net.minecraft.nbt.NBTTagCompound;

public abstract class WorldSaveFile {
    public final String filename;
    private boolean wasModified = false;

    public WorldSaveFile(String filename) {
        this.filename = filename;
    }

    protected void setModified() {
        this.wasModified = true;
    }

    public boolean wasModified() {
        return this.wasModified;
    }

    public final void saveToNBT(NBTTagCompound nbt) {
        this.wasModified = false;
        this.onSave(nbt);
    }

    public final void loadFromNBT(NBTTagCompound nbt) {
        this.wasModified = false;
        this.onLoad(nbt);
    }

    protected abstract void onSave(NBTTagCompound var1);

    protected abstract void onLoad(NBTTagCompound var1);
}

