/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import cpw.mods.fml.relauncher.ReflectionHelper;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.setup.Registry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityUtils {
    public static EntityPlayer findPlayerFromUUID(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        MinecraftServer mcs = MinecraftServer.func_71276_C();
        if (mcs == null) {
            return null;
        }
        List playerList = mcs.func_71203_ab().field_72404_b;
        for (EntityPlayer player : playerList) {
            if (!player.func_110124_au().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static Entity findEntityByUUID(List<Entity> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static Entity getBottomEntity(Entity entity) {
        Entity ent = entity;
        while (ent != null && ent.field_70154_o != null) {
            ent = ent.field_70154_o;
        }
        return ent;
    }

    public static Entity getTopEntity(Entity entity) {
        Entity ent = entity;
        while (ent != null && ent.field_70153_n != null) {
            ent = ent.field_70153_n;
        }
        return ent;
    }

    public static boolean doesEntityStackHavePlayers(Entity entity) {
        Entity ent = entity;
        while (ent != null) {
            if (ent instanceof EntityPlayer) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entity.field_70153_n;
        while (ent != null) {
            if (ent instanceof EntityPlayer) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean doesEntityStackContainEntity(Entity entity, Entity entityInStack) {
        Entity ent = entityInStack;
        while (ent != null) {
            if (ent == entity) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entityInStack.field_70153_n;
        while (ent != null) {
            if (ent == entity) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean doesEntityStackHaveBlacklistedEntities(Entity entity) {
        List<String> blacklist = Registry.getTeleportBlacklist();
        Entity ent = entity;
        while (ent != null) {
            if (blacklist.contains(ent.getClass().getSimpleName())) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entity.field_70153_n;
        while (ent != null) {
            if (blacklist.contains(ent.getClass().getSimpleName())) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean unmountRider(Entity entity) {
        if (entity != null && entity.field_70153_n != null) {
            entity.field_70153_n.func_70078_a(null);
            return true;
        }
        return false;
    }

    public static boolean unmountRidden(Entity entity) {
        if (entity != null && entity.field_70154_o != null) {
            entity.func_70078_a(null);
            return true;
        }
        return false;
    }

    public static boolean applyMobPersistence(EntityLiving livingBase) {
        EntityLiving living = livingBase;
        if (!living.func_104002_bU()) {
            boolean canDespawn = living instanceof EntityMob || living instanceof EntityWaterMob;
            canDespawn |= living instanceof EntityTameable && !((EntityTameable)living).func_70909_n();
            Method method = ReflectionHelper.findMethod(EntityLiving.class, (Object)living, (String[])new String[]{"canDespawn", "v", "func_70692_ba"}, (Class[])new Class[0]);
            try {
                Object o = method.invoke((Object)living, new Object[0]);
                if (o instanceof Boolean) {
                    canDespawn |= ((Boolean)o).booleanValue();
                }
            }
            catch (ReflectionHelper.UnableToFindMethodException e) {
                EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (UnableToFindMethodException)");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (InvocationTargetException)");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (IllegalAccessException)");
                e.printStackTrace();
            }
            if (canDespawn) {
                living.func_110163_bv();
                return true;
            }
        }
        return false;
    }

    public static boolean spawnEnderCrystal(World world, int x, int y, int z) {
        if (world != null && world.field_73011_w != null) {
            if (world.field_73011_w.field_76574_g == 1 && world.func_147439_a(x, y, z) == Blocks.field_150357_h) {
                List entities = world.func_72872_a(EntityEnderCrystal.class, AxisAlignedBB.func_72330_a((double)(x - 2), (double)(y - 2), (double)(z - 2), (double)(x + 2), (double)(y + 2), (double)(z + 2)));
                if (!entities.isEmpty()) {
                    return false;
                }
                for (int by = y - 6; by < y; ++by) {
                    for (int bx = x - 1; bx <= x + 1; ++bx) {
                        for (int bz = z - 1; bz <= z + 1; ++bz) {
                            if (world.func_147439_a(bx, by, bz) == Blocks.field_150343_Z) continue;
                            return false;
                        }
                    }
                }
                world.func_72876_a(null, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, 10.0f, true);
                EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(world);
                entityendercrystal.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityendercrystal);
                return true;
            }
            if (world.field_73011_w.field_76574_g != 1) {
                EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(world);
                entityendercrystal.func_70012_b((double)x + 0.5, (double)y + 1.0, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityendercrystal);
            }
        }
        return false;
    }

    public static boolean addAITaskAfterTasks(EntityLiving entity, EntityAIBase task, Class[] afterTasks) {
        if (entity == null) {
            return false;
        }
        EntityAITasks tasks = entity.field_70714_bg;
        for (EntityAITasks.EntityAITaskEntry e : tasks.field_75782_a) {
            if (e.field_75733_a.getClass() != task.getClass()) continue;
            return true;
        }
        int priority = -1;
        for (EntityAITasks.EntityAITaskEntry e : tasks.field_75782_a) {
            for (Class clazz : afterTasks) {
                if (priority > e.field_75731_b || !clazz.isAssignableFrom(e.field_75733_a.getClass())) continue;
                priority = e.field_75731_b + 1;
            }
        }
        if (priority == -1) {
            priority = 0;
        }
        tasks.func_75776_a(priority, task);
        return true;
    }
}

