/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.block.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.block.machine.Machine;
import fi.dy.masa.enderutilities.client.effects.Particles;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MachineEnderFurnace
extends Machine {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOnSlow;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOnFast;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFrontOnNofuel;

    public MachineEnderFurnace(int index, int meta, String name, Class<? extends TileEntityEnderUtilities> TEClass, String tool, int harvestLevel, float hardness) {
        super(index, meta, name, TEClass, tool, harvestLevel, hardness);
    }

    @Override
    public boolean breakBlock(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityEnderFurnace) {
            TileEntityEnderFurnace teef = (TileEntityEnderFurnace)te;
            BlockEnderUtilitiesInventory.dropItemStacks(world, x, y, z, teef.getOutputBufferStack(), teef.getOutputBufferAmount(), true);
        }
        return false;
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityEnderFurnace) {
            TileEntityEnderFurnace teef = (TileEntityEnderFurnace)te;
            if (teef.isBurning()) {
                return 15;
            }
            if (teef.burnTimeFresh != 0) {
                return 7;
            }
        }
        return block.func_149750_m();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side) {
        if (side == 0 || side == 1) {
            return this.iconTop;
        }
        if (side == 3) {
            return this.iconFront;
        }
        return this.iconSide;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(TileEntityEnderUtilities te, int side) {
        if (side == 0 || side == 1) {
            return this.iconTop;
        }
        if (te != null && te instanceof TileEntityEnderFurnace && side == ((TileEntityEnderFurnace)te).getRotation()) {
            if (!((TileEntityEnderFurnace)te).isActive) {
                return this.iconFront;
            }
            if (((TileEntityEnderFurnace)te).usingFuel) {
                if (((TileEntityEnderFurnace)te).operatingMode == 1) {
                    return this.iconFrontOnFast;
                }
                return this.iconFrontOnSlow;
            }
            return this.iconFrontOnNofuel;
        }
        return this.iconSide;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerIcons(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a(ReferenceTextures.getTileName("enderfurnace") + ".side");
        this.iconTop = iconRegister.func_94245_a(ReferenceTextures.getTileName("enderfurnace") + ".top");
        this.iconFront = iconRegister.func_94245_a(ReferenceTextures.getTileName("enderfurnace") + ".front.off");
        this.iconFrontOnSlow = iconRegister.func_94245_a(ReferenceTextures.getTileName("enderfurnace") + ".front.on.slow");
        this.iconFrontOnFast = iconRegister.func_94245_a(ReferenceTextures.getTileName("enderfurnace") + ".front.on.fast");
        this.iconFrontOnNofuel = iconRegister.func_94245_a(ReferenceTextures.getTileName("enderfurnace") + ".front.on.nofuel");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityEnderFurnace && ((TileEntityEnderFurnace)te).isActive) {
            Particles.spawnParticlesAround(world, "portal", x, y, z, 2, rand);
        }
    }
}

