/*
 * Decompiled with CFR 0.152.
 */
package openeye.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import openeye.storage.GsonStorageBase;
import openeye.storage.IDataSource;
import openeye.storage.IQueryableStorage;

public class GsonPredefinedStorage<T>
extends GsonStorageBase<T>
implements IQueryableStorage<T> {
    private final Map<String, IDataSource<T>> sources;

    public GsonPredefinedStorage(File dir, Class<? extends T> cls, Gson gson, String ... ids) {
        super(cls, gson, "json");
        Preconditions.checkArgument((boolean)dir.isDirectory());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String id : ids) {
            File f = new File(dir, id + ".json");
            builder.put((Object)id, this.createFromFile(id, f));
        }
        this.sources = builder.build();
    }

    @Override
    public Collection<IDataSource<T>> listAll() {
        return this.sources.values();
    }

    @Override
    public IDataSource<T> getById(String id) {
        return this.sources.get(id);
    }

    @Override
    protected void removeEntry(String id) {
    }
}

