/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;
import openeye.logic.Config;
import openeye.logic.Sanitizers;
import openeye.logic.StateHolder;
import openeye.logic.Storages;
import openeye.logic.ThrowableLogger;

public class Bootstrap {
    public static final Bootstrap instance = new Bootstrap();
    private boolean runtimeDeobfuscationEnabled;
    private List<ITweaker> tweakers;
    private LaunchClassLoader loader;
    private File mcLocation;
    private File selfLocation;

    private Bootstrap() {
    }

    public void populateFromInject(Map<String, Object> data) {
        this.runtimeDeobfuscationEnabled = (Boolean)data.get("runtimeDeobfuscationEnabled");
        this.tweakers = (List)data.get("coremodList");
    }

    public void populateFromSetupClass(Map<String, Object> data) {
        this.loader = (LaunchClassLoader)data.get("classLoader");
        this.mcLocation = (File)data.get("mcLocation");
        this.selfLocation = (File)data.get("coremodLocation");
    }

    public void startup() {
        Preconditions.checkNotNull((Object)this.mcLocation, (Object)"Failed to start OpenEye, no minecraft folder available");
        Config.load(this.mcLocation);
        Storages storages = Storages.init(this.mcLocation);
        StateHolder.init(storages);
        Sanitizers.addMinecraftPath(this.mcLocation);
        ThrowableLogger.init();
    }

    public boolean isRuntimeDeobfuscationEnabled() {
        return this.runtimeDeobfuscationEnabled;
    }

    public List<ITweaker> getTweakers() {
        return this.tweakers;
    }

    public LaunchClassLoader getLoader() {
        return this.loader;
    }

    public File getMcLocation() {
        return this.mcLocation;
    }

    public File getSelfLocation() {
        return this.selfLocation;
    }
}

