/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import java.util.Map;
import java.util.Set;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Alias;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;

@Asynchronous
@AdapterSourceName(value="glasses_container")
public interface IDrawableContainer {
    @Alias(value={"getObjectById"})
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get object by id")
    public Drawable getById(@Arg(name="id", description="Id of drawed object") int var1);

    @ScriptCallable(description="Clear all the objects from the screen")
    public void clear();

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get the Ids of all the objects on the screen")
    public Set<Integer> getAllIds();

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get all objects on the screen")
    public Map<Integer, Drawable> getAllObjects();

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a new text object to the screen")
    public Drawable addText(@Arg(name="x", description="The x position from the top left") short var1, @Arg(name="y", description="The y position from the top left") short var2, @Arg(name="text", description="The text to display") String var3, @Optionals @Arg(name="color", description="The text color") Integer var4);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a new box to the screen")
    public Drawable addBox(@Arg(name="x", description="The x position from the top left") short var1, @Arg(name="y", description="The y position from the top left") short var2, @Arg(name="width", description="The width of the box") short var3, @Arg(name="height", description="The height of the box") short var4, @Optionals @Arg(name="color", description="The color of the box") Integer var5, @Arg(name="opacity", description="The opacity of the box (from 0 to 1)") Float var6);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a new gradient box to the screen")
    public Drawable addGradientBox(@Arg(name="x", description="The x position from the top left") short var1, @Arg(name="y", description="The y position from the top left") short var2, @Arg(name="width", description="The width of the box") short var3, @Arg(name="height", description="The height of the box") short var4, @Arg(name="color", description="The color of the box") int var5, @Arg(name="opacity", description="The opacity of the box (from 0 to 1)") float var6, @Arg(name="color2", description="The color of the other side of the box") int var7, @Arg(name="opacity2", description="The opacity of the other side of the box (from 0 to 1)") float var8, @Arg(name="gradient", description="The gradient direction (1 for horizontal, 2 for vertical)") int var9);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add an icon of an item to the screen")
    public Drawable addIcon(@Arg(name="x", description="The x position from the top left") short var1, @Arg(name="y", description="The y position from the top left") short var2, @Arg(name="id", description="The id of the item to draw") String var3, @Optionals @Arg(name="meta", description="The meta of the item to draw") Short var4);

    @Alias(value={"addFluid"})
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a box textured like a liquid to the screen")
    public Drawable addLiquid(@Arg(name="x", description="The x position from the top left") short var1, @Arg(name="y", description="The y position from the top left") short var2, @Arg(name="width", description="The width of the liquid box") short var3, @Arg(name="height", description="The height of the liquid box") short var4, @Arg(name="liquid", description="The name of the fluid to render") String var5);
}

