/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import openblocks.client.gui.GuiProjector;
import openblocks.common.HeightMapData;
import openblocks.common.MapDataManager;
import openblocks.common.container.ContainerProjector;
import openblocks.common.item.ItemEmptyMap;
import openblocks.common.item.ItemHeightMap;
import openblocks.rpc.IRotatable;
import openmods.api.IHasGui;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableByte;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityProjector
extends SyncedTileEntity
implements IHasGui,
IInventoryProvider,
ISyncListener,
IRotatable {
    private GenericInventory inventory = new TileEntityInventory((TileEntity)this, "openblocks.projector", false, 1){

        public boolean func_94041_b(int i, ItemStack stack) {
            if (stack == null) {
                return false;
            }
            Item item = stack.func_77973_b();
            return item instanceof ItemHeightMap || item instanceof ItemEmptyMap;
        }

        public int func_70297_j_() {
            return 1;
        }

        public void onInventoryChanged(int slotNumber) {
            super.onInventoryChanged(slotNumber);
            if (!TileEntityProjector.this.func_145837_r()) {
                if (!((TileEntityProjector)TileEntityProjector.this).field_145850_b.field_72995_K) {
                    ItemStack stack = this.func_70301_a(slotNumber);
                    if (stack != null && stack.field_77994_a == 1) {
                        Item item = stack.func_77973_b();
                        if (item instanceof ItemHeightMap) {
                            int mapId = stack.func_77960_j();
                            TileEntityProjector.this.mapId.set(mapId);
                        } else if (item instanceof ItemEmptyMap && TileEntityProjector.this.field_145850_b != null) {
                            ItemStack newStack = ItemEmptyMap.upgradeToMap(TileEntityProjector.this.field_145850_b, stack);
                            this.func_70299_a(slotNumber, newStack);
                        } else {
                            TileEntityProjector.this.mapId.set(-1);
                        }
                    } else {
                        TileEntityProjector.this.mapId.set(-1);
                    }
                    TileEntityProjector.this.sync();
                }
                TileEntityProjector.this.markUpdated();
            }
        }
    };
    private SyncableByte rotation;
    private SyncableInt mapId;

    public TileEntityProjector() {
        this.syncMap.addUpdateListener((ISyncListener)this);
    }

    protected void createSyncedFields() {
        this.rotation = new SyncableByte();
        this.mapId = new SyncableInt(-1);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 1));
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.inventory.onInventoryChanged(0);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerProjector((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiProjector(new ContainerProjector((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public void onSync(Set<ISyncableObject> changes) {
        int mapId;
        if (changes.contains(this.mapId) && (mapId = this.mapId.get()) >= 0 && MapDataManager.getMapData(this.field_145850_b, mapId).isEmpty()) {
            MapDataManager.requestMapData(this.field_145850_b, mapId);
        }
    }

    @Override
    public void rotate(int delta) {
        int value = this.rotation.get() + delta;
        this.rotation.set((byte)(value & 3));
        this.sync();
    }

    public byte rotation() {
        return this.rotation.get();
    }

    public int mapId() {
        return this.mapId.get();
    }

    public HeightMapData getMap() {
        int mapId = this.mapId.get();
        if (this.field_145850_b == null || mapId < 0) {
            return null;
        }
        return MapDataManager.getMapData(this.field_145850_b, mapId);
    }

    public void markMapDirty() {
        int mapId = this.mapId.get();
        if (this.field_145850_b != null || mapId < 0) {
            MapDataManager.instance.markDataUpdated(this.field_145850_b, mapId);
        }
    }

    public void fetchMap() {
        int mapId = this.mapId.get();
        if (this.field_145850_b != null && mapId >= 0) {
            MapDataManager.getMapData(this.field_145850_b, mapId);
        }
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }
}

