/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import openmods.OpenMods;

public class PedometerHandler {
    private static final String PROPERTY_PEDOMETER = "Pedometer";

    public static Vec3 getEntityPosition(Entity entity) {
        return Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
    }

    public static Vec3 subtract(Vec3 a, Vec3 b) {
        return Vec3.func_72443_a((double)(a.field_72450_a - b.field_72450_a), (double)(a.field_72448_b - b.field_72448_b), (double)(a.field_72449_c - b.field_72449_c));
    }

    public static PedometerState getProperty(Entity entity) {
        PedometerState state;
        IExtendedEntityProperties property = entity.getExtendedProperties(PROPERTY_PEDOMETER);
        if (property instanceof PedometerState) {
            state = (PedometerState)property;
        } else {
            state = new PedometerState();
            entity.registerExtendedProperties(PROPERTY_PEDOMETER, (IExtendedEntityProperties)state);
        }
        return state;
    }

    public static void reset(Entity entity) {
        PedometerState state = PedometerHandler.getProperty(entity);
        state.reset();
    }

    public static void updatePedometerData(Entity entity) {
        PedometerState state;
        IExtendedEntityProperties property = entity.getExtendedProperties(PROPERTY_PEDOMETER);
        if (property instanceof PedometerState && (state = (PedometerState)property).isRunning) {
            state.update(entity);
        }
    }

    public static class PedometerData {
        public final Vec3 startingPoint;
        public final long totalTime;
        public final double totalDistance;
        public final double straightLineDistance;
        public final double lastCheckDistance;
        public final long lastCheckTime;
        public final double currentSpeed;

        private PedometerData(Vec3 startingPoint, long totalTime, double totalDistance, double straightLineDistance, double lastCheckDistance, long lastCheckTime, double currentSpeed) {
            this.startingPoint = startingPoint;
            this.totalTime = totalTime;
            this.totalDistance = totalDistance;
            this.straightLineDistance = straightLineDistance;
            this.lastCheckDistance = lastCheckDistance;
            this.lastCheckTime = lastCheckTime;
            this.currentSpeed = currentSpeed;
        }

        public double averageSpeed() {
            if (this.totalTime == 0L) {
                return 0.0;
            }
            return this.totalDistance / (double)this.totalTime;
        }

        public double straightLineSpeed() {
            if (this.totalTime == 0L) {
                return 0.0;
            }
            return this.straightLineDistance / (double)this.totalTime;
        }

        public double lastCheckSpeed() {
            if (this.lastCheckTime == 0L) {
                return 0.0;
            }
            return this.lastCheckDistance / (double)this.lastCheckTime;
        }
    }

    public static class PedometerState
    implements IExtendedEntityProperties {
        private double totalDistance;
        private long startTicks;
        private Vec3 startPos;
        private Vec3 prevTickPos;
        private long prevTickTime;
        private Vec3 lastCheckPos;
        private long lastCheckTime;
        private PedometerData lastResult;
        private boolean isRunning;

        public void saveNBTData(NBTTagCompound compound) {
        }

        public void loadNBTData(NBTTagCompound compound) {
        }

        public void reset() {
            this.isRunning = false;
            this.totalDistance = 0.0;
            this.lastResult = null;
            this.lastCheckPos = null;
            this.lastCheckTime = 0L;
            this.prevTickPos = null;
            this.prevTickTime = 0L;
        }

        public void init(Entity entity, World world) {
            this.prevTickPos = this.startPos = PedometerHandler.getEntityPosition(entity);
            this.lastCheckPos = this.startPos;
            this.prevTickTime = this.startTicks = OpenMods.proxy.getTicks(world);
            this.lastCheckTime = this.startTicks;
            this.isRunning = true;
        }

        public void update(Entity entity) {
            Vec3 currentPosition = PedometerHandler.getEntityPosition(entity);
            Vec3 deltaSinceLastUpdate = PedometerHandler.subtract(currentPosition, this.prevTickPos);
            this.prevTickPos = currentPosition;
            long currentTime = OpenMods.proxy.getTicks(entity.field_70170_p);
            double ticksSinceLastUpdate = currentTime - this.prevTickTime;
            this.prevTickTime = currentTime;
            double distanceSinceLastTick = deltaSinceLastUpdate.func_72433_c();
            double currentSpeed = ticksSinceLastUpdate != 0.0 ? distanceSinceLastTick / ticksSinceLastUpdate : 0.0;
            this.totalDistance += distanceSinceLastTick;
            Vec3 deltaFromStart = PedometerHandler.subtract(currentPosition, this.startPos);
            long ticksFromStart = currentTime - this.startTicks;
            double distanceFromStart = deltaFromStart.func_72433_c();
            double distanceFromLastCheck = 0.0;
            if (this.lastCheckPos != null) {
                distanceFromLastCheck = PedometerHandler.subtract(currentPosition, this.lastCheckPos).func_72433_c();
            }
            long timeFromLastCheck = currentTime - this.lastCheckTime;
            this.lastResult = new PedometerData(this.startPos, ticksFromStart, this.totalDistance, distanceFromStart, distanceFromLastCheck, timeFromLastCheck, currentSpeed);
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public PedometerData getData() {
            this.lastCheckPos = this.prevTickPos;
            this.lastCheckTime = this.prevTickTime;
            return this.lastResult;
        }
    }
}

