/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import openblocks.client.renderer.tileentity.tank.DiagonalConnection;
import openblocks.client.renderer.tileentity.tank.DoubledCoords;
import openblocks.client.renderer.tileentity.tank.GridConnection;
import openblocks.client.renderer.tileentity.tank.HorizontalConnection;
import openblocks.client.renderer.tileentity.tank.ITankConnections;
import openblocks.client.renderer.tileentity.tank.ITankRenderFluidData;
import openblocks.client.renderer.tileentity.tank.RenderConnection;
import openblocks.client.renderer.tileentity.tank.TankRenderUtils;
import openblocks.client.renderer.tileentity.tank.VerticalConnection;
import openblocks.common.tileentity.TileEntityTank;
import openmods.liquids.GenericTank;
import openmods.utils.Diagonal;

public class TankRenderLogic
implements ITankConnections,
ITankRenderFluidData {
    private int x;
    private int y;
    private int z;
    private World world;
    private final GenericTank tank;
    private final Map<Diagonal, DiagonalConnection> diagonalConnections = Maps.newEnumMap(Diagonal.class);
    private final Map<ForgeDirection, HorizontalConnection> horizontalConnections = Maps.newEnumMap(ForgeDirection.class);
    private VerticalConnection topConnection;
    private VerticalConnection bottomConnection;
    private float phase;

    public TankRenderLogic(GenericTank tank) {
        this.tank = tank;
    }

    private static boolean isConnected(GridConnection connection) {
        return connection != null ? connection.isConnected() : false;
    }

    private DoubledCoords createCoords(ForgeDirection dir) {
        return new DoubledCoords(this.x, this.y, this.z, dir);
    }

    private DoubledCoords createCoords(Diagonal dir) {
        return new DoubledCoords(this.x, this.y, this.z, dir);
    }

    private ITankConnections getNeighbourTank(int x, int y, int z) {
        TileEntity te = TankRenderUtils.getTileEntitySafe(this.world, x, y, z);
        return te instanceof TileEntityTank ? ((TileEntityTank)te).getRenderConnectionsData() : null;
    }

    private ITankConnections getNeighbourTank(ForgeDirection dir) {
        return this.getNeighbourTank(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
    }

    private ITankConnections getNeighbourTank(Diagonal dir) {
        return this.getNeighbourTank(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
    }

    private DiagonalConnection selectDiagonalConnection(ITankConnections tankCW, ITankConnections tankD, ITankConnections tankCCW, Diagonal dir) {
        Diagonal start = dir;
        dir = dir.rotateCW();
        if (tankCW != null) {
            return tankCW.getDiagonalConnection(dir);
        }
        dir = dir.rotateCW();
        if (tankD != null) {
            return tankD.getDiagonalConnection(dir);
        }
        dir = dir.rotateCW();
        if (tankCCW != null) {
            return tankCCW.getDiagonalConnection(dir);
        }
        return new DiagonalConnection(TankRenderUtils.calculatePhase(this.x, this.y, this.z, start), this.createCoords(start));
    }

    private void tryCornerConnection(ITankConnections tankCW, ITankConnections tankD, ITankConnections tankCCW, Diagonal dir) {
        DiagonalConnection connection = this.selectDiagonalConnection(tankCW, tankD, tankCCW, dir);
        this.diagonalConnections.put(dir, connection);
    }

    private void tryHorizontalConnection(ITankConnections neighbour, ForgeDirection dir) {
        HorizontalConnection connection = neighbour != null ? neighbour.getHorizontalConnection(dir.getOpposite()) : new HorizontalConnection(this.createCoords(dir));
        this.horizontalConnections.put(dir, connection);
    }

    private void tryBottomConnection(ITankConnections neighbour) {
        this.bottomConnection = neighbour != null ? neighbour.getTopConnection() : new VerticalConnection(this.createCoords(ForgeDirection.DOWN));
    }

    private void tryTopConnection(ITankConnections neighbour) {
        this.topConnection = neighbour != null ? neighbour.getBottomConnection() : new VerticalConnection(this.createCoords(ForgeDirection.UP));
    }

    public void updateConnections() {
        ITankConnections tankN = this.getNeighbourTank(ForgeDirection.NORTH);
        ITankConnections tankS = this.getNeighbourTank(ForgeDirection.SOUTH);
        ITankConnections tankW = this.getNeighbourTank(ForgeDirection.WEST);
        ITankConnections tankE = this.getNeighbourTank(ForgeDirection.EAST);
        ITankConnections tankNE = this.getNeighbourTank(Diagonal.NE);
        ITankConnections tankNW = this.getNeighbourTank(Diagonal.NW);
        ITankConnections tankSE = this.getNeighbourTank(Diagonal.SE);
        ITankConnections tankSW = this.getNeighbourTank(Diagonal.SW);
        ITankConnections tankT = this.getNeighbourTank(ForgeDirection.UP);
        ITankConnections tankB = this.getNeighbourTank(ForgeDirection.DOWN);
        this.tryTopConnection(tankT);
        this.tryBottomConnection(tankB);
        this.tryHorizontalConnection(tankN, ForgeDirection.NORTH);
        this.tryHorizontalConnection(tankS, ForgeDirection.SOUTH);
        this.tryHorizontalConnection(tankW, ForgeDirection.WEST);
        this.tryHorizontalConnection(tankE, ForgeDirection.EAST);
        this.tryCornerConnection(tankN, tankNW, tankW, Diagonal.NW);
        this.tryCornerConnection(tankW, tankSW, tankS, Diagonal.SW);
        this.tryCornerConnection(tankE, tankNE, tankN, Diagonal.NE);
        this.tryCornerConnection(tankS, tankSE, tankE, Diagonal.SE);
    }

    public void initialize(World world, int x, int y, int z) {
        this.phase = TankRenderUtils.calculatePhase(x, y, z);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.updateConnections();
    }

    public void clearConnections() {
        for (Map.Entry<Diagonal, DiagonalConnection> entry : this.diagonalConnections.entrySet()) {
            entry.getValue().clearFluid(entry.getKey().getOpposite());
        }
        this.diagonalConnections.clear();
        for (Map.Entry<Object, RenderConnection> entry : this.horizontalConnections.entrySet()) {
            ((HorizontalConnection)entry.getValue()).clearFluid(((ForgeDirection)entry.getKey()).getOpposite());
        }
        this.horizontalConnections.clear();
        if (this.topConnection != null) {
            this.topConnection.clearBottomFluid();
            this.topConnection = null;
        }
        if (this.bottomConnection != null) {
            this.bottomConnection.clearTopFluid();
            this.bottomConnection = null;
        }
    }

    private boolean checkConnection(RenderConnection connection, ForgeDirection dir) {
        return connection == null || !connection.check(this.x, this.y, this.z, dir);
    }

    private boolean checkConnection(RenderConnection connection, Diagonal dir) {
        return connection == null || !connection.check(this.x, this.y, this.z, dir);
    }

    private boolean checkHorizontalConnection(ForgeDirection dir) {
        return this.checkConnection((RenderConnection)this.horizontalConnections.get(dir), dir);
    }

    private boolean checkDiagonalConnection(Diagonal dir) {
        return this.checkConnection((RenderConnection)this.diagonalConnections.get(dir), dir);
    }

    private boolean checkConnections() {
        return this.checkConnection((RenderConnection)this.topConnection, ForgeDirection.UP) || this.checkConnection((RenderConnection)this.bottomConnection, ForgeDirection.DOWN) || this.checkConnection((RenderConnection)this.topConnection, ForgeDirection.UP) || this.checkHorizontalConnection(ForgeDirection.NORTH) || this.checkHorizontalConnection(ForgeDirection.SOUTH) || this.checkHorizontalConnection(ForgeDirection.EAST) || this.checkHorizontalConnection(ForgeDirection.WEST) || this.checkDiagonalConnection(Diagonal.NE) || this.checkDiagonalConnection(Diagonal.NW) || this.checkDiagonalConnection(Diagonal.SE) || this.checkDiagonalConnection(Diagonal.SW);
    }

    public void validateConnections() {
        if (this.checkConnections()) {
            this.clearConnections();
            this.updateConnections();
        }
    }

    public void updateFluid(FluidStack fluidStack) {
        for (Map.Entry<Diagonal, DiagonalConnection> entry : this.diagonalConnections.entrySet()) {
            entry.getValue().updateFluid(entry.getKey().getOpposite(), fluidStack);
        }
        for (Map.Entry<Object, RenderConnection> entry : this.horizontalConnections.entrySet()) {
            ((HorizontalConnection)entry.getValue()).updateFluid(((ForgeDirection)entry.getKey()).getOpposite(), fluidStack);
        }
        this.topConnection.updateBottomFluid(fluidStack, this.tank.getSpace() == 0);
        this.bottomConnection.updateTopFluid(fluidStack);
    }

    @Override
    public boolean shouldRenderFluidWall(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return !TankRenderLogic.isConnected(this.bottomConnection);
            }
            case UP: {
                return !TankRenderLogic.isConnected(this.topConnection);
            }
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return !TankRenderLogic.isConnected(this.horizontalConnections.get(side));
            }
        }
        return true;
    }

    @Override
    public boolean hasFluid() {
        return this.tank.getFluidAmount() > 0;
    }

    @Override
    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @Override
    public float getCenterFluidLevel(float time) {
        float raw = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
        float waving = TankRenderUtils.calculateWaveAmplitude(time, this.phase) + raw;
        return TankRenderUtils.clampLevel(waving);
    }

    @Override
    public float getCornerFluidLevel(Diagonal corner, float time) {
        DiagonalConnection diagonal = this.diagonalConnections.get(corner);
        return diagonal != null ? diagonal.getRenderHeight(corner.getOpposite(), time) : this.getCenterFluidLevel(time);
    }

    @Override
    public VerticalConnection getTopConnection() {
        return this.topConnection;
    }

    @Override
    public VerticalConnection getBottomConnection() {
        return this.bottomConnection;
    }

    @Override
    public HorizontalConnection getHorizontalConnection(ForgeDirection dir) {
        return this.horizontalConnections.get(dir);
    }

    @Override
    public DiagonalConnection getDiagonalConnection(Diagonal dir) {
        return this.diagonalConnections.get(dir);
    }
}

