/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.StatCollector;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentBook;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.page.PageBase;

public class ChangelogPage
extends PageBase {
    private static final Function<String, String> BULLET_TRANSFORMER = new Function<String, String>(){

        public String apply(String value) {
            return "\u00b7" + value;
        }
    };
    private final GuiComponentLabel centerTitle;

    private int center(FontRenderer renderer, String text) {
        return (this.getWidth() - renderer.func_78256_a(text)) / 2;
    }

    public ChangelogPage(String currentVersion, String section, List<String> lines) {
        section = StatCollector.func_74838_a((String)section);
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        this.addComponent((BaseComponent)new GuiComponentLabel(this.center(renderer, section), 24, section));
        int titleMiddle = this.center(renderer, currentVersion);
        this.centerTitle = new GuiComponentLabel(titleMiddle, 12, currentVersion);
        this.addComponent((BaseComponent)this.centerTitle);
        String contents = Joiner.on((char)'\n').join(Iterables.transform(lines, BULLET_TRANSFORMER));
        GuiComponentLabel lblContent = new GuiComponentLabel(15, 40, this.getWidth() - 10, this.getHeight(), contents);
        lblContent.setScale(0.5f);
        lblContent.setAdditionalLineHeight(3);
        this.addComponent((BaseComponent)lblContent);
    }

    void addPrevVersionBookmark(GuiComponentBook book, String name, int page) {
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        int leftSize = renderer.func_78256_a(name) / 2;
        GuiComponentLabel bookmark = new GuiComponentLabel(this.centerTitle.getX() - 7 - leftSize, 14, "\u00a77" + name);
        bookmark.setListener(book.createBookmarkListener(page));
        bookmark.setScale(0.5f);
        this.addComponent((BaseComponent)bookmark);
    }

    void addNextVersionBookmark(GuiComponentBook book, String name, int page) {
        GuiComponentLabel bookmark = new GuiComponentLabel(this.centerTitle.getX() + this.centerTitle.getWidth() + 7, 14, "\u00a77" + name);
        bookmark.setListener(book.createBookmarkListener(page));
        bookmark.setScale(0.5f);
        this.addComponent((BaseComponent)bookmark);
    }
}

