/*
 * Decompiled with CFR 0.152.
 */
package org.wyldmods.simpleachievements.common.networking;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.wyldmods.simpleachievements.common.data.Element;

public class MessageSendAchievements
implements IMessage {
    List<Element> list;

    public MessageSendAchievements(List<Element> list) {
        this.list = list;
    }

    public void fromBytes(ByteBuf buf) {
        short len = buf.readShort();
        byte[] compressedBody = new byte[len];
        for (short i = 0; i < len; i = (short)(i + 1)) {
            compressedBody[i] = buf.readByte();
        }
        ObjectInputStream obj = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(compressedBody)));
        this.list = (List)obj.readObject();
        obj.close();
    }

    public void toBytes(ByteBuf buf) {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        ObjectOutputStream objStream = new ObjectOutputStream(gzip);
        objStream.writeObject(this.list);
        objStream.close();
        buf.writeShort(obj.size());
        buf.writeBytes(obj.toByteArray());
    }

    public MessageSendAchievements() {
    }
}

