/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.mcforge.dumpers;

import codechicken.nei.config.DataDumper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidDumper
extends DataDumper {
    public FluidDumper() {
        super("tools.dump.neiintegration_fluid");
    }

    public String[] header() {
        return new String[]{"ID", "Name", "Localized Name", "Temperature", "Luminosity", "Density", "Viscosity", "Placeable", "Block ID", "Block Class"};
    }

    public Iterable<String[]> dump(int mode) {
        LinkedList<String[]> list = new LinkedList<String[]>();
        ArrayList fluids = new ArrayList();
        fluids.addAll(FluidRegistry.getRegisteredFluids().values());
        Collections.sort(fluids, new Comparator<Fluid>(){

            @Override
            public int compare(Fluid f1, Fluid f2) {
                return Integer.compare(f1.getID(), f2.getID());
            }
        });
        for (Fluid f : fluids) {
            list.add(new String[]{String.valueOf(f.getID()), f.getName(), f.getLocalizedName(new FluidStack(f, 1000)), String.valueOf(f.getTemperature()), String.valueOf(f.getLuminosity()), String.valueOf(f.getDensity()), String.valueOf(f.getViscosity()), String.valueOf(f.canBePlacedInWorld()), f.getBlock() != null ? Block.field_149771_c.func_148750_c((Object)f.getBlock()) : null, f.getBlock() != null ? f.getBlock().getClass().getName() : null});
        }
        return list;
    }

    public int modeCount() {
        return 1;
    }
}

