/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.mcforge;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.oredict.OreDictionary;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;
import tonius.neiintegration.config.Config;

public class RecipeHandlerOreDictionary
extends RecipeHandlerBase {
    private static List<String> oreNames = new ArrayList<String>();

    @Override
    public void prepare() {
        oreNames.addAll(Arrays.asList(OreDictionary.getOreNames()));
        Collections.sort(oreNames);
    }

    public String getRecipeName() {
        return Utils.translate("handler.oreDictionary");
    }

    @Override
    public String getRecipeID() {
        return "forge.oreDictionary";
    }

    public String getGuiTexture() {
        return "neiintegration:textures/basicProcessing.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(68, 21, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)160, (int)65);
    }

    public void drawExtras(int recipe) {
        GuiDraw.drawStringC((String)((CachedOreDictionaryRecipe)((Object)this.arecipes.get((int)recipe))).oreName, (int)83, (int)5, (int)0x808080, (boolean)false);
    }

    @Override
    public List<String> provideTooltip(GuiRecipe guiRecipe, List<String> currenttip, RecipeHandlerBase.CachedBaseRecipe crecipe, Point relMouse) {
        if (new Rectangle(68, 21, 24, 17).contains(relMouse)) {
            currenttip.add(EnumChatFormatting.GRAY + Utils.translate("handler.oreDictionary.warning"));
        }
        return currenttip;
    }

    @Override
    public void loadAllRecipes() {
        if (Config.handler_oreDictionary) {
            for (String oreName : oreNames) {
                for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                    this.arecipes.add(new CachedOreDictionaryRecipe(oreName, ore, OreDictionary.getOres((String)oreName)));
                }
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        if (Config.handler_oreDictionary) {
            for (int id : OreDictionary.getOreIDs((ItemStack)ingred)) {
                for (String oreName : oreNames) {
                    if (!OreDictionary.getOreName((int)id).equals(oreName)) continue;
                    CachedOreDictionaryRecipe crecipe = new CachedOreDictionaryRecipe(oreName, new ItemStack(ingred.func_77973_b(), 1, ingred.func_77960_j()), OreDictionary.getOres((String)oreName));
                    crecipe.setIngredientPermutation(Collections.singletonList(crecipe.input), ingred);
                    this.arecipes.add(crecipe);
                }
            }
        }
    }

    public class CachedOreDictionaryRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public String oreName;
        public PositionedStack input;
        public PositionedStack output;

        public CachedOreDictionaryRecipe(String oreName, ItemStack input, List<ItemStack> outputs) {
            this.oreName = oreName;
            this.input = new PositionedStack((Object)input, 44, 22);
            this.output = new PositionedStack(outputs, 105, 22);
        }

        public PositionedStack getIngredient() {
            this.randomRenderPermutation(this.input, RecipeHandlerOreDictionary.this.cycleticks / 20);
            return this.input;
        }

        public PositionedStack getResult() {
            this.randomRenderPermutation(this.output, RecipeHandlerOreDictionary.this.cycleticks / 20);
            return this.output;
        }
    }
}

