/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.multiblock.IMultiBlockRoute;
import cofh.thermaldynamics.multiblock.Route;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraftforge.common.util.ForgeDirection;

public class RouteCache {
    public IMultiBlockRoute origin;
    public LinkedList<Route> outputRoutes;
    public LinkedList<Route> stuffableRoutes;
    public HashSet<IMultiBlockRoute> visited;
    public HashSet<IMultiBlockRoute> outputvisited;
    private LinkedList<Route> validRoutes;
    public int maxPathLength;
    private boolean isFinishedGenerating;
    public boolean invalid = false;

    public RouteCache(IMultiBlockRoute iMultiBlockRoute) {
        this(iMultiBlockRoute, iMultiBlockRoute.getMaxRange());
    }

    public RouteCache(IMultiBlockRoute iMultiBlockRoute, int n) {
        this.origin = iMultiBlockRoute;
        this.maxPathLength = n;
        this.init();
    }

    public void init() {
        this.outputRoutes = new LinkedList();
        if (this.origin.isOutput()) {
            Route route = new Route(this.origin);
            route.routeFinished = true;
            this.outputRoutes.add(route);
        }
        this.stuffableRoutes = new LinkedList();
        this.validRoutes = new LinkedList();
        this.validRoutes.add(new Route(this.origin));
        this.visited = new HashSet();
        this.visited.add(this.origin);
        this.outputvisited = new HashSet();
        if (this.origin.isOutput()) {
            this.outputvisited.add(this.origin);
        }
    }

    public synchronized void generateCache() {
        while (this.processStep()) {
        }
    }

    public boolean processStep() {
        if (this.isFinishedGenerating || this.invalid) {
            return false;
        }
        boolean bl = false;
        LinkedList<Route> linkedList = new LinkedList<Route>();
        for (Route route : this.validRoutes) {
            this.moveForwards(route, linkedList);
            if (route.routeFinished) continue;
            bl = true;
        }
        this.validRoutes.addAll(linkedList);
        if (!bl) {
            this.finished();
        }
        return bl;
    }

    private void finished() {
        this.visited.clear();
        this.outputvisited.clear();
        this.validRoutes.clear();
        this.isFinishedGenerating = true;
        Collections.sort(this.outputRoutes);
    }

    public void moveForwards(Route route, LinkedList<Route> linkedList) {
        boolean bl = false;
        IMultiBlockRoute iMultiBlockRoute = null;
        if (route.routeFinished) {
            return;
        }
        if (route.pathDirections.size() > this.maxPathLength) {
            route.routeFinished = true;
            return;
        }
        byte by = -1;
        for (byte by2 = 0; by2 < ForgeDirection.VALID_DIRECTIONS.length; by2 = (byte)(by2 + 1)) {
            IMultiBlockRoute iMultiBlockRoute2;
            if (route.endPoint.getCachedSideType(by2) != TileTDBase.NeighborTypes.MULTIBLOCK || route.endPoint.getConnectionType(by2) != TileTDBase.ConnectionTypes.NORMAL || (iMultiBlockRoute2 = (IMultiBlockRoute)route.endPoint.getCachedTile(by2)) == null) continue;
            if (!this.visited.contains(iMultiBlockRoute2)) {
                this.visited.add(iMultiBlockRoute2);
                iMultiBlockRoute2.onNeighborBlockChange();
                if (iMultiBlockRoute2.canStuffItem()) {
                    this.stuffableRoutes.add(new Route(route, iMultiBlockRoute2, by2, true));
                }
                if (!bl) {
                    iMultiBlockRoute = iMultiBlockRoute2;
                    by = by2;
                    bl = true;
                } else {
                    linkedList.add(new Route(route, iMultiBlockRoute2, by2, false));
                }
            }
            if (!iMultiBlockRoute2.isOutput() || this.outputvisited.contains(iMultiBlockRoute2)) continue;
            this.outputRoutes.add(new Route(route, iMultiBlockRoute2, by2, true));
            this.outputvisited.add(iMultiBlockRoute2);
        }
        if (!bl) {
            route.routeFinished = true;
        } else {
            route.pathDirections.add(by);
            route.pathWeight += iMultiBlockRoute.getWeight();
            route.endPoint = iMultiBlockRoute;
        }
    }

    public synchronized boolean isFinishedGenerating() {
        return this.isFinishedGenerating;
    }

    public void reset() {
        this.isFinishedGenerating = false;
        this.init();
    }

    public void invalidate() {
        this.invalid = true;
        this.outputRoutes.clear();
        this.stuffableRoutes.clear();
        this.origin = null;
    }
}

