/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.core.TickHandler;
import cofh.thermaldynamics.core.WorldGridList;
import cofh.thermaldynamics.debughelper.NoComodSet;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MultiBlockGrid {
    public NoComodSet<IMultiBlock> nodeSet = new NoComodSet();
    public NoComodSet<IMultiBlock> idleSet = new NoComodSet();
    public WorldGridList worldGrid;

    public MultiBlockGrid(WorldGridList worldGridList) {
        this.worldGrid = worldGridList;
        worldGridList.newGrids.add(this);
    }

    public MultiBlockGrid(World world) {
        this(TickHandler.getTickHandler(world));
    }

    public void addIdle(IMultiBlock iMultiBlock) {
        this.idleSet.add(iMultiBlock);
        if (this.nodeSet.contains(iMultiBlock)) {
            this.nodeSet.remove(iMultiBlock);
            this.onMajorGridChange();
        } else {
            boolean bl = false;
            for (byte by = 0; by < ForgeDirection.VALID_DIRECTIONS.length; by = (byte)(by + 1)) {
                if (!iMultiBlock.isSideConnected(by)) continue;
                if (bl) {
                    this.onMajorGridChange();
                    break;
                }
                bl = true;
            }
        }
        this.balanceGrid();
    }

    public void addNode(IMultiBlock iMultiBlock) {
        this.nodeSet.add(iMultiBlock);
        if (this.idleSet.contains(iMultiBlock)) {
            this.idleSet.remove(iMultiBlock);
        }
        this.onMajorGridChange();
        this.balanceGrid();
    }

    public void mergeGrids(MultiBlockGrid multiBlockGrid) {
        if (!multiBlockGrid.nodeSet.isEmpty()) {
            for (IMultiBlock iMultiBlock : multiBlockGrid.nodeSet) {
                iMultiBlock.setGrid(this);
                this.addBlock(iMultiBlock);
            }
            this.onMajorGridChange();
        }
        if (!multiBlockGrid.idleSet.isEmpty()) {
            for (IMultiBlock iMultiBlock : multiBlockGrid.idleSet) {
                iMultiBlock.setGrid(this);
                this.addBlock(iMultiBlock);
            }
            this.onMajorGridChange();
        }
        this.onMinorGridChange();
        multiBlockGrid.destroy();
    }

    public void destroy() {
        this.nodeSet.clear();
        this.idleSet.clear();
        this.worldGrid.oldGrids.add(this);
    }

    public boolean canGridsMerge(MultiBlockGrid multiBlockGrid) {
        return multiBlockGrid.getClass() == this.getClass();
    }

    public void resetMultiBlocks() {
        for (IMultiBlock iMultiBlock : this.nodeSet) {
            iMultiBlock.setValidForForming();
        }
        for (IMultiBlock iMultiBlock : this.idleSet) {
            iMultiBlock.setValidForForming();
        }
    }

    public void tickGrid() {
    }

    public void balanceGrid() {
    }

    public void addBlock(IMultiBlock iMultiBlock) {
        if (iMultiBlock.isNode()) {
            this.addNode(iMultiBlock);
        } else {
            this.addIdle(iMultiBlock);
        }
    }

    public void destroyAndRecreate() {
        this.worldGrid.gridsToRecreate.add(this);
    }

    public void removeBlock(IMultiBlock iMultiBlock) {
        this.destroyNode(iMultiBlock);
        if (iMultiBlock.isNode()) {
            this.nodeSet.remove(iMultiBlock);
            this.onMajorGridChange();
        } else {
            this.idleSet.remove(iMultiBlock);
        }
        if (this.nodeSet.isEmpty() && this.idleSet.isEmpty()) {
            this.worldGrid.oldGrids.add(this);
            return;
        }
        int n = 0;
        for (byte by = 0; by < 6; by = (byte)(by + 1)) {
            if (!iMultiBlock.isSideConnected(by)) continue;
            n = (byte)(n + 1);
        }
        if (n <= 1) {
            this.balanceGrid();
            this.onMinorGridChange();
            return;
        }
        this.onMajorGridChange();
        this.worldGrid.gridsToRecreate.add(this);
    }

    public void onMinorGridChange() {
    }

    public void onMajorGridChange() {
    }

    public int size() {
        return this.nodeSet.size() + this.idleSet.size();
    }

    public void doTickProcessing(long l) {
    }

    public boolean isTickProcessing() {
        return false;
    }

    public void destroyNode(IMultiBlock iMultiBlock) {
        iMultiBlock.setGrid(null);
    }

    public boolean isFirstMultiblock(IMultiBlock iMultiBlock) {
        return !this.nodeSet.isEmpty() ? this.nodeSet.iterator().next() == iMultiBlock : !this.idleSet.isEmpty() && this.idleSet.iterator().next() == iMultiBlock;
    }

    public abstract boolean canAddBlock(IMultiBlock var1);
}

