/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGridWithRoutes;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.world.World;

public class ItemGrid
extends MultiBlockGridWithRoutes {
    public int travelingItemsCount = 0;
    public static ArrayList<Attachment> toTick = new ArrayList();
    public HashMap<BlockCoord, StackMap> travelingItems = new HashMap();
    public boolean shouldRepoll = true;
    public boolean repoll = false;

    public ItemGrid(World world) {
        super(world);
    }

    @Override
    public void tickGrid() {
        this.repoll = this.shouldRepoll;
        if (this.shouldRepoll) {
            if (!this.travelingItems.isEmpty()) {
                this.travelingItems.clear();
            }
            this.travelingItemsCount = 0;
        }
        this.shouldRepoll = false;
        for (IMultiBlock object : this.nodeSet) {
            if (!object.tickPass(0)) break;
        }
        if (this.repoll || this.travelingItemsCount > 0) {
            for (IMultiBlock iMultiBlock : this.idleSet) {
                if (!iMultiBlock.tickPass(0)) break;
            }
        }
        if (!toTick.isEmpty()) {
            for (Attachment attachment : toTick) {
                attachment.tick(1);
            }
            for (Attachment attachment : toTick) {
                attachment.tick(2);
            }
            toTick.clear();
        }
        super.tickGrid();
    }

    @Override
    public boolean canAddBlock(IMultiBlock iMultiBlock) {
        return iMultiBlock instanceof TileItemDuct;
    }

    public void poll(TravelingItem travelingItem) {
        ++this.travelingItemsCount;
        if (travelingItem.myPath == null) {
            return;
        }
        BlockCoord blockCoord = travelingItem.getDest();
        StackMap stackMap = this.travelingItems.get(blockCoord);
        if (stackMap == null) {
            stackMap = new StackMap();
            this.travelingItems.put(blockCoord, stackMap);
        }
        stackMap.addItemEntry(travelingItem.getStackEntry(), travelingItem.stack.field_77994_a);
    }

    @Override
    public void onMinorGridChange() {
        super.onMinorGridChange();
        this.shouldRepoll = true;
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.shouldRepoll = true;
    }
}

